#ifndef CHUMP_H
#define CHUMP_H

#include <glib.h>
#include "symboltable.h"

#define uchar unsigned char

#define DEFINITIONSTRING "define"
#define INTIGERSTRING "int"
#define RELATIVESTRING "relative"
#define UINTIGERSTRING "uint"
#define URELATIVESTRING "urelative"
#define SYMBOLSTRING "symbol"
#define LABELSTRING "label"
#define COMMENTSTRING "comment"
#define ALIGNSTRING "align"
#define ASCIISTRING "ascii"
#define ENUMERATESTRING "enum"



typedef enum {NONTERM, TERM, TERM2FREE, NONTERM2FREE, SPLITNONTERM, SPLITNONTERM2FREE, LABEL, LABEL2FREE} RuleElementType;
typedef enum {TRANRULE, INTRULE, RELATIVERULE, UINTRULE, URELATIVERULE, LABELRULE, COMMENTRULE, ASCIIRULE, ALIGNRULE} RuleType; 
typedef enum {SPLIT, SPLIT2FREE} SplitType;



typedef struct DefinitionStackName{
 struct DefinitionStackName* next;
 char* string;
 GList* rules;
 } DefinitionStack;

typedef struct {
 char* string;
 RuleElementType type; 
 int twin;
 int twinsplit;
 GList* split;
 GList* rules;
 } RuleElement;
 
 
 
typedef struct {
 char* string;
 char* bitfield;
 int twin;
 int size;
 SplitType type;
 } SplitElement;
 

typedef struct {
 RuleType type;
 int size;
 GList* asci;
 GList* bit;
 } Rule;

typedef struct {
 GList* distext;
 char* bitfield;
} Disasm;

typedef struct {
 GList* binary;
 char*  text;
 GList* ruletext;
} Asm;

typedef struct {
SymbolTable* symbol_table;
long address;
int flags;
int limit;
} AsmStatus;

enum {
ASMFLAG_IGNORESYMBOLS = 0x1
};


GList dis_error;
char* dis_error_string;

const AsmStatus asm_default_status;

DefinitionStack* asm_parser (GList*);
DefinitionStack* asm_define (GList*, DefinitionStack*, char*);
Rule* 			 asm_rule   (GList*, DefinitionStack*);

Disasm asm_disassemble_number (char* bitfield, GList* rules, AsmStatus);
Disasm asm_disassemble_label  (char* bitfield, GList* rules, AsmStatus);
Disasm asm_disassemble_ascii  (char* bitfield, GList* rules, AsmStatus);
Disasm asm_disassemble        (char* bitfield, GList* rules, AsmStatus);

Asm* asm_assemble_number (char* text, GList* rules, AsmStatus, int last);
Asm* asm_assemble_label  (char* text, GList* rules, AsmStatus, int last);
Asm* asm_assemble_ascii  (char* text, GList* rules, AsmStatus, int last);
GList* asm_assemble(char*,GList* rules,AsmStatus,int);

Asm asm_assembleold(char*,GList* rules,int,int,int);
GList* uchararr2glist(int, uchar*);
char*  uchararr2str(int, uchar*);
void asm_print(GList*);
GList* asm_print_symbols (GList* list, GList* replylist);
char* asm_sprint (GList* list, char*);
void asm_freestringlist(GList*);
GList* asm_copystringlist(GList*);
char* asm_sprint_tabstring (char*,char*);
int asm_sbprint (GList* list, uchar** data);
int asm_getsymbol_length (char* c);
char asm_getchar(char* start, char** endptr);
int asm_isset(char c);

#endif
