#include "timeout.h"
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "emulcore.h"

int emul_bp_flag[2] = {0,-1};
int emul_wp_flag[2] = {0,-1};
int paused=0;

void commandline(int argc, char *argv[])
{
 int count=1;
 int comp;              // 

 char* pipe_name_out;
 char* pipe_name_in;
 int fid_in, fid_out;
 
 char* commandstrings[]={"--help", "-h", "-?", "-p", NULL};
            //             0         1     2     3     4   
 pipe_name_in = NULL;
 pipe_name_out = NULL;
 
 while (argv[count]) {
   if ('-' != *argv[count]) {printf("1%s\n",argv[count]);exit(1);}
   comp=0;
   while (strcmp(commandstrings[comp],argv[count]))
        if (!commandstrings[++comp]) {printf("2Unknown option  %s\n",argv[count]);exit(1);}

   switch (comp) {
    case 0:
    case 1:
    case 2:         //help
        printf("\n kmd_emulmips\n");
        printf(" Copyright University of Manchester \n");
        printf(" Authors:Charlie Brej & Jim Garside\n");
        printf(" Bug reports and feature requests: komodo@cs.man.ac.uk\n");
        printf(" Website: http://www.cs.man.ac.uk/teaching/electronics/komodo\n");
        printf("\n");
        printf(" Usage: kmd [options]\n");
        printf("\n");
        printf("   --help\n");
        printf("   -h\n");
        printf("   -?              display this help message\n");
        printf("   -p [rd] [wr]    run with emulator through pipes\n");
        exit(0);
    case 3:         //pipe -p
        if (argv[count+1]) if ('-' != *argv[count+1]) pipe_name_in = argv[++count];
        if (argv[count+1]) if ('-' != *argv[count+1]) pipe_name_out = argv[++count];
        printf("Running with emulator through pipes: %s and %s\n", pipe_name_in, pipe_name_out);
         
         {
         if (pipe_name_in){
            fid_in =  open (pipe_name_in, O_RDONLY);
            close(0);
            dup2(fid_in,0);
            }

         if (pipe_name_out){
             fid_out = open (pipe_name_out, O_WRONLY);
             close(1);
             dup2(fid_out,1);
             }
         }

        
        break;

        
    default:
        printf("Command paramiter Error!\n \"%s\"", argv[count]);
        exit(1);
    }
   count++;
   }

}





int main(int argc, char *argv[])
{
 uchar c=0;
 uchar* wotrustring=getwotrustring();
 char* pointer;
 int size;
 int data[2];
 int temp;
 char tempchar;
 
 commandline(argc, argv);



 

 
 
 
 
 while(1){
  while (! fd_ready (0, 1, 0))
        if (2 == (status>>6) && !paused) {
                status = execute_instruction();
                if (steps_togo) {
                    steps_togo--;
                    steps_reset++;
                    if (!steps_togo) status=0x40;
                    }
                }
        else { fd_ready (0, 1, -1); }
    
  board_getchar(&c);
    switch(c>>6){
       case 0:
          switch(c){
            case BR_NOP:
                break;
            case BR_PING:
                write(1,"OK00",4);
                break;
            case BR_WOT_R_U:
                board_sendchararray(wotrustring[0],wotrustring+1);
                break;
            case BR_RESET:
                boardreset();
                break;
            case BR_RTF_GET:
                board_sendchar(rtf);
                break;
            case BR_RTF_SET:
                board_getchar(&rtf);
                break;
            case BR_WOT_U_DO:
                board_sendchar(status);
                board_sendb32(steps_togo);
                board_sendb32(steps_reset);
                break;
            case BR_STOP:
                status=0x40;
                steps_togo=0;
                paused=0;
                break;
            case BR_PAUSE:
                paused=1;
                break;
            case BR_CONTINUE:
                status=0x80;
                paused=0;
                break;
            case BR_BP_GET:
                board_sendb32(emul_bp_flag[0]);
                board_sendb32(emul_bp_flag[1]);
                break;
            case BR_BP_SET:
                board_getb32(&data[0]);
                board_getb32(&data[1]);
                temp=data[1] & ~data[0];
                emul_bp_flag[0] &= ~temp;
                emul_bp_flag[1] |= temp;
                temp = data[0] & emul_bp_flag[0];
                emul_bp_flag[1] = (emul_bp_flag[1] & ~temp)
                                    | (data[1] & temp);
                break;
            case BR_BP_READ:
                board_getchar(&tempchar);
                temp=tempchar;
                board_sendchar(breakpoints[temp].cond);
                board_sendchar(breakpoints[temp].size);
                board_sendb32(breakpoints[temp].addra);
                board_sendb32(breakpoints[temp].addrb);
                board_sendb32(breakpoints[temp].dataa[0]);
                board_sendb32(breakpoints[temp].dataa[1]);
                board_sendb32(breakpoints[temp].datab[0]);
                board_sendb32(breakpoints[temp].datab[1]);
                break;                
            case BR_BP_WRITE:
                board_getchar(&tempchar);
                temp=tempchar;
                board_getchar(&breakpoints[temp].cond);
                board_getchar(&breakpoints[temp].size);
                board_getb32(&breakpoints[temp].addra);
                board_getb32(&breakpoints[temp].addrb);
                board_getb32(&breakpoints[temp].dataa[0]);
                board_getb32(&breakpoints[temp].dataa[1]);
                board_getb32(&breakpoints[temp].datab[0]);
                board_getb32(&breakpoints[temp].datab[1]);
                temp = (1<<temp) & ~emul_bp_flag[0];
                emul_bp_flag[0] |= temp;
                emul_bp_flag[1] |= temp;
                break;                
            case BR_WP_GET:
                board_sendb32(emul_wp_flag[0]);
                board_sendb32(emul_wp_flag[1]);
                break;
            case BR_WP_SET:
                board_getb32(&data[0]);
                board_getb32(&data[1]);
                temp=data[1] & ~data[0];
                emul_wp_flag[0] &= ~temp;
                emul_wp_flag[1] |= temp;
                temp = data[0] & emul_wp_flag[0];
                emul_wp_flag[1] = (emul_wp_flag[1] & ~temp)
                                    | (data[1] & temp);
                break;
            case BR_WP_READ:
                board_getchar(&tempchar);
                temp=tempchar;
                board_sendchar(watchpoints[temp].cond);
                board_sendchar(watchpoints[temp].size);
                board_sendb32 (watchpoints[temp].addra);
                board_sendb32 (watchpoints[temp].addrb);
                board_sendb32 (watchpoints[temp].dataa[0]);
                board_sendb32 (watchpoints[temp].dataa[1]);
                board_sendb32 (watchpoints[temp].datab[0]);
                board_sendb32 (watchpoints[temp].datab[1]);
                break;                
            case BR_WP_WRITE:
                board_getchar(&tempchar);
                temp=tempchar;
                board_getchar(&watchpoints[temp].cond);
                board_getchar(&watchpoints[temp].size);
                board_getb32(&watchpoints[temp].addra);
                board_getb32(&watchpoints[temp].addrb);
                board_getb32(&watchpoints[temp].dataa[0]);
                board_getb32(&watchpoints[temp].dataa[1]);
                board_getb32(&watchpoints[temp].datab[0]);
                board_getb32(&watchpoints[temp].datab[1]);
                temp = 1<<temp & ~emul_wp_flag[0];
                emul_wp_flag[0] |= temp;
                emul_wp_flag[1] |= temp;
                break;                
            default:
                break;
            }
          break;
       case 1:
        board_getb32(&size);
        if (c>>4&1) pointer = registers + ((size<<2)&(REGSIZE-1));
        else        pointer = memory    + (size     &(RAMSIZE-1));
        board_getb16(&size);
        size *= 1<<(c&7);
        if (((uchar*)pointer+size)>((uchar*)memory+RAMSIZE)) pointer -= RAMSIZE;
        if (c&8) board_sendchararray(size, pointer);
        else board_getchararray(size, pointer);
        break;
       case 2:
        runflags = c;
        status=0x80;
        board_getb32(&steps_togo);
        break;
    }
  afterinstruction(c);
  }
}




int board_getchar(unsigned char *to_get) /* get 1 char from board*/
{
 return board_getchararray(1,  to_get);
}

int board_sendchar(unsigned char to_send) /*send 1 char to the board*/
{
return board_sendchararray(1, &to_send);
}


int board_getb16(int* toget) /* get 16 bit int from board*/
{
 unsigned char from_board[2];
 if (2 != board_getchararray(2, from_board))     return 0;
 *toget=from_board[0]+(from_board[1]<<8);
 return 2;
}

int board_sendb16(int tosend) /* send 16 bit int to the board*/
{
 if (1 != board_sendchar((unsigned char) tosend & 255))
                                                 return 0;
 if (1 != board_sendchar((unsigned char) (tosend >> 8) & 255))
                                                 return 0;
 return 2;
}
		   
int board_sendb32(int tosend) /* get 32 bit int from board*/
{
 int x=4;
 while(x--){
   if (1 != board_sendchar((unsigned char) tosend & 255))
                                                 return 0;
   tosend = tosend>>8;
   }
 return 4;
}

int board_getb32(int* toget) /* send 32 bit int to the board*/
{
 int x=4;
 unsigned char temp;
 *toget=0;
 
for (x=0;x<4;x++){
   if (1 != board_getchar(&temp))            return 0;
   *toget= *toget | temp<<(x*8);
   }
   
 return 4;
}





int board_getchararray(int char_number, unsigned char* data_ptr)
{
 int ret=char_number; /* get char array from the board*/
 int replycount=0;
	while (char_number){
        if(!fd_ready (0, 1, -1)) return ret-char_number;
        replycount = read(0, data_ptr, char_number);
		if (replycount<0) replycount=0;
		char_number -= replycount;
//        while (replycount--) {printf ("reply:%x\n",*data_ptr); data_ptr++;}
        data_ptr += replycount;
		}
	
 return ret;
}

int board_sendchararray(int char_number, unsigned char* data_ptr)
{
// int temp=0;
// while(temp<char_number) printf ("sent:%x\n",data_ptr[temp++]);
 
 write(1, data_ptr, char_number);
 return char_number; /* send char array to the board*/
}

