/***************************************************************************
                          contactaddeduserdialog.h  -  description
                             -------------------
    begin                : Sun Apr 14 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTADDEDUSERDIALOG_H
#define CONTACTADDEDUSERDIALOG_H

#include <qcstring.h>
#include <qwidget.h>

#ifndef CONTACTADDEDUSERDIALOGINTERFACE_H
// Weird but it's required:
// TODO: g++ can't find this file if it's included from kmess.cpp
#include "contactaddeduserdialoginterface.h"
#endif

/**The dialog for when someone has added the user to his or her contact list.
  *@author Mike K. Bennett
  */

class ContactAddedUserDialog : public ContactAddedUserDialogInterface
{
  Q_OBJECT

  public:
  	                 ContactAddedUserDialog();
  	                ~ContactAddedUserDialog();

    // Show the dialog modally, then return the user's choice.
    int              launch(QString contactHandle, QString contactName);

    // Specify the return types for the dialog
    static const int ADD = 0, ALLOW = 1, BLOCK = 2;

  protected slots: // Protected slots
    // The user picked "add contact to the friends list".
    void             addContactPressed();
    // The user chose to let the contact view his or her online state, but
    //  not to add the contact.
    void             allowContactPressed();
    // The user chose to block the contact.
    void             blockContactPressed();

  private: // private attributes
    // The return value
    int              returnValue_;

};

#endif
