/***************************************************************************
                          notificationnewemail.h - notifies when a
                            new email has arrived
                             -------------------
    begin                : Tuesday April 10 2007
    copyright            : (C) 2007 by Valerio Pilo
    email                : amroth@coldshock.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NOTIFICATIONNEWEMAIL_H
#define NOTIFICATIONNEWEMAIL_H

#include "passivepopup.h"
#include "notificationmanager.h"
#include "../currentaccount.h"



/**
  * @brief Notifies the user when a new email is in the mailbox
  *
  * Notification is made via a popup balloon and a sound (which can be customized)
  *
  * @author Valerio Pilo <amroth@coldshock.net>
  */
class NotificationNewEmail : public QObject
{
  Q_OBJECT

  public:  // Public methods
    // Class constructor
    NotificationNewEmail( NotificationManager* manager );
    // Enable or disable the new email notifications
    void                  setEnabled( bool activate );

  public slots:
    // Notify the user about this event (a new email has arrived)
    void                  notify( QString sender, QString subject, bool inInbox, QString command, QString folder, QString url );

  private slots:
    // Trigger this event's action (Open the mailbox where the new mail is)
    void                  activate( QStringList stringList, QObject *object );

  private:  // Private properties
    // Current account reference
    CurrentAccount       *currentAccount_;
    // Notification status
    bool                  isEnabled_;
    // The notification manager instance
    NotificationManager  *manager_;
    // The popup object which we'll be using until it disappears or gets clicked
    PassivePopup         *popup_;

};


#endif
