/***************************************************************************
 *   Copyright (C) 2004 by Spiros Georgaras                                *
 *   sngeorgaras@otenet.gr                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <WAR.h>
#include <iostream>
#include <kdebug.h>
#include <qtextcodec.h>

#include <time.h>
#include <sys/stat.h> 
/*================================
================================*/
WAR::WAR()//: QObject(0,"WAR")
{
	numOfFiles=0;
	allocatedFiles=0;
	fileInMHT=0;
}
/*================================
================================*/
WAR::~WAR(){
	delete [] fileInMHT;
}
/*================================
================================*/
int WAR::setName(QString fileName, QString outPath,bool BeSilent, bool DoUseGui){
	QString fileDate=readDate(fileName);
	beSilent=BeSilent;
	doUseGui=DoUseGui;
	//qWarning("outPath = %s",outPath.latin1());
	archiveName=fileName;
	if(outPath.isEmpty()){
		outArchiveName=archiveName.replace(archiveName.length()-3,3,"mht");
	}else{
		// find out output file name
		int k=0,o=0;
		while((o=archiveName.find('/',o+1))!=-1) k=o;
		outArchiveName=archiveName.mid(k+1,archiveName.length());
		outArchiveName=outArchiveName.left(outArchiveName.length()-4);
		if(outPath.right(1)!='/') outArchiveName.prepend('/');
		outArchiveName.prepend(outPath);
		outArchiveName.append(".mht");
	}
	//qWarning("output file name = %s",outArchiveName.latin1());
	//open output file name
	QFile fOut( outArchiveName );
	if(!fOut.open( IO_WriteOnly )){
		emit errorAppeared(4);
		return 4;
	}else emit archiveOpened();
	QTextStream stream( &fOut );
	// extract files
	KTarGz tar( fileName );
	if ( !tar.open( IO_ReadOnly ) ){
		emit errorAppeared(1);
		return 1;
	}
	const KTarDirectory* dir = tar.directory();
	int ret = readWarDirectory( dir );
	if(ret!=0){
		tar.close();
		return ret;
	}
	// close output file name
	//stream << "From: <Saved by Microsoft Internet Explorer 5>\r\n";
	stream << "From: <Created with kmhtConvert 0.7.1>\r\nSubject: ";
	stream << title;
	stream << "\r\nDate: ";
	stream << fileDate;
	stream << "\r\nMIME-Version: 1.0\r\nContent-Type: multipart/related;\r\n	boundary=\"----=_NextPart_000_0009_01C34E66.2DA78590\";\r\n	type=\"text/html\"\r\nX-MimeOLE: Produced By kmhtConvert 0.5\r\n\r\nThis is a multi-part message in MIME format.\r\n\r\n";
	for(int i=0;i<numOfFiles;i++){
		writeHeader(i,&stream);
		stream << fileInMHT[i].outString;
		stream << "\r\n\r\n";
		if(i==numOfFiles-1) stream << "------=_NextPart_000_0009_01C34E66.2DA78590--\r\n";
	}
	fOut.close();
	tar.close();
	if(!doUseGui){
		if(!beSilent) std::cout << i18n(QString("Output file succesfully created")).local8Bit() << std::endl << std::endl;
	}else{
		emit archiveCreated(outArchiveName);
	}
	return 0;
}
/*================================
================================*/
int WAR::readWarDirectory( const KTarDirectory * dir)
{
	allocatedFiles=5;
	fileInMHT = new files[allocatedFiles];
	for(int i=0;i<numOfFiles;i++) fileInMHT[i].written=FALSE;
	QStringList l = dir->entries();
	QStringList::Iterator it = l.begin();
	for( ; it != l.end(); ++it ){
		const KTarEntry* entry = dir->entry( (*it) );
		fileInMHT[numOfFiles].inputName=*it;
		numOfFiles++;
		if(numOfFiles==allocatedFiles){
			// reallocate fileInMHT
			files * tmp=new files [allocatedFiles + 5];
			for(int i=0;i<numOfFiles;i++){
				tmp[i].inputName=fileInMHT[i].inputName;
				fileInMHT[i].written=FALSE;
			}
			allocatedFiles+=5;
			delete [] fileInMHT;
			fileInMHT=tmp;
		}
		if (entry->isDirectory()){
			errorAppeared(2);
			return 2;
		}
	}
	if(!doUseGui && !beSilent) std::cout << i18n(QString("Files in archive: ")).local8Bit() << numOfFiles << std::endl;
	emit foundFilesInArchive(numOfFiles);
	for(int i=0;i<numOfFiles;i++){
		if(!doUseGui && !beSilent) std::cout << "  " << i18n(QString("Extracting file: ")).local8Bit() << fileInMHT[i].inputName << " .... ";
		emit fileExtraced(fileInMHT[i].inputName);
		const KTarEntry* entry = dir->entry( fileInMHT[i].inputName );
		if(entry==NULL){
			errorAppeared(3);
			return 3;
		}
		const KTarFile* m_file = (KTarFile*)entry;
		QByteArray arr( m_file->data() );
		if(fileInMHT[i].inputName.right(3).lower()==".js"){
			fileInMHT[i].mime="application/octet-stream";
		}else{
			int accuracy=0;
			KMimeType::Ptr mt = KMimeType::findByContent(arr , &accuracy );
			fileInMHT[i].mime=mt->name();
		}
		if(fileInMHT[i].inputName=="index.html"){
			QCString arrString(arr);
			int found=arrString.find("charset=",0,FALSE);
			found+=8;
			if(found==-7) fileInMHT[i].type="iso-8859-1";
			else{
				int endFound=arrString.find('>',found);
				fileInMHT[i].type=arrString.mid(found,endFound-found-1);
			}
			found=arrString.find("<TITLE>",0,FALSE);
			found+=7;
			if(found==-6) title="Converted with kmhtConvert";
			else{
				int endFound=arrString.find('<',found);
				QTextCodec * cod=cod->codecForName(fileInMHT[i].type);
				if(cod!=0)
					title=cod->toUnicode(arrString.mid(found,endFound-found));
				else
					title=arrString.mid(found,endFound-found);
				title.replace("\n","");
				title.replace("\r","");
				title=toDOS(title).stripWhiteSpace();
			}
		}else fileInMHT[i].type="";
		if(fileInMHT[i].mime.mid(0,5)=="text/") fileInMHT[i].encoding=0;
		else fileInMHT[i].encoding=1;
		if(fileInMHT[i].encoding==0){
			//printf("file %d:%s %s %d\n", i+1,fileInMHT[i].inputName.latin1(),fileInMHT[i].mime.latin1(),fileInMHT[i].encoding);
			fileInMHT[i].outString=KCodecs::quotedPrintableEncode(arr,TRUE);
			//std::cout << fileInMHT[i].outString << std::endl;
		}else{
			//printf("file %d:%s %s %d\n", i+1,fileInMHT[i].inputName.latin1(),fileInMHT[i].mime.latin1(),fileInMHT[i].encoding);
			fileInMHT[i].outString=KCodecs::base64Encode(arr,TRUE);
			//std::cout << fileInMHT[i].outString << std::endl;
		}
		fileInMHT[i].outString=toDOS(fileInMHT[i].outString);
		if(!doUseGui && !beSilent) std::cout << i18n(QString("done")).local8Bit() << std::endl;
	}
	return 0;
}
/*================================
================================*/
void WAR::writeHeader(int id, QTextStream * str){
	*str << "------=_NextPart_000_0009_01C34E66.2DA78590\r\nContent-Type: ";
	*str << fileInMHT[id].mime;
	*str << ";";
	if(!fileInMHT[id].type.isEmpty()){
		*str << "\r\n	charset=\"";
		*str << fileInMHT[id].type;
		*str << "\"";
	}
	*str << "\r\nContent-Transfer-Encoding: ";
	switch(fileInMHT[id].encoding){
	case 0:
		*str << "quoted-printable";
		break;;
	case 1:
		*str << "base64";
		break;;
	case 2:
		*str << "uuencode";
		break;;
	case 3:
		*str << "7-bit";
		break;;
	case 4:
		*str << "8-bit";
		break;;
	}
	*str << "\r\nContent-Location: http://users.otenet.gr/~geosp/kmhtconvert/";
	*str << fileInMHT[id].inputName;
	*str << "\r\n\r\n";
}
/*================================
================================*/
QString WAR::readDate(QString str){
	QString toRet;
	struct stat statbuf;
	struct tm *tm;
	char ttime[255];
	char * t=ttime;
	if(stat(archiveName.local8Bit().data(), &statbuf) == -1){
		tm = localtime(&statbuf.st_mtime);
		t=asctime(tm);
		toRet=t;
		//kdDebug()<<"mDAY = " << toRet << endl;
		QString mDay=toRet.mid(8,2);
		if(mDay.startsWith(" ")) mDay.prepend(",");
		else mDay.prepend(", ");
		mDay.append(" ");
		//kdDebug()<<"mDAY = " << mDay << endl;
		QString mYear=toRet.mid(20,4);
		toRet.remove(8,2);
		//kdDebug()<<"mDAY = " << toRet << endl;
		toRet.remove(3,1);
		//kdDebug()<<"mDAY = " << toRet << endl;
		toRet.remove(16,5);
		//kdDebug()<<"mDAY = " << toRet << endl;
		toRet.insert(3,mDay);
		//kdDebug()<<"mDAY = " << toRet << endl;
		toRet.insert(12,mYear);
		//kdDebug()<<"mDAY = " << toRet << endl;
		toRet.replace("\n","");
		toRet.replace("\r","");
	}else{
		QFileInfo info(str);
		QDateTime d=info.created();
		toRet=d.toString("ddd, dd MMM yyyy hh:mm:ss");
	}
	int timeZone=KRFCDate::localUTCOffset() / 60;
	if (timeZone==0) toRet+=" +0000";
	else{
		if(timeZone>0) toRet+=" +";
		else{
			toRet+=" -";
			timeZone*=-1;
		}
		QString tZone;
		if(timeZone<10) tZone=QString("0%100").arg(timeZone);
		else tZone=QString("%100").arg(timeZone);
		toRet+=tZone;
	}
	return toRet;
}
/*================================
================================*/
QCString WAR::toDOS(QCString orig){
	char s='\n';
	char r[3]={'\r','\n','\0'};
	orig.replace(s,r);
	r[1]='\r';
	char r1[2]={'\r','\0'};
	orig.replace(r,r1);
	return orig;
}
/*================================
================================*/
QString WAR::toDOS(QString orig){
	char s[2]={'\n','\0'};
	char r[3]={'\r','\n','\0'};
	orig.replace(QCString(s),QCString(r));
	r[1]='\r';
	char r1[2]={'\r','\0'};
	orig.replace(QString(r),QString(r1));
	return orig;
}
#include "WAR.moc"
