/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2008
*/
#ifndef XMLNAMES_H
#define XMLNAMES_H

#include <qstring.h>

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/
namespace KMF {

class XML {
	private: 
		XML();
		
	public:
		~XML();
		// Document Elements
		static const QString& GenericDoc_DocumentElement;
		static const QString& IPTDoc_DocumentElement;
		static const QString& KMFNetwork_DocumentElement;
		
		// Elements
		static const QString& Table_Element;
		static const QString& Chain_Element;
		static const QString& Rule_Element;
		static const QString& RuleOption_Element;
		static const QString& RuleOptionValue_Element;
		static const QString& Protocol_Element;
		static const QString& ProtocolUsage_Element;
		static const QString& ProtocolCategory_Element;
		static const QString& Logging_Element;
		static const QString& Target_Element;
		static const QString& TargetConfig_Element;
		static const QString& Port_Element;
		static const QString& Abstract_Element;
		static const QString& ICMP_Element;
		static const QString& NAT_Element;
		static const QString& NetHost_Element;
		static const QString& NetZone_Element;
		static const QString& FromIP_Element;
		static const QString& NetMask_Element;
		static const QString& Interface_Element;
		static const QString& OS_Element;
		static const QString& BackEnd_Element;
		static const QString& Distribution_Element;
		static const QString& InitPath_Element;
		static const QString& IPTPath_Element;
		static const QString& ModprobePath_Element;
		static const QString& RcDefaultPath_Element;
		
		
		
		// Attributes
		static const QString& Uuid_Attribute;
		static const QString& Name_Attribute;
		static const QString& Description_Attribute;
		static const QString& GUIName_Attribute;	
		static const QString& Protocol_Attribute;
		static const QString& Address_Attribute;
		static const QString& ReadOnly_Attribute;
		static const QString& Type_Attribute;
		static const QString& TargetOption_Attribute;
		static const QString& BuiltIn_Attribute;
		static const QString& DefaultTarget_Attribute;
		static const QString& Logging_Attribute;
		static const QString& Target_Attribute;
		static const QString& Prefix_Attribute;
		static const QString& Limit_Attribute;
		static const QString& Burst_Attribute;
		static const QString& IO_Attribute;
		static const QString& ProtocolUuid_Attribute;
		static const QString& Enabled_Attribute;
		static const QString& CustomRule_Attribute;
		static const QString& Num_Attribute;
		static const QString& Version_Attribute;
		static const QString& MinVersion_Attribute;
		static const QString& MaxVersion_Attribute;
		static const QString& RestrictOutgoingConnections_Attribute;
		static const QString& AllowIncomingConnections_Attribute;
		static const QString& LogDropped_Attribute;
		static const QString& LimitLog_Attribute;
		static const QString& LogPrefix_Attribute;
		static const QString& AllowPingReply_Attribute;
		static const QString& LimitPingReply_Attribute;
		static const QString& UseNat_Attribute;
		static const QString& UseMasquerade_Attribute;
		static const QString& NatAddress_Attribute;
		static const QString& OutgoingInterface_Attribute;
		static const QString& UseFilter_Attribute;
		static const QString& Use_Nat_Attribute;
		static const QString& UseMangle_Attribute;
		static const QString& UseModules_Attribute;
		static const QString& UseRpFilter_Attribute;
		static const QString& UseIPFwd_Attribute;
		static const QString& UseSynCookies_Attribute;
		static const QString& UseMartians_Attribute;
		static const QString& LogIncoming_Attribute;
		static const QString& LogOutgoing_Attribute;
		static const QString& LimitRate_Attribute;
		static const QString& LimitScale_Attribute;
		static const QString& Interface_Attribute;
		static const QString& SSHPort_Attribute;
		//Values
		static const QString& Yes_Value;
		static const QString& No_Value;
		static const QString& BoolOn_Value;
		static const QString& BoolOff_Value;
		static const QString& Undefined_Value;
		static const QString& Incoming_Value;
		static const QString& Outgoing_Value;
		static const QString& UDP_Value;
		static const QString& TCP_Value;
		
		static const QString& IPTablesGUIInterface_Value;
		static const QString& GenericGUIInterface_Value;
};




class Constants {
	private: 
		Constants();
	public:
		~Constants();
		static const QString& Localhost_Name;
		static const QString& Localhost_IP;
		static const QString& MyNetwork_Name;
		static const QString& FilterTable_Name;
		static const QString& NatTable_Name;
		static const QString& MangleTable_Name;
		
		static const QString& InputChain_Name;
		static const QString& OutputChain_Name;
		static const QString& ForwardChain_Name;
		static const QString& PreRoutingChain_Name;
		static const QString& PostRoutingChain_Name;

		static const QString& StartFirewallJob_Name;
		static const QString& StopFirewallJob_Name;
		static const QString& InstallFirewallJob_Name;
		static const QString& UninstallFirewallJob_Name;
		static const QString& ShowConfigJob_Name;
		
};		

}
#endif




