/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Interface: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFRULEOPTIONEDITCUSTOM_H
#define KMFRULEOPTIONEDITCUSTOM_H

#include "../../core/kmfruleoptioneditinterface.h"

// QT includes
#include <qobject.h>
#include <qptrlist.h>
#include <qstring.h>

// KDE includes
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>
class KInstance;

namespace KMF {
class IPTRule;
class KMFRuleEditCustomOpt;
/**
@author Christian Hubinger
*/
class KMFRuleOptionEditCustom : public KMFRuleOptionEditInterface {
	Q_OBJECT
public:
	KMFRuleOptionEditCustom(QObject *parent = 0, const char *name = 0, const QStringList& = QString::null);

	~KMFRuleOptionEditCustom();
	void loadRule( IPTRule* rule );	
	QWidget* editWidget();
	const QString& optionEditName() const;
	const QString& description() const;
	static KAboutData *createAboutData();

private slots:
	void slotShowOverview();
	
private:
	KMFRuleEditCustomOpt *m_edit;
	IPTRule *m_rule;
};



class KMFRuleOptionEditCustomFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFRuleOptionEditCustomFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFRuleOptionEditCustomFactory() {
/* 		delete s_instance; */
	};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
	/*     static KInstance* instance(); */

/*private:
	static KInstance* s_instance;*/
};
}








#endif
