#include "config.h"

#ifdef HAVE_MYSQL_LIBS
#ifdef WIN32
#pragma warning ( disable : 4786 )
#pragma warning ( disable : 4800 )
#include "windows.h"
#endif

#include <mysql_version.h>
#include <mysql.h>
#include "my_sql.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <mysql_com.h>
#include <cmath>
#include <iostream>

#ifndef WIN32
#include <sys/time.h>
#include <unistd.h>
#endif

#include <sstream>

#include <unistd.h>

#include "kmysqladmin/backend/my_sql/change_type.h"
#include "kmysqladmin/helpers/stringhelper.h"
#include "kmysqladmin/helpers/tfunctions.h"

using namespace std;

const char* CMySql::MessageArray[]={
    "row(s) affected",              //0
    "row(s) found",
    " WHERE ",
    "No table given to work on",
    "Not connected",
    "I do not change system database in this way", //5
    "No database given to work on",
    "Could not connect to database",
    "Error while escaping string"
};

int CMySql::MessageCount = 5;

const my_sql_type CMySql::f_arr[]=
    {   //                                                             def  aut   zer   uns  key   keys  enums binary
        my_sql_type("TINYINT","TinyInt (1 Byte)",          1,  3,0,0, true, true, true, true,false, true,false,false),
        my_sql_type("SMALLINT","SmallInt (2 Bytes)",       1,  5,0,0, true, true, true, true,false, true,false,false),
        my_sql_type("MEDIUMINT","MediumInt (3 Bytes)",     1,  8,0,0, true, true, true, true,false, true,false,false),
        my_sql_type("INT","Int (4 Bytes)",                 1, 10,0,0, true, true, true, true,false, true,false,false),
        my_sql_type("BIGINT","BigInt (8 Bytes)",           1, 20,0,0, true, true, true, true,false, true,false,false),
        my_sql_type("FLOAT","Float (4 Bytes)",             1, 20,0,4, true, true, true, true,false, true,false,false),
        my_sql_type("REAL","Double (8 Bytes)",             1, 20,0,8, true, true, true,false,false, true,false,false),
        my_sql_type("DECIMAL","Decimal (lenght,dec)",      1, 20,0,8, true, true, true,false, true, true,false,false),
        my_sql_type("CHAR","Char (1 <= num <=255)",        1,255,0,0,false,false,false,false, true, true,false, true),
        my_sql_type("VARCHAR","Varchar (1 <= num <=255)",  1,255,0,0,false,false,false,false, true, true,false, true),
        my_sql_type("TINYBLOB","Tinyblob (num <= 255)",    2,  2,0,0,false,false,false,false,false,false,false,false), //10
        my_sql_type("BLOB","Blob (num <= 65535)",          2,  2,0,0,false,false,false,false,false,false,false,false),
        my_sql_type("MEDIUMBLOB","Mediumblob (num < 2^24)",2,  2,0,0,false,false,false,false,false,false,false,false),
        my_sql_type("LONGBLOB","Longblob (num < 2^32)",    2,  2,0,0,false,false,false,false,false,false,false,false),
        my_sql_type("TINYTEXT","Tinytext (num <= 255)",    2,  2,0,0,false,false,false,false,false,false,false,false),
        my_sql_type("TEXT","Text (num <= 65535)",          2,  2,0,0,false,false,false,false,false,false,false,false),
        my_sql_type("MEDIUMTEXT","Mediumtext (num < 2^24)",2,  2,0,0,false,false,false,false,false,false,false,false),
        my_sql_type("LONGTEXT","Longtext (num < 2^32)",    2,  2,0,0,false,false,false,false,false,false,false,false),
        my_sql_type("TIMESTAMP","Timestamp (4 Bytes)",     1, 14,0,0, true,false,false,false,false, true,false,false),
        my_sql_type("DATE","Date (4 Bytes)",              10, 10,0,0, true,false,false,false,false, true,false,false),
        my_sql_type("TIME","Time (3 Bytes)",               8,  8,0,0, true,false,false,false,false, true,false,false), //20
        my_sql_type("ENUM","Enum",                         1, 80,0,0, true,false,false,false,false, true, true,false),
        my_sql_type("SET","Set",                           1, 80,0,0, true,false,false,false,false, true, true,false),
        my_sql_type("DATETIME","DateTime",                14, 14,0,0,false,false,false,false,false,false,false,false),
        my_sql_type("YEAR","Year",                         4,  4,0,0, true,false,false,false,false,false,false,false),
        my_sql_type("DOUBLE","Double (8 Bytes)",           1, 20,0,8, true, true, true,false,false, true,false,false),
        my_sql_type("NUMERIC","Decimal (lenght,dec)",      1, 20,0,8, true, true, true,false, true, true,false,false),
    };

const my_sql_type&CMySql::sql_type(int i)
{
    return f_arr[i];
}

int CMySql::FieldDescriptCounts()
{
    return sizeof(f_arr)/sizeof(my_sql_type);
}

const char* CMySql::FieldDescript(int i)
{
    if (i >= FieldDescriptCounts() || i < 0)
        return "";
    return f_arr[i]._descriptor.c_str();
}

const char* CMySql::TypeDescript(int i)
{
    if (i >= FieldDescriptCounts() || i < 0)
        return "";
    return f_arr[i]._name.c_str();
}

bool CMySql::is_system_db(const std::string&name)
{
    return Caseequ()(name,"mysql");
}

void CMySql::sql_disconnect()
{
    nothing_else = 1;
    if (Sql_Connection) {
        mysql_close(Sql_Connection);
        delete Sql_Connection;
        Sql_Connection = 0L;
    }
    Server_MasterVersion = Server_MinorVersion = Server_PatchLevel = 0;
    nothing_else = 0;
}

void CMySql::init_values()
{
    Sql_Connection = 0L;
    nothing_else = 0;
    Server_MasterVersion = Server_MinorVersion = Server_PatchLevel = 0;
    m_Host = m_Pass = m_User = m_Port = "";
    message_call_back = 0;
    m_h_rights = 0;
}

CMySql::CMySql()
    :ref_count()
{
    init_values();
}

CMySql::CMySql(const CMySql&old)
    :ref_count()
{
    init_values();
    message_call_back = old.message_call_back;
    sql_connect(old.m_Host.c_str(),old.m_User.c_str(),
                old.m_Pass.c_str(),old.m_Port.c_str());
}

CMySql::CMySql(const char*host,const char*user,const char*pass,const char*port)
{
    init_values();
    sql_connect(host,user,pass,port);
}

CMySql::~CMySql()
{
    sql_disconnect();
}

void CMySql::sql_connect(const std::string&host,const std::string&user,
                         const std::string&pass,const std::string&port)
{
    sql_connect(host.c_str(),user.c_str(),pass.c_str(),port.c_str());
}

void CMySql::sql_connect(const char*host,const char*user,const char*pass,const char*port)
{
    int Port;
    nothing_else = 1;

    Port = port?atoi(port):3306;
    m_Port = port?port:"";
    m_User = user?user:"";
    m_Pass = pass?pass:"";
    m_Host = host?host:"";

    sql_disconnect();
    const char*s_version = NULL;
    char*help_ptr = NULL;
    Server_MasterVersion = Server_MinorVersion = Server_PatchLevel = 0;
    Sql_Connection = new MYSQL;
    if (!Sql_Connection)
        return;
    mysql_init(Sql_Connection);
    MYSQL * dummy_pointer = mysql_real_connect(Sql_Connection,host,user,pass,(char*)0,(unsigned int)Port,(char*)0,0);
    if (dummy_pointer) {
        do_message("Connected");
        s_version = mysql_get_server_info(Sql_Connection);
        if (s_version) {
            Server_MasterVersion = atoi(s_version);
            help_ptr = strstr(s_version,".");
            if (help_ptr) {
                help_ptr = &help_ptr[1];
                Server_MinorVersion = atoi(help_ptr);
            }
            help_ptr = strstr(help_ptr,".");
            if (help_ptr) {
                help_ptr = &help_ptr[1];
                Server_PatchLevel = atoi(help_ptr);
            }
        }
    } else {
        stringstream s;
        s << "Couldn't connect: " << mysql_error(Sql_Connection);
        do_message(s.str());
        delete Sql_Connection;
        Sql_Connection = 0;
    }
    nothing_else = 0;
}

int CMySql::refresh_grants()
{
    return do_refresh(REFRESH_GRANT,"grants reloaded");
}

int CMySql::refresh_tables()
{
    return do_refresh(REFRESH_TABLES,"tables flushed");
}

int CMySql::refresh_cache()
{
    return do_refresh(REFRESH_HOSTS,"cache flushed");
}

int CMySql::refresh_log()
{
    return do_refresh(REFRESH_LOG,"new log started");
}

int CMySql::do_refresh(int What, const std::string&ok_msg)
{
    int i = 0;
    if (!Sql_Connection) {
        do_message("not connected");
        return -1;
    }
    i = mysql_refresh(Sql_Connection, What);
    if (i < 0)
        do_message(get_last_error());
    else
        do_message(ok_msg);
    return i;
}

const std::string&CMySql::get_info()
{
    const char*c_info;
    const char*h_info;
    int p_info;
    const char*s_info;
    char t_1[] = "Clientversion";
    if (nothing_else) {
        connect_info = "";
    } else {
        if (Sql_Connection) {
            c_info = mysql_get_client_info();
            h_info = mysql_get_host_info(Sql_Connection);
            p_info = mysql_get_proto_info(Sql_Connection);
            s_info = mysql_get_server_info(Sql_Connection);
#ifndef WIN32
            string sep = "\n";
#else
            string sep = "\r\n";
#endif
            stringstream s;
            s << h_info << sep
              << t_1 << " " << c_info << sep
              << "Protokoll Version: " << p_info << sep
              << "Serverversion: " << s_info;
            connect_info = s.str();
        }
        else {
            connect_info = "Couldn't get info";
        }
    }
    return connect_info;
}

const bool CMySql::get_status(PatternList&aTarget)const
{
    aTarget.resize(0);
    if (!Sql_Connection||nothing_else)
        return false;
    list_vector target;
    stringlist headers;

    if (!do_statement("SHOW STATUS",target,headers,true) || target.size()==0) {
        return false;
    }
    for (size_t a = 0; a<target.size(); ++a) {
        aTarget.push_back(CPatternPair(target[a][0],target[a][1]));
    }
    return true;
}

bool CMySql::get_threads(stringlist&target)const
{
    std::string result;
    MYSQL_RES*Res;
    MYSQL_ROW row;
    if (!Sql_Connection || nothing_else)
        return true;
    Res=mysql_list_processes(Sql_Connection);
    const char*st;
    st = mysql_error(Sql_Connection);
    if (st[0] != 0) {
        do_message(st);
    }
    if (!Res)
        return false;
    result = "";
    while ((row=mysql_fetch_row(Res))) {
        for (unsigned int i = 0;i < mysql_num_fields(Res);++i) {
            result+=row[i]!=0?(char*)row[i]:" ";
            if(i < mysql_num_fields(Res) - 1)
                result+="\t";
        }
        target.push_back(result);
        result = "";
    }
    mysql_free_result(Res);
    return true;
}

bool CMySql::get_threads(list_vector&target)const
{
    MYSQL_RES*Res;
    MYSQL_ROW row;
    target.resize(0);
    if (!Sql_Connection || nothing_else)
        return true;
    Res = mysql_list_processes(Sql_Connection);
    const char*st;
    st = mysql_error(Sql_Connection);
    if (st[0] != 0) {
        do_message(st);
    }
    if (!Res)
        return false;
    stringlist result;
    while((row=mysql_fetch_row(Res))) {
        for (unsigned int i = 0; i < mysql_num_fields(Res);++i) {
            result.push_back(row[i]!=0?row[i]:"");
        }
        target.push_back(result);
        result.clear();
    }
    mysql_free_result(Res);
    return true;
}

/*
 * retrieves the list of databases in the current
 * connected server
 */
bool CMySql::get_db_list(const std::string&pattern,stringlist&target)const
{
    target.resize(0);
    std::string result;

    MYSQL_RES*Res;
    MYSQL_ROW row;
    if (!Sql_Connection || nothing_else)
        return false;
    Res=mysql_list_dbs(Sql_Connection,pattern.c_str());
    const char*st;
    st = mysql_error(Sql_Connection);
    if (st[0] != 0) {
        do_message(st);
    }
    if (!Res)
        return false;
    while ((row=mysql_fetch_row(Res))) {
        for (unsigned int i = 0;i < mysql_num_fields(Res);i++) {
            result+=row[i]?(char*)row[i]:" ";
            if(i < mysql_num_fields(Res) - 1)
                result+="\t";
        }
        target.push_back(result);
        result = "";
    }
    mysql_free_result(Res);
    return true;
}

/*
 * fetches the tables of a database
 */
bool CMySql::get_table_list(const std::string&pattern,const std::string&db,stringlist&target)
{
    std::string s;
    MYSQL_RES*Res;
    MYSQL_ROW row;
    target.resize(0);
    if (!Sql_Connection || nothing_else)
        return false;
    if (connect_db(db) < 0)
        return false;
    const char*st;
    Res = mysql_list_tables(Sql_Connection,pattern.c_str());
    st = mysql_error(Sql_Connection);
    if (st[0] != 0) {
        do_message(st);
    }
    if (!Res)
        return false;
    while ((row=mysql_fetch_row(Res))) {
        for (unsigned int i = 0;i < mysql_num_fields(Res);i++) {
            s+=row[i]?(char*)row[i]:"";
            if(i < mysql_num_fields(Res) - 1)
                s+="\t";
        }
        target.push_back(s);
        s = "";
    }
    mysql_free_result(Res);
    return true;
}

/*
 * get the columns of a table
 */
bool CMySql::get_table_fields(const std::string&db,const std::string&table,ColumnList&target)const
{
    CColumnDescriptor entry,empty_descriptor;

    target.resize(0);
    std::string command = "";
    if (!Sql_Connection || nothing_else)
        return false;

    if (db.size()==0) {
        do_message(MessageArray[6]);
        return false;
    }
    if (connect_db(db)!=0) {
        do_message("Could not connect to database");
        return false;
    }

    command = "SHOW COLUMNS FROM ";
    command+=table;

    list_vector qtarget;
    stringlist qheaders;

    if (!do_statement(command,qtarget,qheaders,true)) {
        return false;
    }
    int f_type = 0;

    std::string type_string = "";
    std::string sizestring = "";

    stringlist exp,texp;

    for (size_t lsize=0; lsize < qtarget.size();++lsize) {
        entry.set_name(qtarget[lsize][0]);
        type_string = "";
        sizestring = "";
        exp.resize(0);
        texp.resize(0);

        string::size_type a,b;

#if 0
        exp = tfunctions::Explode()(qtarget[lsize][1]," ",true);
        type_string = exp[0];

        a = type_string.find("(");
        b = type_string.find(")");

        if (a!=string::npos) {
            sizestring = type_string.substr(a,a+b);
            type_string.erase(a,a+b);
        }
#endif
        exp = explodeTypeString(qtarget[lsize][1]);
        type_string=exp[0];
        sizestring=exp[1];
        for (f_type = 0; f_type < FieldDescriptCounts();++f_type) {
            if (Caseequ()(type_string,TypeDescript(f_type)) ) {
                entry.set_FieldType(f_type);
                break;
            }
        }
        if (f_type == FieldDescriptCounts()) {
            do_message(string("Field: ")+type_string+" "+exp[0]);
            do_message("Error retrieving fieldtypes - please send a mail to the "
                       "author of the software!");
            return false;
        }
        my_sql_type t_info = sql_type(f_type);
        if (f_type >= 10 && f_type < 14) {
            entry.set_Blob(true);
        }
        if (f_type >= 14 && f_type < 18) {
            entry.set_Text(true);
        }

        if (sizestring.size()>0) {
            if (f_type == 21 || f_type == 22) {
                bool hkstart = false;
                unsigned int max = 0;
                b = 0;
                for (a=0; a<sizestring.size();++a) {
                    if (sizestring[a]=='\'') {
                        if (!hkstart) {
                            hkstart = true;
                            b = a;
                        } else {
                            hkstart = false;
                            if (b+1>a-1) continue;
                            type_string = sizestring.substr(b+1,a-1-b);
//                            cout << type_string << endl;
                            max = max>type_string.size()?max:type_string.size();
                            entry.insert_enum(type_string);
                        }
                    }
                }
                entry.set_MaxLength(max);
            } else {
                texp = tfunctions::Explode()(sizestring,",",true);
                entry.set_MaxLength(atoi(texp[0].c_str()));
                if (texp.size()>1) {
                    entry.set_MaxDecimals(atoi(texp[1].c_str()));
                }
            }
        } else {
            //its only the max value
            entry.set_MaxLength(t_info._dec_max);
        }
        entry.set_Unsigned(false);
        entry.set_ZeroFill(false);
        entry.set_Binary(false);
        size_t isize;
        for (isize = 1; isize<exp.size();++isize) {
//            cout << exp[isize] << endl;
            if (Caseequ()(exp[isize],"unsigned")) {
                entry.set_Unsigned(true);
            } else if (Caseequ()(exp[isize],"zerofill")) {
                entry.set_ZeroFill(true);
            } else if (Caseequ()(exp[isize],"binary")) {
                entry.set_Binary(true);
            }
        }
        if (Caseequ()(qtarget[lsize][2],"yes")) {
            entry.set_NotNull(false);
        } else {
            entry.set_NotNull(true);
        }
        entry.set_default(qtarget[lsize][4]);
        if (Caseequ()(qtarget[lsize][3],"PRI")) {
            entry.set_Primary(true);
        } else if (Caseequ()(qtarget[lsize][3],"UNI")) {
            entry.set_Unique(true);
        } else if (Caseequ()(qtarget[lsize][3],"MUL")) {
            entry.set_PartOfMultiKey(true);
        }
        exp = tfunctions::Explode()(qtarget[lsize][5]," ",true);
        for (isize=0;isize < exp.size();++isize) {
            if (Caseequ()(exp[isize],"auto_increment")) {
                entry.set_AutoIncrement(true);
            }
        }
        target.push_back(entry);
        entry = empty_descriptor;
    }
    return true;
}

int CMySql::kill_thread(unsigned long pid)
{
    int i;
    if (!Sql_Connection)
        return -1;
    i = mysql_kill(Sql_Connection,pid);
    if (i < 0)
        do_message(get_last_error());
    return i;
}

string CMySql::get_last_error()const
{
    const char*f;
    if (!Sql_Connection) {
        return string("No connection");
    }
    f = mysql_error(Sql_Connection);
    if (!f || f[0]==0)
        return string("");
    return string(f);
}

/*
 * inserts a new database
 */
bool CMySql::create_db(const std::string&db)
{
    int i = 0;
    string f;
    if (db.size()<1 || !Sql_Connection || nothing_else)
        return false;
    f = "CREATE DATABASE "+db;
    i = mysql_real_query(Sql_Connection,f.data(),f.size());
    if (i != 0) {
        do_message(get_last_error());
        return false;
    }
    return true;
}

bool CMySql::create_table(const std::string&db,const std::string&name,ColumnList*columns,KeyList*keys)
{
    std::string statement;
    std::string temp_statement;
    stringstream s;

    ColumnList_iterator desc = columns->end();
    KeyList_iterator key = keys->end();
    unsigned int count = 0;
    std::string Type;

    if (name.size() == 0) {
        do_message(MessageArray[3]);
        return false;
    }
    if (!columns || columns->size() == 0){
        do_message("Wich columns should I create?");
        return false;
    }
    if (!Sql_Connection) {
        do_message(MessageArray[4]);
        return false;
    }

    if (connect_db(db)!=0) {
        do_message("Could not connect to database");
        return false;
    }

    statement = "CREATE TABLE ";
    //statement+=db;statement+='.';
    statement+= name;statement+=" (";

    for (desc = columns->begin(); desc != columns->end(); ++desc) {
        if (desc != columns->begin()) {
            statement+=", ";
        }
        count++;
        if (!build_command(temp_statement,*desc)) {
            return false;
        }
        statement+=temp_statement;
    }
    if (keys) {
        int already_prim = 0;
        pairIlist col_list;

        int f_count = 0;
        for (key = keys->begin(); key != keys->end(); ++key) {
            f_count = 0;
            statement+=", ";
            switch(key->getType()) {
            case CKeyDescriptor::PRIMARY:
                if (!already_prim) {
                    statement+="PRIMARY KEY ";
                    already_prim = 1;
                } else {
                    statement+="UNIQUE ";
                    key->setType(CKeyDescriptor::UNIQUE);
                }
                break;
            case CKeyDescriptor::UNIQUE:
                statement+="UNIQUE ";
                break;
            case CKeyDescriptor::INDEX:
                statement+="INDEX ";
                break;
            default:
                continue;
            }
            if (key->getType() != CKeyDescriptor::PRIMARY) {
                statement+=key->get_name();
            }
            col_list = key->get_ColList();
            if (col_list.size() == 0)
                continue;
            statement+="(";
            pairIlist::iterator iter;
            iter = col_list.begin();
            for (;iter!=col_list.end();++iter) {
                if (f_count> 0)
                    statement+=",";
                ++f_count;
                statement+=iter->first.c_str();
                if (iter->second > 0) {
                    statement+="(";
                    s.str("");
                    s << iter->second;
                    statement+= s.str();
                    statement+=")";
                }
            }
            statement+=") ";
        }
    }
    statement+=")";
    do_message(statement);
    int i = mysql_real_query(Sql_Connection,statement.data(),statement.size());
    if (i < 0) {//error??
        //why?
        do_message(get_last_error());
        return false;
    }
    return true;
}

int CMySql::_fetch_rows(const std::string&db,const std::string&table,const std::string&sort_by,bool desc,
                        const stringlist&which,unsigned int offset,unsigned int count,
                        PatternList*Pattern,bool errors_only,MYSQL_RES**Res)
{
    std::string query;
    std::string entry;
    std::string escaped;
#ifndef WIN32
    timeval starttime,endtime;
#endif

    int i = 0;

    if (!Sql_Connection) {do_message(MessageArray[4]);return -1;}
    if (table.size() == 0) {do_message(MessageArray[3]);return -1;}
    if (connect_db(db.c_str())<0) {do_message("error db");return -1;}

    query = "";
    if (which.size()>0) {
        query = "SELECT ";
        stringlist::const_iterator w_iter = which.begin();
        for (;w_iter!=which.end();++w_iter) {
            if (w_iter!=which.begin())
                query+=",";
            query+=*w_iter;
        }
    } else {
        query="SELECT *";
    }
    query+=" FROM ";
    query+=table;query+=" ";
    PatternIterator p_iter;
    if (Pattern && Pattern->size()) {
        p_iter = Pattern->begin();
        query+=MessageArray[2];
        query+=p_iter->get_entry();
        query+=" ";
        query+=p_iter->get_op();
        query+=" \'";
        if (!p_iter->get_no_escape()) {
            do_escape(p_iter->std_pattern(),escaped);
            query+=escaped;
        } else {
            query+=p_iter->std_pattern();
        }
        query+="\' ";
        ++p_iter;
        for (;p_iter != Pattern->end();++p_iter){
            query+="AND ";query+=p_iter->get_entry();
            query+=" ";query+=p_iter->get_op();

            if (!p_iter->get_is_name()) {
                query+=" \'";
            }
            if (!p_iter->get_no_escape()) {
                do_escape(p_iter->std_pattern(),escaped);
                if (escaped.size()==0)
                    return -1;
                query+=escaped;
            } else {
                query+=p_iter->std_pattern();
            }
            if (!p_iter->get_is_name()) {
                query+="\'";
            }
            query+=" ";

        }
    }
    if (sort_by.size()) {
        query+="ORDER BY ";query+=sort_by;query+=" ";
        if (desc) query+="DESC"; else query+="ASC";
        query+=" ";
    }
#if 0
    if (count == 0)
        count = 99999;
#endif
    if (count > 0 || offset > 0) {
        std::string ls;
        std::string cs;
        stringstream ss;
        if (offset > 0) {
            ss.str("");
            ss << "LIMIT "<<offset;
            ls = ss.str();
            if (count > 0) {
                ls+=",";
            }
            else
                ls+=",-1";
        }
        else {
            ls = "LIMIT ";
        }
        if (count > 0) {
            ss.str("");
            ss << count;
            ls+= ss.str();
        }
        query+=ls;
    }
    if (Pattern)
        Pattern->clear();
    //what is the resulting query?
    if (!errors_only) do_message(query);
#ifndef WIN32
    gettimeofday(&starttime,0);
#endif
    i = mysql_real_query(Sql_Connection,query.data(),query.size());

    if (i < 0) {//error??
        //why?
        if (errors_only)do_message(query);
        do_message(get_last_error());
        return -1;
    }
    *Res = mysql_store_result(Sql_Connection);
    //*Res = mysql_use_result(Sql_Connection);
    if (!Res) {
        //autch - this should never be...
        query = mysql_error(Sql_Connection);
        if (!query.empty())
            do_message(query);
        else
            do_message("Error fetch the result");
        return -1;
    }
#ifndef WIN32
    gettimeofday(&endtime,0);
    long int sec,usec;
    sec = endtime.tv_sec - starttime.tv_sec;
    usec = endtime.tv_usec - starttime.tv_usec;
    usec += 1000*1000*sec;
    //printf("Fetchtime: %li,%06li sec ",usec/(1000*1000),usec%(1000*1000));
#endif
    return 1;
}

/*
 * Makes a simple search
 */
int CMySql::fetch_rows(const std::string&db,const std::string&table,const std::string&sort_by, bool desc,
                       stringlist&which, list_vector&target,unsigned int offset,unsigned int count,
                       PatternList*Pattern,bool errors_only)
{
    MYSQL_RES*Res;
    target.resize(0);
    int i = _fetch_rows (db,table,sort_by,desc,which,offset,count,Pattern,errors_only,&Res);
    if (i < 0 || Res==0)
        return -1;
    unsigned j = 0;
    MYSQL_ROW row;
    MYSQL_FIELD*Field;

    //what did the server found?
    unsigned long zaehler = Res->row_count;
    if (!errors_only) {
        stringstream ss;
        ss << zaehler << " " << MessageArray[1];
        do_message(ss.str());
    }
    std::string query;
    query = "";
    stringlist helper,entry;
#ifndef WIN32
    timeval starttime,endtime;
    long int sec,usec;
    gettimeofday(&starttime,0);
#endif
    entry.resize(0);
    which.clear();
    /* fill out fields */
    for (j = 0; j < mysql_num_fields(Res);++j) {
        Res->current_field = j;
        Field = mysql_fetch_field(Res);
        which.push_back(Field->name);
    }
    unsigned long *laengen;
    std::string buff_string;
    while ((row=mysql_fetch_row(Res))) {
        laengen = mysql_fetch_lengths(Res);
        for (j = 0;j < mysql_num_fields(Res);++j) {
            if (row[j]) {
                buff_string.assign((char*)row[j],laengen[j]);
            } else {
                buff_string.clear();
            }
            entry.push_back(buff_string);
        }

        //append to the list
        target.push_back(entry);
        entry.clear();
    }
#ifndef WIN32
    gettimeofday(&endtime,0);
    sec = endtime.tv_sec - starttime.tv_sec;
    usec = endtime.tv_usec - starttime.tv_usec;
    usec+=1000*1000*sec;
    //printf("Listbuildtime: %li,%06li sec\n",usec/(1000*1000),usec%(1000*1000));
#endif
    mysql_free_result(Res);

    return 0;
}


/*
 * inserts a single row into a table
 */
int CMySql::insert_replace_row(const std::string&what,const std::string&db,const std::string&table, PatternList*Pattern)
{
    stringstream query("");
    stringstream value_string("");
    stringstream row_string("");
    string escaped="";
    int i;

    if (!Sql_Connection) {
        do_message(MessageArray[4]);
        return -1;
    }
    if (Pattern == 0 || Pattern->empty()) {
        do_message("No data to insert");
        return -1;
    }
    if (table.size() == 0) {
        do_message(MessageArray[3]);
        return -1;
    }
    i = connect_db(db);
    if (i < 0) {
        do_message(MessageArray[6]);
        return i;
    }
    //build the pattern-string
    PatternIterator p_iter;
    string ops="";
    unsigned int pos;
    for (p_iter = Pattern->begin();p_iter!=Pattern->end();++p_iter){
        escaped="";
        if (p_iter->get_pattern_size()) {
            do_escape(p_iter->std_pattern(),escaped);
            if (!escaped.size()) {
                do_message(MessageArray[8]);
                return -1;
            }
        }
        ops = p_iter->get_op();
        pos = ops.find("()");
        if (pos != string::npos) {
            ops.erase(pos+1,1);
        } else {
            ops="";
        }
        if (value_string.str().size()) {
            value_string<<",";
            row_string<<",";
        }
        value_string << ops << "\'";
        value_string << escaped << "\'"<< (ops.size()?")":"");
        row_string << p_iter->get_entry();
    }
    //build the complete query
    query << what << " INTO "
          << table << " (" << row_string.str() << ") VALUES ("
          << value_string.str() << ")";
    //send it to the protocoll
    do_message(query.str());
    //do it
    i = mysql_real_query(Sql_Connection,query.str().data(),query.str().size());
    if (i == -1) {
        //if some goes wrong
        query.str(mysql_error(Sql_Connection));
        do_message(query.str());
        return i;
    }
    //should be > 0
    i = mysql_affected_rows(Sql_Connection);
    stringstream ss;
    ss << i << " " << MessageArray[0];
    do_message(ss.str());
    i = mysql_insert_id(Sql_Connection);
    if (i != 0) {
        ss.str("");
        ss << "Last auto increment: " << i;
        do_message(ss.str());
    }
    return i;
}

std::string&CMySql::do_escape(const std::string&what,std::string&target)const
{
    target.resize(0);

    if (what.size()==0)
        return target;

    char * escaped = new char[what.size()*2+1];

    if (!escaped) {
        do_message("Error allocating memory");
        return target;
    }

    memset(escaped,'\0',what.size()*2+1);
    unsigned int res = mysql_escape_string(escaped,what.data(),what.size());

    target.assign(escaped,res);
    delete[]escaped;

    return target;
}

int CMySql::update_row(const std::string&db,const std::string&table,
                       PatternList*to_change,
                       PatternList*identifiers)
{
    std::string request;
    std::string clean;
    int i;

    if (!Sql_Connection) {
        do_message(MessageArray[4]);
        return -1;
    }
    if (table.size() == 0) {
        do_message(MessageArray[3]);
        return -1;
    }
    if (!to_change || to_change->size() == 0) {
        do_message("Nothing given to change");
        return -1;
    }
    i = connect_db(db);
    if (i < 0)
        return i;
    request = "UPDATE ";
    request+= table;request+=" SET ";
    PatternIterator p_iter;
    string ops="";
    unsigned int pos;
    bool no_op_param = false;
    for (p_iter = to_change->begin();p_iter != to_change->end();++p_iter) {
        if (p_iter != to_change->begin())
            request+=", ";
        ops = p_iter->get_op();
        if (Caseequ()(ops,"user()")) {
            no_op_param = true;
        } else {
            no_op_param = false;
        }
        pos = ops.find("()");
        if (pos != string::npos) {
            ops.erase(pos+1,1);
        } else {
            ops="";
        }
        request+=p_iter->get_entry();request+="=";
        request+=ops;
        if (!no_op_param) {
            request+="'";
            do_escape(p_iter->std_pattern(),clean);
            request+=clean;
            request+="\'";
        }
        request+=(ops.size()?")":"");
    }
    request+=MessageArray[2];
    for (p_iter = identifiers->begin();p_iter != identifiers->end();++p_iter) {
        if (p_iter != identifiers->begin())
            request += " AND ";
        request+=p_iter->get_entry();request+=" = \'";
        if (!p_iter->get_no_escape()) {
            do_escape(p_iter->std_pattern(),clean);
            request+=clean;
        } else {
            request+=p_iter->std_pattern();
        }
        request+="\'";
    }
    do_message(request);
    i = mysql_real_query(Sql_Connection,request.data(),request.size());
    if (i == -1) {
        //if some goes wrong
        do_message(get_last_error());
        return i;
    }
    //should be >= 0
    i = mysql_affected_rows(Sql_Connection);
    //log it
    stringstream ss;
    ss << i << " " << MessageArray[0];
    do_message(ss.str());
    return i;
}

int CMySql::delete_row(const std::string&db,const std::string&table,
                       PatternList*identifiers)
{
    std::string query;
    std::string clean;
    int i;
    unsigned long zaehler;

    if (!Sql_Connection){
        do_message(MessageArray[4]);
        return -1;
    }
    if (table.size() == 0) {
        do_message(MessageArray[3]);
        return -1;
    }

    i = connect_db(db);
    if (i < 0)
        return i;

    query = "DELETE FROM ";
    query+= table;
    PatternIterator p_iter;
    if (identifiers && identifiers->size() > 0) {
        query+=" ";
        query+=MessageArray[2];
        for (p_iter=identifiers->begin();p_iter != identifiers->end();++p_iter) {
            if (p_iter != identifiers->begin())
                query+=" AND ";
            query+=p_iter->get_entry();query+=" = \'";
            if (!p_iter->get_no_escape()) {
                do_escape(p_iter->std_pattern(),clean);
            } else {
                clean = p_iter->std_pattern();
            }
            query+=clean;
            query+="\'";
        }
    }
    do_message(query);
    i = mysql_real_query(Sql_Connection,query.data(),query.size());
    if (i == -1) {
        //if some goes wrong
        do_message(get_last_error());
        return i;
    }
    //should be > 0
    zaehler = mysql_affected_rows(Sql_Connection);
    //log it
    stringstream ss;
    ss << zaehler << " " << MessageArray[0];
    do_message(ss.str());
    return zaehler;
}


int CMySql::connect_db(const std::string&db)const
{
    int i = 0;
    if (!Sql_Connection) {
        do_message(MessageArray[4]);
        return -1;
    }
    i = mysql_select_db(Sql_Connection,db.c_str());
    if (i < 0) {
        do_message(get_last_error());
    }
    return i;
}

void CMySql::scramble_password(std::string&pass)const
{
    char Buffer[256];
    memset(Buffer,'\0',256);
    make_scrambled_password(Buffer,pass.c_str());
    pass = Buffer;
}

int CMySql::shutdown()
{
    int i;
    if (!Sql_Connection)
        return 0;
#if MYSQL_VERSION_ID<40100
    i = mysql_shutdown(Sql_Connection);
#else
    // for 4.1 api
    i = mysql_shutdown(Sql_Connection,SHUTDOWN_DEFAULT);
#endif
    if (i < 0) {
        do_message(get_last_error());
    }
    return i;
}

bool CMySql::delete_table(const std::string&db, const std::string&table)
{
    std::string query;

    if (!Sql_Connection) {
        do_message(MessageArray[4]);
        return false;
    }
    query = "";query = "DROP TABLE ";query+= db;query+='.';query+= table;
    do_message(query);
    int i = mysql_real_query(Sql_Connection,query.data(),query.size());
    if (i < 0) {
        do_message(get_last_error());
        return false;
    }
    unsigned long zaehler = mysql_affected_rows(Sql_Connection);
    stringstream ss;
    ss << zaehler << " " << MessageArray[0];
    do_message(ss.str());
    return true;
}

bool CMySql::get_table_keys(const std::string&db, const std::string&table, KeyList&target)const
{
    std::string command = "SHOW KEYS FROM ";
    std::string name="";

    target.resize(0);

    if (!Sql_Connection) {
        do_message(MessageArray[4]);
        return false;
    }

    if (table.size() == 0) {
        return false;
    }
    if (connect_db(db) < 0) {
        return false;
    }

    command+=table;
    list_vector qtarget;
    stringlist qheaders;

    if (!do_statement(command,qtarget,qheaders,true)) {
        return false;
    }

    bool found = false;
    unsigned int count;
    size_t lsize = 0;

    for (lsize=0; lsize<qtarget.size();++lsize) {
        for (count = 0; count < target.size(); ++count) {
            if (target[count] == qtarget[lsize][2]) {
                found = true;
                break;
            }
        }
        if (!found) {
            CKeyDescriptor key;
            key.set_name(qtarget[lsize][2]);

            if (Caseequ()(qtarget[lsize][1],"1")) {
                key.setType(CKeyDescriptor::INDEX);
            } else {
                if (Caseequ()(qtarget[lsize][2],"PRIMARY")) {
                    key.setType(CKeyDescriptor::PRIMARY);
                } else {
                    key.setType(CKeyDescriptor::UNIQUE);
                }
            }
            target.push_back(key);
        } else {
            found = false;
        }
        name = qtarget[lsize][4];
        target[count].add_column_name(name,atoi(qtarget[lsize][7].c_str()));
        target[count].set_compound(target[count].column_count()>1);
    }
    return true;
}

bool CMySql::rename_table(const std::string&db,const std::string&table,const std::string&new_name)const
{
    std::string command = "";
    if (!Sql_Connection) {
        do_message(MessageArray[4]);
        return false;
    }
    if (table.size() == 0) {
        return false;
    }
    if (connect_db(db) < 0) {
        return false;
    }
    if (is_system_db(db)) {
        do_message(MessageArray[5]);
        return false;
    }
    command = "ALTER TABLE ";
    command+= table;command+= " RENAME AS ";command+= new_name;
    do_message(command);
    int i = mysql_real_query(Sql_Connection,command.data(),command.size());
    if (i < 0) {
        do_message(get_last_error());
        return false;
    }
    return true;
}

bool CMySql::alter_table(const std::string&db, const std::string&table,ColumnList&n_columns,const KeyList&n_keys,
                         change_list&columns_change,KeyList&key_orig)const
{
    std::string command = "";
    std::string temp_command = "";
    unsigned int idx;
    change_list::iterator change_iterator;
    change_type temp_change;

    if (!Sql_Connection) {
        do_message(MessageArray[4]);
        return false;
    }
    if (table.size() == 0) {
        return false;
    }
    if (is_system_db(db)) {
        do_message(MessageArray[5]);
        return false;
    }
    if (connect_db(db)!=0) {
        do_message("Could not connect to database");
        return false;
    }
    command = "ALTER TABLE ";
    //command+=db;command+='.';
    command+= table;

    int first_statement = 1;

    //looking for the primary key
    for (idx = 0; idx < key_orig.size();++idx) {
        if (key_orig[idx].getType() == CKeyDescriptor::PRIMARY) {
            command+=" DROP PRIMARY KEY ";
            first_statement = 0;
        }
    }

    for (idx = 0;idx < key_orig.size();++idx) {
        if (key_orig[idx].getType() != CKeyDescriptor::PRIMARY) {
            if (!first_statement) {
                command+=", ";
            } else {
                command+=" ";
                first_statement = 0;
            }
            command+="DROP KEY ";
            command+=key_orig[idx].get_name();
            command+=" ";
        }
    }
    for (idx = 0;idx < columns_change.size();++idx) {
        if (columns_change[idx].typ == change_type::del &&
            columns_change[idx].columns.first.size()>0) {
            if (!first_statement) {
                command+=", ";
            } else {
                command+=" ";
                first_statement = 0;
            }
            command+="DROP ";
            command+=columns_change[idx].columns.first;
            command+=" ";
        }
    }
    for (idx = 0; idx < n_columns.size();++idx) {
        //change_iterator = columns_change.find_second(n_columns[idx].get_name());
        change_iterator = find_second(columns_change,n_columns[idx].get_name());

        if (change_iterator!=columns_change.end()) {
            if (!first_statement) {
                command+=", ";
            } else {
                command+=" ";
                first_statement = 0;
            }
            switch (change_iterator->typ) {
            case change_type::add:
                command+="ADD ";
                break;
            case change_type::mod:
                command+="CHANGE ";
                command+=change_iterator->columns.first;
                command+=" ";
                break;
            default:
                continue;
                break;
            }
            if (!build_command(temp_command,n_columns[idx])) {
                return false;
            }
            command+=temp_command;
        }
    }
    build_key_command(temp_command,&n_keys,true);
    if (temp_command.size())
        command+=temp_command;
    do_message(command);
    first_statement = mysql_real_query(Sql_Connection,command.data(),command.size());
    if (first_statement < 0) {
        do_message(get_last_error());
        return false;
    }
    do_message(mysql_info(Sql_Connection));
    return true;
}

int CMySql::build_command(std::string&target,CColumnDescriptor&desc)const
{
    std::string Type = "";
    stringstream ss;
    target.resize(0);
    target=desc.get_name();
    target+=" ";
    string esc;
    Type = TypeDescript(desc.get_FieldType());
    if (Type.length() ==  0) {
        do_message("Unknown fieldtype");
        return 0;
    }
    //special cases for enums and sets

    if (desc.get_FieldType() == 21 || desc.get_FieldType() == 22) {
        stringIlist current_enums;
        current_enums = desc.enum_list();
        if (current_enums.size() == 0) {
            do_message("Empty SETs/ENUMs are not allowed!");
            return 0;
        }
        unsigned int max_enum = 64;
        if (desc.get_FieldType()==17) {
            max_enum = 65535;
        }
        if (current_enums.size() > max_enum) {
            ss.str("");
            ss << "More than " << max_enum << (max_enum==64?"SET":"ENUM")
               << "s are not allowed!";
            do_message(ss.str());
            return 0;
        }
        Type+="(";
        for (max_enum=0;max_enum<current_enums.size();++max_enum) {
            if (max_enum)
                Type+=",";
            Type+="'";
            do_escape(current_enums[max_enum],esc);
            Type+=esc;
            Type+="'";
        }
        Type+=")";
    }
    target+=Type;
    target+=" ";
    if (desc.get_MaxLength()>0 && desc.get_FieldType() != 21 && desc.get_FieldType() != 22) {
        ss.str("");
        ss << "("
           << desc.get_MaxLength();
        if (desc.get_MaxDecimals() > 0) {
            ss << ", "
               << desc.get_MaxDecimals();
        }
        ss << ") ";
        target+=ss.str();
    }
    if (desc.is_Unsigned())
        target+="UNSIGNED ";
    if (desc.is_ZeroFill())
        target+="ZEROFILL ";
    if (desc.is_Binary())
        target+="BINARY ";
    if (desc.is_NotNull()) {
        target+="NOT NULL ";
        if (desc.get_default() && strlen(desc.get_default())>0) {
            target+="DEFAULT '";
            target+=desc.get_default();
            target+="' ";
        }
    }
    if (desc.is_AutoIncrement())
        target+="AUTO_INCREMENT ";
    return 1;
}

int CMySql::build_key_command(std::string&target,const KeyList*keys,bool add)
{
    stringstream ss;
    target.resize(0);
    KeyList::const_iterator key;
    if (keys) {
        int already_prim = 0;
        pairIlist col_list;

        int f_count = 0;
        for (key = keys->begin(); key != keys->end(); ++key) {
            f_count = 0;
            if (add)
                target+=", ADD ";
            else
                target+=", ";
            switch(key->getType()) {
            case CKeyDescriptor::PRIMARY:
                if (!already_prim) {
                    target+="PRIMARY KEY ";
                    already_prim = 1;
                } else {
                    target+="UNIQUE ";
                    //key->setType(CKeyDescriptor::UNIQUE);
                }
                break;
            case CKeyDescriptor::UNIQUE:
                target+="UNIQUE ";
                break;
            case CKeyDescriptor::INDEX:
                target+="INDEX ";
                break;
            default:
                continue;
            }
            if (key->getType() != CKeyDescriptor::PRIMARY) {
                target+=key->get_name();
            }
            col_list = key->get_ColList();
            if (col_list.size() == 0)
                continue;
            target+="(";
            pairIlist::iterator iter;
            iter = col_list.begin();
            ss.str("");
            for (;iter!=col_list.end();++iter) {
                if (f_count> 0)
                    ss << ",";
                ++f_count;
                ss << iter->first.c_str();
                if (iter->second > 0) {
                    ss << "("
                       << iter->second
                       << ")";
                }
            }
            target+=ss.str();
            target+=") ";
        }
    }
    return 1;
}

/*
 * this method and the other do_statement are mostly the same. the difference is that this one will return
 * a preformatted stringlist. 'Cause this would happen inside the main loop it make real more sense to write
 * down it twice instead of putting some ifs inside the loop.
 */
bool CMySql::do_statement(const std::string&statement,stringlist&target,stringlist&headers,
                          bool log_errors_only)const
{
    target.resize(0);
    headers.resize(0);

    if (!Sql_Connection) {
        do_message(MessageArray[4]);
        return false;
    }
    MYSQL_ROW row;
    MYSQL_FIELD*Field;

    std::string query;
    stringstream ss;

    MYSQL_RES*Res=0;
    if (!log_errors_only)
        do_message(statement);
    int result = mysql_real_query(Sql_Connection,statement.data(),statement.size());
    if (result < 0) {
        if (log_errors_only)
            do_message(statement);
        do_message(get_last_error());
        return false;
    }
    Res = mysql_store_result(Sql_Connection);
    if (!Res) {
        query = mysql_error(Sql_Connection);
        if (!query.empty()) {
            if (log_errors_only)
                do_message(statement);
            do_message(query);
            return false;
        }
        return true;
    }
    unsigned long zaehler = Res->row_count;
    if (!log_errors_only) {
        ss.str("");
        ss << zaehler << " " << MessageArray[0];
        do_message(ss.str());
    }
    std::string helper;
    std::string entry;
    unsigned int j;
    unsigned long*laengen;
    while ((row=mysql_fetch_row(Res))) {
        laengen = mysql_fetch_lengths(Res);
        for (j = 0;j < mysql_num_fields(Res);j++) {
            if (!row[j]) {
                query.clear();
            } else {
                query.assign((char*)row[j],laengen[j]);
            }
            Res->current_field = j;
            Field = mysql_fetch_field(Res);
            unsigned int max_size = Field->max_length;
            std::string f = Field->name;
            if (f.size()< max_size) {
                f.resize(max_size,' ');
            } else {
                max_size = f.size();
            }
            if (target.size() == 0) {
                headers.push_back(std::string(f));
            }
            //ok - justify
            int groesse = max_size-query.size();
            helper.resize(0);
            if (IS_NUM(Field->type)) {
                helper.resize(groesse>=0?groesse:0,' ');
            }
            helper+=query;
            if (!IS_NUM(Field->type)) {
                helper.resize(max_size,' ');
            }
            if (helper.size() == 0)
                helper = " ";
            if (j<mysql_num_fields(Res)-1)
                // its the simplest way to select datas - hope there is no tab in a field
                helper+="\t";
            entry+=helper;
        }
        //append to the list
        target.push_back(entry);
        entry = "";
    }
    mysql_free_result(Res);
    return true;
}

bool CMySql::do_statement(const std::string&statement,list_vector&target,stringlist&headers,
                          bool log_error_only)const
{
    target.resize(0);
    headers.resize(0);

    if (!Sql_Connection) {
        do_message(MessageArray[4]);
        return false;
    }
    MYSQL_ROW row;
    MYSQL_FIELD*Field;

    std::string query;
    stringstream ss;

    MYSQL_RES*Res=0;
    if (!log_error_only)
        do_message(statement);
    int result = mysql_real_query(Sql_Connection,statement.data(),statement.size());
    if (result < 0) {
        if (log_error_only)
            do_message(statement);
        do_message(get_last_error());
        return false;
    }
    Res = mysql_store_result(Sql_Connection);
    if (!Res) {
        query = mysql_error(Sql_Connection);
        if (!query.empty()) {
            if (log_error_only)
                do_message(statement);
            do_message(query);
            return false;
        }
        return true;
    }
    if (!log_error_only) {
        unsigned long zaehler = Res->row_count;
        ss.str("");
        ss << zaehler << " " << MessageArray[0];
        do_message(ss.str());
    }
    stringlist helper;
    string f;
    unsigned int j;
    unsigned long * laengen;
    while ((row=mysql_fetch_row(Res))) {
        laengen = mysql_fetch_lengths(Res);
        helper.resize(0);
        for (j = 0;j < mysql_num_fields(Res);++j) {
            if (row[j]) {
                query.assign(row[j],laengen[j]);
            } else {
                query.resize(0);
            }
            Res->current_field = j;
            if (target.size()==0) {
                Field = mysql_fetch_field(Res);
                f = Field->name;
                headers.push_back(std::string(f));
            }
            helper.push_back(query);
        }
        //append to the list
        target.push_back(helper);
    }
    mysql_free_result(Res);
    return true;
}

bool CMySql::revoke_right(const std::string&ahost,const std::string&auser, const std::string&adb,
                          const std::string&atable, const stringlist&arights,bool log_error_only)
{
    stringstream statement;
    list_vector target;
    stringlist headers;

    if (ahost.size()==0) {
        do_message("Host name for missing!");
        return false;
    }
    if (auser.size()==0) {
        do_message("User name for revoke missing!");
        return false;
    }
    if (arights.size()==0) {
        do_message("Which rights should I revoke?");
        return false;
    }
    statement << "REVOKE ";
    for (unsigned c=0; c < arights.size();++c) {
        if (c!=0)
            statement<<", ";
        statement << arights[c];
    }
    statement << " on "<<adb<<"."<<atable<<" from '"<<auser<<"'@'"<<ahost<<"'";
    return do_statement(statement.str(),target,headers,log_error_only);
}

const char**CMySql::host_rights()
{
    static const char*b3[]={"Select","Insert","Update","Delete","Create","Drop","Grant","References","Index","Alter",0};

    static const char*b4[]={
        "Select","Insert","Update","Delete","Create","Drop","Grant","References","Index","Alter",
        "Create_tmp_table","Lock_tables",0
    };

    if (Server_MasterVersion<4) {
        return b3;
    } else {
        return b4;
    }
}

const char**CMySql::user_rights()
{
    static const char*bu3[]={
        "Select","Insert","Update","Delete","Create","Drop","Grant","References","Index","Alter","Reload","Shutdown",
        "Process","File",0
    };

    static const char*bu4[]={
        "Select","Insert","Update","Delete","Create","Drop","Grant","References","Index","Alter","Reload","Shutdown",
        "Process","File","Show_db","Super","Create_tmp_table","Lock_tables","Execute","Repl_slave","Repl_client",0
    };

    if (Server_MasterVersion<4) {
        return bu3;
    } else {
        return bu4;
    }
}

const char**CMySql::db_rights()
{
    return host_rights();
}

const char**CMySql::table_rights()
{
    static const char*tb3[]={
        "Select","Insert","Update","Delete","Create","Drop","Grant","Index","Alter",0
    };
    return tb3;
}

const char**CMySql::column_rights()
{
    static const char*columnrights[]={"Select","Insert","Update",0};
    return columnrights;
}

unsigned long int CMySql::table_rows(const std::string&database,const std::string&table)const
{
    stringstream statement;
    list_vector target;
    stringlist headers;
    statement << "select count(*) from "<<database<<"."<<table;
    if (!do_statement(statement.str(),target,headers,true)||target.size()==0) {
        return 0;
    }
    unsigned long value = strtoul(target[0][0].c_str(),NULL,10);
    return value;
}

stringlist CMySql::explodeTypeString(const std::string&input)
{
    stringlist ret;
    size_t pos,spos;
    pos = spos = string::npos;
    // 0 == normal 1 == between '' or ""
    int state = 0;

    /* first search for the first "(" - that should always without a ' before.*/
    pos = input.find("(");
    if (pos == string::npos) {
        //ok. nothing to do.
        ret.push_back(input);
        ret.push_back("");
        ret.push_back("");
        return ret;
    }
    ret.push_back(input.substr(0,pos));
    spos = pos+1;
    /* second search for the ending ")" */
    bool foundit = false;
    for (pos = spos; pos < input.size();++pos) {
        switch (input[pos]) {
        case ')':
            if (state!=0) {
                continue;
            } else {
                foundit = true;
            }
            break;
        case '\'':
            if (state == 0) state = 1;
            else if (state==1) state = 0;
            break;
        case '\"':
            if (state == 0) state = 2;
            else if (state==2) state = 0;
            break;
        default:
            break;

        }
        if (foundit) break;
    }
    ret.push_back(input.substr(spos,pos-spos));
    ret.push_back(input.substr(++spos,input.size()));
    return ret;
}

#endif // HAVE_MYSQL_LIBS
