//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "mysqlhelp.h"
#include "topiclistviewitem.h"
#include "kmysqladmin/helpers/qt_stl_string.h"

#include <string>
#include <sstream>
#include <iostream>

#include <qlayout.h>
#include <klistview.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <klocale.h>
#include <ktextbrowser.h>

using namespace std;
CMysqlhelp::CMysqlhelp(smart_pointer<CMySql>& _sql_server,QWidget* parent, const char* name, WFlags fl)
    : CMysqlHelpData(parent, name, fl),sql_server(_sql_server)
{
    m_helptree->addColumn(i18n("Content"));
    m_keywordlist->addColumn(i18n("Keywords"));
    init_topics();
    init_keywords();
    m_HelpTextWindow->setText("<H3>Helpbrowser</h3><br>This is a browser for the help stored inside mysql server. "
                                "If cannot see any items inside the lists it may be you doesn't have this helptable installed or "
                                "you don't have permissions reading them."
                                "<br>Or your administrator had not installed this table due an upgrade from older mysql server."
                                "<p>Ask your administrator for installing this tables and give access to it.");
}


CMysqlhelp::~CMysqlhelp()
{
}


void CMysqlhelp::keywordSelChanged(QListViewItem*itm)
{
    ctopiclistviewitem*item = (ctopiclistviewitem*)itm;
    disp_item(item);
}

void CMysqlhelp::selbboxDispChanged(int)
{
}

void CMysqlhelp::disp_item(ctopiclistviewitem*item)
{
    if (!item || !sql_server || item->TopicId()<0) {
        m_HelpTextWindow->setText("No text");
        return;
    }
    list_vector target;
    PatternList Pattern;
    stringlist which;
    stringstream os;
    os << item->TopicId();
    which.push_back("description");
    which.push_back("example");
    which.push_back("url");
    Pattern.push_back(CPatternPair("help_topic_id",os.str(),"="));
    int i = sql_server->fetch_rows("mysql","help_topic","name",true,which,target,0,0,&Pattern,true);

    if (i<0) {
        m_HelpTextWindow->setText("No text cause sql error");
        return;
    }
    if (target.size()!=1) {
        m_HelpTextWindow->setText("No text");
        return;
    }
    os.str("");
    os << "<pre>"<<target[0][0]<<"</pre>\n";
    if (target[0][1].size()) {
        os << "<h3>Example</h3>\n<pre>"<<target[0][1]<<"</pre>";
    }
    if (target[0][2].size()) {
        os << "<h3>See also</h3>"<<target[0][2];
    }
    m_HelpTextWindow->setText(QString("<H2>")+item->text(0)+"</h2>"+
        STL_TO_QT_STRING(os.str()));
}

void CMysqlhelp::topicSelChanged()
{
    ctopiclistviewitem*item = (ctopiclistviewitem*)m_helptree->currentItem();
    disp_item(item);
}

/*!
    \fn CMysqlhelp::init_keywords()
 */
void CMysqlhelp::init_keywords()
{
    if (!sql_server) return;

    ostringstream os;
    os << "select mysql.help_keyword.name,"
        << "mysql.help_relation.help_topic_id,"
        << "mysql.help_topic.name from "
        << "mysql.help_relation,mysql.help_topic,mysql.help_keyword where mysql.help_topic.help_topic_id=mysql."
        << "help_relation.help_topic_id and"
        << " mysql.help_keyword.help_keyword_id=mysql.help_relation.help_keyword_id "
        << "order by mysql.help_keyword.name,mysql.help_topic.help_topic_id;";


    list_vector target;
    stringlist which;

    int i = sql_server->do_statement(os.str(),target,which,true);
    if (i<0) return;
    ctopiclistviewitem*n,*parent;
    parent = 0;
    string last_topic = "";
    for (unsigned j=0; j<target.size();++j) {
        if (last_topic != target[j][0]) {
            parent = new ctopiclistviewitem(m_keywordlist);
            parent->setText(0,STL_TO_QT_STRING(target[j][0]));
            parent->setSelectable(false);
            parent->setTopicId(-1);
            last_topic = target[j][0];
        }
        if (!parent) continue;
        n = new ctopiclistviewitem(parent);
        n->setText(0,STL_TO_QT_STRING(target[j][2]));
        n->setTopicId(::atoi(target[j][1].c_str()));
        n->setPixmap(0,SmallIcon("edit"));
    }
}

void CMysqlhelp::insert_sub_categories(ctopiclistviewitem*parent,int depth)
{
    if (!sql_server/*||depth>=2*/) return;
    stringlist which;
    list_vector target;
    PatternList Pattern;
    stringstream os;
    which.push_back("help_category_id");
    which.push_back("name");
    which.push_back("parent_category_id");
    if (parent) {
        os << parent->CategoryId();
    } else {
        os << 0;
    }
    Pattern.push_back(CPatternPair("parent_category_id",os.str(),"="));
    target.clear();
    int i = sql_server->fetch_rows("mysql","help_category","name",true,which,target,0,0,&Pattern,true);

    if (i<0) return;

    for (unsigned j = 0; j < target.size();++j) {
        ctopiclistviewitem*n;
        if (parent && parent->ParentId()!=-1) {
            n = new ctopiclistviewitem(parent);
        } else {
            n = new ctopiclistviewitem(m_helptree);
        }
        n->setText(0,target[j][1].c_str());
        n->setCategoryId(::atoi(target[j][0].c_str()));
        n->setParentId(parent?parent->CategoryId():-1);
        n->setTopicId(-1);
        /* ieks - there is a strange bug inside this help table */
        if (n->CategoryId()==0) continue;
        insert_sub_categories(n,depth+1);
        insert_sub_topics(n);
        if (n->childCount()==0) {
            delete n;
        } else {
            n->setSelectable(false);
        }
    }
}

void CMysqlhelp::insert_sub_topics(ctopiclistviewitem*parent)
{
    if (!parent||!sql_server) return;
    stringlist which;
    list_vector target;
    PatternList Pattern;
    stringstream os;
    which.push_back("name");
    which.push_back("help_topic_id");
    os << parent->CategoryId();
    Pattern.push_back(CPatternPair("help_category_id",os.str(),"="));
    int i = sql_server->fetch_rows("mysql","help_topic","name",true,which,target,0,0,&Pattern,true);
    if (i<0) return;
    ctopiclistviewitem*n;

    for (unsigned j = 0; j < target.size();++j) {
        n = new ctopiclistviewitem(parent);
        n->setTopicId(::atoi(target[j][1].c_str()));
        n->setText(0,target[j][0].c_str());
        n->setCategoryId(-1);
        n->setParentId(parent->CategoryId());
        n->setPixmap(0,SmallIcon("edit"));
    }
}

/*!
    \fn CMysqlhelp::init_topics()
 */
void CMysqlhelp::init_topics()
{
    m_helptree->clear();
    if (!sql_server) return;
    insert_sub_categories();
}

/* testing purpose */
HelpDialog::HelpDialog(smart_pointer<CMySql>& _sql_server,QWidget*parent,const char*name, bool modal, WFlags f)
    : QDialog(parent,name,modal,f)
{
    QVBoxLayout*dlglayout = new QVBoxLayout(this);
    dlglayout->setSpacing(2);
    dlglayout->setMargin(1);
    m_helpview = new CMysqlhelp(_sql_server,this);
    dlglayout->addWidget(m_helpview);
}


/*!
    \fn CMysqlhelp::disp_testdlg()
 */
void CMysqlhelp::disp_testdlg(smart_pointer<CMySql>& _sql_server)
{
    HelpDialog dlg(_sql_server);
    dlg.exec();
}
