/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KNET_H_
#define _KNET_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "debug.h"
#include <qstring.h>
#include <qlayout.h>
#include <kmainwindow.h>
#include <kdialogbase.h>
#include <kpassdlg.h>
#include "knetconfig.h"
//#include "ethernetConfig.h"
//#include "internetConfig.h"
//#include "ethernetdev.h"

 //class Network_Connections;
 class QGridLayout;
 class KPushButton;
 class PPPStats; 
 class NetworkDev;
 class EthernetScan;
 class modemScan;
 class openingDialog;
 class PrefDialog;
 class DockWidget;  
 class QIconViewItem;

 
class SignalEvent : public QEvent {
public:
  SignalEvent(int s) : QEvent(User), sig(s) { }
  int sigType() const { return sig; }
private:
  int sig;
}; 
 
/**
 * @short Application Main Window
 * @author Judd Baileys <jbaileys@bigpond.net.au>
 * @version 0.1
 */
//class knet : public QWidget

#define MAXLOOPNEST (MAX_SCRIPT_ENTRIES/2)

class knet : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    knet(QWidget *parent=0, const char *name=0);
    ~knet();
    /**
     * Default Destructor
     */
 //   virtual ~knet();
    QGridLayout* StartwinLayoutMain;   
//    EthernetDev* ethernetdev;   
    NetworkDev* networkdev;
    EthernetScan* ethernetscan;    
    modemScan* modemscan;      
    openingDialog* openingdialog; 
  virtual bool eventFilter(QObject *, QEvent *);
  
public slots:
  void executePreferencesDlg();
//  void applyPreferences();   
  void resetAccounts();
  void expandbutton();
  void setup();
  void shutDown();
  void startProcess();
  void accountselected(QIconViewItem *item);
  void dialupStart();
  void if_waiting_timed_out();
  void script_timed_out();
  void init();
  void discon();
  void lostConnection();
  void getStats();
  void interfaceUp();
  void testOSD();
  void networkscan();
  void log_window_toggled(bool on);

protected:
  void timerEvent(QTimerEvent *);

private slots:
  void saveMyself();
  void if_waiting_slot();
  void readChar(unsigned char);
  void pause();

public:
  PPPStats *stats;
  bool connected; 
  DockWidget* dock_widget; 
  QString myreadbuffer;
  int main_timer_ID;
  DebugWidget *debugwindow;

signals:
  void if_waiting_signal(); 
  void debugMessage(const QString &);
  void debugPutChar(unsigned char);
  void toggleDebugWindow();
  void closeDebugWindow();

private:

  int loopnest;
  int loopstartindex[MAXLOOPNEST];
  bool loopend;
  QString loopstr[MAXLOOPNEST];


  bool expecting;
  bool semaphore;
  int scriptindex;
  QString scriptCommand, scriptArgument;
  QStringList *comlist, *arglist;
  void checkBuffers();
  QString readbuffer;
  void setScan(const QString &);
  void setExpect(const QString &);
  void writeline(const QString &);
  QString scanvar;
  QString scanstr;
  QString scanbuffer;
  bool scanning;
  bool pausing;
 QString expectstr;
  void interruptConnection();
  void sigChld();
  void sigPPPDDied();
  QGridLayout* openingLayout;  
  PrefDialog *m_prefDialog;  
  QString encodeWord(const QString &s);
//  QTimer *clocktimer;  
  QTimer *if_timer;
  QTimer *if_timeout_timer;
  QTimer *autostart_timer;
  QTimer *timeout_timer;
  QTimer *inittimer;
  QTimer *pausetimer;
  bool execppp();
  int substate;
  int vmain;
  unsigned int dialnumber;
  int scriptTimeout;
  bool firstrunID;
  bool firstrunPW;
};

extern void killppp();
void adddns();
void addpeerdns();
void removedns();
void add_domain(const QString & newdomain);
void auto_hostname();

#endif // _KNET_H_
