/***************************************************************************
 *   Copyright (C) 2005 by Judd Baileys                                    *
 *   jbaileys@bigpond.net.au                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PREFDIALOG_H
#define PREFDIALOG_H 

#include <kdialogbase.h>
#include <qwidget.h>
#include <kcombobox.h>
#include <qgroupbox.h>
#include <kaboutdata.h>
#include <kstdaction.h>
#include <kaboutdialog.h>
#include <kfiledialog.h>
#include <qlistview.h>
#include <qcheckbox.h>
#include <qwidgetstack.h>
#include <kiconview.h>

#include "knet.h"
#include <qstring.h>
#include <qlayout.h>

 class PPPData;
 class PPPStats;
 class Knet;
 class modemDev;
 class NetworkDev;
 class EthernetScan;
 class modemScan;
 class openingDialog;
 class KPushButton; 
 class QGridLayout;
 class internetSetup;
// class SuProcess;
 class QString;
 class QCString;
// class KDEsuClient;
class settingsDialog; 
  
class PrefDialog : public KDialogBase
{
Q_OBJECT
public:
PrefDialog(QWidget *parent , const char *name = 0 );
~PrefDialog();

public slots:
void slotDefault();
void slotApply();
void slotCancel();
void enableApply();
void applyDSL();
void applyDialup();
void applyEthernet();
void okClicked();
void applyDNS();
void applyAdvance();
void applyGeneralSettings();
void TestOSD();
void applyModem();
void applyNewModem();
void applyNetwork();
void applyScript();

private:
    NetworkDev* networkdev;
    EthernetScan* ethernetscan;    
    modemScan* modemscan; 
    internetSetup* internetsetup;
//    settingsChange* settingschange;
    Knet *m_knet;
    settingsDialog* settingsdialog;

private slots:
bool checkPassword(const QString &);
  
signals:
void resetaccounts();
void OSDTesting();
     
public:
PPPStats *stats;
};

#endif
