  /*

  knetfilter v 3.0.3

  Copyright (C) 2002 Luigi Genoni
                     venom@sns.it
  */
  

#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>
#include <strings.h>

#include "knat.h"

// List Rotes

void knetfilter::startlistRoutes() {

  routes.clearArguments();

  if ( system_has_tc == 1 )
    {
      routes << "ip" << "route" << "show";
    }
  else
    {
      routes << "route" << "-n";
    }

  bool success=routes.start(KProcess::NotifyOnExit,
			    KProcess::AllOutput);
  if (success)
    {
      statusbar->message(i18n("Running..."), 2000);
    }
  else
    {
      if ( system_has_tc == 1 )
	{
	  statusbar->message(i18n("Couldn't start ip"), 2000);
	}
      else
	{
	  statusbar->message(i18n("Couldn't start route"), 2000);
	}
    };

};

// List Addresses

void knetfilter::startlistAddr() {

  addr.clearArguments();

  if ( system_has_tc == 1 )
    {
      addr << "ip" << "addr" << "show";
    }
  else
    {
      addr << "ifconfig";
    }

  bool success=addr.start(KProcess::NotifyOnExit,
			 KProcess::AllOutput);

  if (success)
    {
      statusbar->message(i18n("Running..."), 2000);
    }
  else
    {
      if ( system_has_tc == 1 )
	{
	  statusbar->message(i18n("Couldn't start ip"), 2000);
	}
      else
	{
	  statusbar->message(i18n("Couldn't start route"), 2000);
	}
    };

};

//List Route Cache

void knetfilter::startlistrouteCache() {

  routecache.clearArguments();

  routecache << "route" << "-C" << "-n";

  bool success=routecache.start(KProcess::NotifyOnExit,
				KProcess::AllOutput);
  if (success)
    {
      statusbar->message(i18n("Running..."), 2000);
    }
  else
    {
      statusbar->message(i18n("Couldn't start route"), 2000);
    };
  
};

void knetfilter::routeRules() {
  if ( routeList == NULL )
    {
      setupConnect();

      routeList = new KNFWidget();
      routeList->resize(480,320);
      routeList->setCaption("Show Routes, IpAddrs, Route Cache");

      QBoxLayout *top = new QBoxLayout(routeList, QBoxLayout::LeftToRight, 7);
      QGridLayout *grid = new QGridLayout(7,5);
      top->addLayout(grid,5);

      routeBox = new QListBox(routeList);
      grid->addMultiCellWidget(routeBox,0,5,0,5);

      QPushButton *btnRoutes = new QPushButton(routeList);
      btnRoutes->setText("Routes");
      btnRoutes->setFixedHeight(btnRoutes->sizeHint().height());
      connect(btnRoutes,SIGNAL(clicked()), this, SLOT(startlistRoutes()));
      grid->addWidget(btnRoutes,7,0);

      QPushButton *btnAddr = new QPushButton(routeList);
      btnAddr->setText("IpAddr");
      btnAddr->setFixedHeight(btnAddr->sizeHint().height());
      connect(btnAddr,SIGNAL(clicked()), this, SLOT(startlistAddr()));
      grid->addWidget(btnAddr,7,1);

      QPushButton *btnrouteCache = new QPushButton(routeList);
      btnrouteCache->setText("RT-cache");
      btnrouteCache->setFixedHeight(btnrouteCache->sizeHint().height());
      connect(btnrouteCache,SIGNAL(clicked()), this, SLOT(startlistrouteCache()));
      grid->addWidget(btnrouteCache,7,2);

      QPushButton *btnClose = new QPushButton(routeList);
      btnClose->setText("Close");
      btnClose->setFixedHeight(btnClose->sizeHint().height());
      connect(btnClose,SIGNAL(clicked()), this, SLOT(closerouteRules()));
      grid->addWidget(btnClose,7,5);
      
            routeList->show();
	    setCentralWidget(routeList);
    }
  else
    {
      if ( !routeList->isVisible() )
	{
	  routeList->show();
	}
      else
	{
          QMessageBox::critical(0,"Warning", "Already Running\n");
        }
    }  
};

// And so we can also close everything ;)

void knetfilter::closerouteRules() {

  routeList->close();

};


void knetfilter::listRoutesDone() {

  if (routes.normalExit() && (routes.exitStatus()==0))
    statusbar->message(i18n("Listing Routes..."), 2000);
  else
    statusbar->message(i18n("Couldn't list Routes"), 2000);

};


void knetfilter::listAddrDone() {

  if (addr.normalExit() && (addr.exitStatus()==0))
    statusbar->message(i18n("Listing Ip Addresses..."), 2000);
  else
    statusbar->message(i18n("Couldn't list Ip Addresses"), 2000);

};


void knetfilter::listrouteCacheDone() {

  if (routecache.normalExit() && (routecache.exitStatus()==0))
    statusbar->message(i18n("Listing Route Cache..."), 2000);
  else
    statusbar->message(i18n("Couldn't list Route Chache"), 2000);

};


// set up output

void knetfilter::listRoutes(KProcess *, char *data, int len) {

  if (len<0)
    return;
  static QString remainder;
  QString list;

  char dst[len+1];
  memmove(dst,data,len);
  dst[len]=0;

  list=remainder+dst;
  QStrList lines;
  int index=0;
  int newindex=0;

  while (1)
  {
    newindex=list.find('\n',index);
    if(newindex==-1) {
      remainder=list.right(list.length()-index);
      break;
    } else {
      lines.append(list.mid(index,newindex-index));
      index=newindex+1;
    };
  };

  if(lines.count()>0){
    routeBox->insertStrList(&lines);
  };

  routeBox->insertItem(remainder.data());
  routeBox->setTopItem(routeBox->count()-routeBox->numItemsVisible());
};
