//
// C++ Interface: interface
//
// Description:
//
//
// Author: Hugo Parente Lima <hugo.pl@gmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef INTERFACE_H
#define INTERFACE_H

#include <qstring.h>
#include "knetstatsview.h"
class KNetStats;

class Interface {
	QString mName;
	KNetStatsView* mView;
	KNetStats* mParent;

	Interface(const Interface&);
public:
	/**
	*	Constructs a new interface.
	*	\param parent	parent of the view of this interface.
	*	\param name		name of this interface (not the QObject name!!)
	*/
	Interface(KNetStats* parent, const QString& name);

	/**
	*	Set this interface visible to the user via a KNetStatsView.
	*/
	void setVisible(bool visible);
	bool isVisible() { return mView; }

	void update();

	void say(const QString& message);

	KNetStatsView::Options options();
};

#include <qmap.h>
typedef QMap<QString, Interface*> InterfaceMap;


#endif
