/***************************************************************************
                          dlg_login.h  -  description
                             -------------------
    begin                : Sat Sep 29 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLG_LOGIN_H
#define DLG_LOGIN_H

#include <qwidget.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qgroupbox.h>

#include <kdialogbase.h>
#include <klineedit.h>
#include <kcombobox.h>

#include "resource.h"

/**
  *@author Troy Corbin Jr. / Alexander Wels
  */

class dlg_login : public KDialogBase
{
   Q_OBJECT

  public:
                          dlg_login(QWidget *parent, const char *name=0, resource *rsrc = NULL);
                          ~dlg_login();
		void									disableServerSelect();

  public slots:
    void                  slotOk( void );
    void                  slotGuestToggle( bool );
		void									slotUpdateUser(const QString&);

  signals:
    void                  login(QString userName, QString passWord);

  private:
    QVBox                 *BOX_Parent;
    QVBox                 *BOX_TEXT;
    QVBox                 *BOX_EDIT;
		QHBox									*BOX_ALIGN;
    KLineEdit             *EDIT_Login;
    KLineEdit             *EDIT_Password;
    QLabel                *TEXT_Login;
    QLabel                *TEXT_Password;
    QCheckBox             *CHECKBOX_GUEST;
		QGroupBox							*GROUP_Select_Server;
		QGroupBox							*GROUP_Username;
		KComboBox							*COMBO_Select_Server;

    resource 							*myResource;
		struct serverResource *server;
};

#endif
