/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Thu Mar  1 10:43:51 CST 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "knights.h"
	
static KCmdLineOptions options[] =
{
	{ "d <path>", I18N_NOOP("Specify the location of your Knights data directory."), 0 },
	{ "+[filename]", I18N_NOOP("A .pgn file to be loaded."), 0 },
	{ 0, 0, 0 }
};

int main(int argc, char *argv[])
{
	KAboutData aboutData(	"knights",
												I18N_NOOP("Knights"),
												_VERSION_,
												I18N_NOOP("The Knights Chess Interface\n\nKnights is a chess interface\nfor the K Desktop Environment."),
												KAboutData::License_GPL_V2,
												"(c) 2003, Troy Corbin Jr.",
												0,
												"http://knights-chess.com",
												"troy@knights-chess.com");

  aboutData.addAuthor("Troy Corbin Jr.",
											I18N_NOOP("Project Manager and Programmer"),
											"tcorbin@users.sourceforge.net",
											"http://knights.sourceforge.net");
  aboutData.addAuthor("Alexander Wels",
											I18N_NOOP("Communications Programmer"),
											"agpwels@adelphia.net",
											"");
  aboutData.addCredit("Mark Westcott",
											I18N_NOOP("Qtopia port and patches"),
											"mark@houseoffish.org",
											"");
  aboutData.addCredit("Kunnar Klauks",
											I18N_NOOP("Patches and suggestions"),
											"kunnk@yahoo.com",
											"");
  aboutData.addCredit("Harald Fernengel",
											I18N_NOOP("KDE3 Compatability Patch"),
											"harry@kdevelop.org",
											"");
  aboutData.addCredit("Tim Mann",
											I18N_NOOP("XBoard protocol"),
											"tim.mann@compaq.com",
											"http://www.tim-mann.org/chess.html");
	aboutData.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"),
													I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options );
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

	KApplication a;
  Knights *knights = new Knights(args);
	a.setMainWidget(knights);
	if( !knights->init() )	// Did we init ok?
	{
		return 0;
	}
	/* Without this connection, the destructors are not called, and some
			housecleaning ( like destroying child processes ) isn't done */
	a.connect( &a, SIGNAL( shutDown () ), knights, SLOT( KillAll() ) );
	return a.exec();
}
