/***************************************************************************
                          setpageaudio.cpp  -  description
                             -------------------
    begin                : Thu Jan 10 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qregexp.h>
#include "setpageaudio.moc"

setPageAudio::setPageAudio(QWidget *parent, resource *Rsrc ) : QVBoxLayout(parent)
{
	Parent = parent;
	Resource = Rsrc;
	NewSounds = 0;
	changeTheme = FALSE;

	BUTTON_enableAudio = new QCheckBox( i18n( "Enable Audio" ), parent );
	BUTTON_enableAudio->setChecked( Resource->OPTION_Audio );
	addWidget( BUTTON_enableAudio );
	connect(	BUTTON_enableAudio, SIGNAL( toggled(bool) ),
						this, SLOT( slot_enableAudio(bool) ) );

	GROUP_Theme = new QGroupBox( 1,
																Qt::Vertical,
																i18n( "Audio Themes" ),
																parent );
	addWidget( GROUP_Theme );
	Current_Theme = new KComboBox ( GROUP_Theme );
	buildThemeList();
	connect(	Current_Theme, SIGNAL( activated(int) ),
						this, SLOT( slot_currentTheme(int) ) );

	BOX_Main = new QHBox( parent );
	addWidget( BOX_Main );

	GROUP_Volume = new QGroupBox( 3, Qt::Vertical, i18n( "Volume" ), BOX_Main );
	Vol_Max = new QLabel( i18n( "Maximum" ), GROUP_Volume );
	Current_Volume = new QSlider ( 0, 100, 10, Resource->Audio_Volume, 	QSlider::Vertical, GROUP_Volume );
	connect(	Current_Volume, SIGNAL( valueChanged(int) ), this, SLOT( slot_currentVolume(int) ) );
	Current_Volume->setTickmarks( QSlider::Right );
	Vol_Min = new QLabel( i18n( "Minimum" ), GROUP_Volume );

	BOX_Options = new QVBox( BOX_Main );
	BUTTON_AudioCurrentOnly = new QCheckBox( i18n( "For Current Match Only" ), BOX_Options );
	BUTTON_AudioCurrentOnly->setChecked( Resource->OPTION_Audio_Current_Only );
	connect(	BUTTON_AudioCurrentOnly, SIGNAL( toggled(bool) ),
						this, SLOT( slot_AudioCurrentOnly(bool) ) );
}
setPageAudio::~setPageAudio()
{
}
///////////////////////////////////////
//
//	setPageAudio::slot_enableAudio
//
///////////////////////////////////////
void setPageAudio::slot_enableAudio( bool state )
{
	Resource->OPTION_Audio = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageAudio::slot_currentTheme
//
///////////////////////////////////////
void setPageAudio::slot_currentTheme( int Index )
{
	NewSounds = Index;
	changeTheme = TRUE;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageAudio::slot_currentVolume
//
///////////////////////////////////////
void setPageAudio::slot_currentVolume( int Level )
{
	Resource->Audio_Volume = Level;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageAudio::slot_AudioCurrentOnly
//
///////////////////////////////////////
void setPageAudio::slot_AudioCurrentOnly( bool state )
{
	Resource->OPTION_Audio_Current_Only = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageAudio::buildThemeList
//
///////////////////////////////////////
void setPageAudio::buildThemeList( void )
{
	QString buffer;
	int tmp(0);

	Current_Theme->clear();
	Resource->readThemeDir();
	while(1)
	{
		buffer = Resource->getSounds( tmp );
		if( buffer.isEmpty() ) break;
		buffer.remove( 0, 2 );
		buffer.replace( QRegExp("_"), " " );
		buffer.replace( QRegExp(".tar"), "" );
		buffer.replace( QRegExp(".gz"), "" );
		buffer.replace( QRegExp(".bz2"), "" );
		Current_Theme->insertItem( buffer, tmp );
		if( Resource->getSounds() == Resource->getSounds( tmp ) )
		{
			Current_Theme->setCurrentItem( tmp );
			NewSounds = tmp;
		}
		tmp++;
	}
}
