// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//Version $Revision: 1.9 $

#include "hk_kdefilterdialog.h"
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <hk_class.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>

hk_kdefilterdialog::hk_kdefilterdialog(enum_type type, QWidget* parent,  const char* name, bool modal, WFlags fl )
: hk_kdefilterdialogbase( parent, name, modal, fl )
{
    p_type=type;
    buttonOk->setEnabled(true);
    setCaption(i18n("Filter Dialog"));
    buttonOk->setText(i18n("&Ok"));
    buttonCancel->setText(i18n("&Cancel"));
    textfield->setFocus();
    QString n=(type==filter?"Filter":"Editor");
    KConfig* c=kapp->config();
    QRect rect(0,0,200,150);
    c->setGroup(n);
    QRect g;
    g=c->readRectEntry("Geometry",&rect);
    setGeometry(g);
   if (type==editor)setCaption(i18n("Editor"));
    
}


hk_kdefilterdialog::~hk_kdefilterdialog()
{
// no need to delete child widgets, Qt does it all for us
}


void hk_kdefilterdialog::text_changed()
{
//    buttonOk->setEnabled(!textfield->text().isEmpty());
}


void hk_kdefilterdialog::closeEvent(QCloseEvent*e)
{


 hk_kdefilterdialogbase::closeEvent(e);
}

void hk_kdefilterdialog::accept()
{
  store_size();
  hk_kdefilterdialogbase::accept();
}


void hk_kdefilterdialog::reject()
{
  store_size();
  hk_kdefilterdialogbase::reject();
}

void hk_kdefilterdialog::store_size()
{
KConfig* c=kapp->config();
  QString n=(p_type==filter?"Filter":"Editor");
  c->setGroup(n);
  c->writeEntry("Geometry",geometry());

}



