BEGIN;

ALTER TABLE content ADD COLUMN type varchar(255);
ALTER TABLE content ALTER COLUMN type SET DEFAULT 'text';

ALTER TABLE content ADD COLUMN title varchar(255);
ALTER TABLE content ALTER COLUMN type SET DEFAULT 'text';

ALTER TABLE content ADD COLUMN lastupdated timestamp;
ALTER TABLE content ALTER COLUMN lastupdated SET DEFAULT now();

ALTER TABLE content ADD COLUMN lastupdatedby integer;
ALTER TABLE content ALTER COLUMN lastupdatedby SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN alias varchar(255);
ALTER TABLE tree ALTER COLUMN alias SET DEFAULT '';

ALTER TABLE tree ADD COLUMN contentcollapsed integer;
ALTER TABLE tree ALTER COLUMN contentcollapsed SET DEFAULT 0;
--
ALTER TABLE tree ADD COLUMN subinheritrights integer;
ALTER TABLE tree ALTER COLUMN subinheritrights SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN subinheritrightseditable integer;
ALTER TABLE tree ALTER COLUMN subinheritrightseditable SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN subinheritrightsdisable integer;
ALTER TABLE tree ALTER COLUMN subinheritrightsdisable SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN subinheritowner integer;
ALTER TABLE tree ALTER COLUMN subinheritowner SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN subinheritgroup integer;
ALTER TABLE tree ALTER COLUMN subinheritgroup SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN subinherituserrights integer;
ALTER TABLE tree ALTER COLUMN subinherituserrights SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN subinheritgrouprights integer;
ALTER TABLE tree ALTER COLUMN subinheritgrouprights SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN subinheritotherrights integer;
ALTER TABLE tree ALTER COLUMN subinheritotherrights SET DEFAULT 0;

ALTER TABLE users ADD COLUMN password2 varchar(32);
ALTER TABLE users ALTER COLUMN password2 SET DEFAULT '';
UPDATE users SET password2 = "password";
ALTER TABLE users DROP COLUMN "password";
ALTER TABLE users RENAME COLUMN password2 TO "password";

CREATE TABLE extensions (
	id integer PRIMARY KEY DEFAULT nextval('seq_knowledge'),
	keyname varchar(255) DEFAULT '',
	active integer DEFAULT 0,
	admin integer DEFAULT 0,
	version varchar(30) DEFAULT ''
);

CREATE TABLE settings (
	id integer PRIMARY KEY DEFAULT nextval('seq_knowledge'),
	name varchar(255) NOT NULL,
	value varchar(255) DEFAULT '',
	description varchar(255) NOT NULL DEFAULT '',
	selection varchar(255) NOT NULL DEFAULT '',
	UNIQUE (name)
);

CREATE TABLE content_open (
	id integer PRIMARY KEY DEFAULT nextval('seq_knowledge'),
	contentid integer DEFAULT 0,
	userid varchar(32) DEFAULT '',
	opened integer DEFAULT 0
);

CREATE TABLE users_login (
  usersid integer default 0,
  login_trial integer default 0,
  lasttrydate integer default 0,
  session_id varchar(100) default '',
  UNIQUE (usersid)
);

INSERT INTO extensions (keyname, active, admin) VALUES ('admin_extension', 1, 1);
INSERT INTO extensions (keyname, active, admin) VALUES ('admin_info', 1, 1);
-- INSERT INTO extensions (keyname, active, admin) VALUES ('admin_install', 1, 1);
-- INSERT INTO extensions (keyname, active, admin) VALUES ('admin_update', 1, 1);
INSERT INTO extensions (keyname, active, admin) VALUES ('admin_config', 1, 1);

INSERT INTO settings (name, value, description, selection) VALUES ('login.delay', '30', 'setting login delay', '');
INSERT INTO settings (name, value, description, selection) VALUES ('login.max', '50', 'setting max login', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.charset', 'UTF-8', 'set charset', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.language', 'en', 'set default language', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.language_dropdown', '0', 'show language dropdown', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.availablelanguages.1', 'en', '', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.availablelanguages.2', 'de', '', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.availablelanguages.3', 'pt-br', '', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.availablelanguages.4', 'nl', '', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.availablelanguages.5', 'ja', '', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.availablelanguages.6', 'es', '', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.availablelanguages.7', 'ru', '', '');
INSERT INTO settings (name, value, description, selection) VALUES ('htmleditor.use', '1', 'enable rte editor', '');
INSERT INTO settings (name, value, description, selection) VALUES ('htmleditor.editor', 'fckeditor', 'choose fckeditor or tinymce', '');
INSERT INTO settings (name, value, description, selection) VALUES ('htmleditor.tinymce.cols', '75' , 'set cols for textarea in tinymce', '');
INSERT INTO settings (name, value, description, selection) VALUES ('htmleditor.tinymce.rows', '20', 'set rows for textarea in tinymce', '');
INSERT INTO settings (name, value, description, selection) VALUES ('htmleditor.fckeditor.width', '600', 'set widht of fckeditor', '');
INSERT INTO settings (name, value, description, selection) VALUES ('htmleditor.fckeditor.height', '450', 'set height of fckeditor', '');
INSERT INTO settings (name, value, description, selection) VALUES ('htmleditor.fckeditor.langdefault', 'en', 'set default lang in default fckeditor', '');
INSERT INTO settings (name, value, description, selection) VALUES ('htmleditor.fckeditor.langdetect', 'false', 'enable autodetection of language in fckeditor', '');
INSERT INTO settings (name, value, description, selection) VALUES ('htmleditor.fckeditor.toolbar', 'Default', 'choose toolbar in fckeditor', '');
INSERT INTO settings (name, value, description, selection) VALUES ('htmleditor.fckeditor.skin', 'default', 'choose skin in fckeditor', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.title', 'Knowledgeroot', 'set title for knowledgeroot', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.expandall', '1', 'expand menu at default', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.type', 'static', 'set menu type', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.ajax', 'yes', 'use ajax menu', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.default_theme', 'green', 'set theme in knowledgeroot', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.showtitle', 'yes', 'show title of contents', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.collapsecontent', 'yes', 'enable collapse content', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.showlastupdated', 'yes', 'show lastupdate of content', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.uploadfolder', 'uploads/', 'set upload folder', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.uploadserverpath', 'auto', 'set upload server path', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.defaultpage', '', 'set id of default page', '');
INSERT INTO settings (name, value, description, selection) VALUES ('email.notification', '0', 'enable email notification', '');
INSERT INTO settings (name, value, description, selection) VALUES ('email.recipients', '', 'set recipients', '');
INSERT INTO settings (name, value, description, selection) VALUES ('email.type', 'html', 'enable html mails', '');
INSERT INTO settings (name, value, description, selection) VALUES ('email.from_name', 'Knowledgeroot', 'set from name', '');
INSERT INTO settings (name, value, description, selection) VALUES ('email.from_email', 'knowledgeroot@mydomain.tld', 'set from email', '');
INSERT INTO settings (name, value, description, selection) VALUES ('email.smtp_mode', '0', 'enable to use smtp instead of mail', '');
INSERT INTO settings (name, value, description, selection) VALUES ('email.smtp_host', '', 'set smtp host', '');
INSERT INTO settings (name, value, description, selection) VALUES ('email.smtp_port', '25', 'set port of host', '');
INSERT INTO settings (name, value, description, selection) VALUES ('email.smtp_username', '', 'set username for authentification', '');
INSERT INTO settings (name, value, description, selection) VALUES ('email.smtp_password', '', 'set password for authentification', '');
INSERT INTO settings (name, value, description, selection) VALUES ('dev.toolbar', '0', 'show developer toolbar', '');
INSERT INTO settings (name, value, description, selection) VALUES ('pagealias.use', '1', 'enable pagealias', '');
INSERT INTO settings (name, value, description, selection) VALUES ('pagealias.rights', '2', 'set rights to edit the alias', '');
INSERT INTO settings (name, value, description, selection) VALUES ('pagealias.static', '0', 'enable of using static links', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.maxfilesize', '5242880', 'set maxfilesize for uploads', '');

CREATE INDEX idx_content_owner ON content USING btree (owner);
CREATE INDEX idx_content_group ON content USING btree ("group");
CREATE INDEX idx_content_userrights ON content USING btree (userrights);
CREATE INDEX idx_content_grouprights ON content USING btree (grouprights);
CREATE INDEX idx_content_otherrights ON content USING btree (otherrights);
CREATE INDEX idx_content_deleted ON content USING btree (deleted);

CREATE INDEX idx_content_open_contentid ON content_open USING btree (contentid);
CREATE INDEX idx_content_open_userid ON content_open USING btree (userid);

CREATE INDEX idx_files_deleted ON files USING btree (deleted);

CREATE INDEX idx_groups_deleted ON groups USING btree (deleted);

CREATE INDEX idx_tree_owner ON tree USING btree (owner);
CREATE INDEX idx_tree_group ON tree USING btree ("group");
CREATE INDEX idx_tree_userrights ON tree USING btree (userrights);
CREATE INDEX idx_tree_grouprights ON tree USING btree (grouprights);
CREATE INDEX idx_tree_otherrights ON tree USING btree (otherrights);
CREATE INDEX idx_tree_deleted ON tree USING btree (deleted);

CREATE INDEX idx_user_group_userid ON user_group USING btree (userid);
CREATE INDEX idx_user_group_groupid ON user_group USING btree (groupid);

CREATE INDEX idx_users_password ON users USING btree (password);
CREATE INDEX idx_users_deleted ON users USING btree (deleted);

CREATE INDEX idx_extensions ON extensions USING btree (active);

COMMIT;