<?php
/**
 * This class set the default menu in knowledgeroot
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-default-menu.php 349 2007-04-17 21:33:29Z lordlamer $
 */
class default_menu {

	var $CLASS;
	var $defaultmenu = array();

	/**
	 * init/start class
	 */
	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
		$this->set_default_menu();
		$this->load_default_menu();
	}

	/**
	 *
	 */
	function load_default_menu() {
		$this->CLASS['kr_extension']->menu = array_merge_recursive($this->CLASS['kr_extension']->menu, $this->defaultmenu);
	}

	/**
	 *
	 */
	function set_default_menu() {
		// BEGIN TOP MENU
		// login
		$this->defaultmenu['top']['login']['name'] = $this->CLASS['language']->get['menu']['login'];
		$this->defaultmenu['top']['login']['link'] = "index.php?action=login";
		$this->defaultmenu['top']['login']['tooltip'] = "login";
		$this->defaultmenu['top']['login']['logout'] = "1";
		$this->defaultmenu['top']['login']['priority'] = "10";

		// logout
		$this->defaultmenu['top']['logout']['name'] = $this->CLASS['language']->get['menu']['logout'];
		$this->defaultmenu['top']['logout']['link'] = "index.php?action=logout";
		$this->defaultmenu['top']['logout']['tooltip'] = "logout";
		$this->defaultmenu['top']['logout']['login'] = "1";
		$this->defaultmenu['top']['logout']['priority'] = "90";

		// roots
		$this->defaultmenu['top']['roots']['name'] = $this->CLASS['language']->get['menu']['roots'];
		$this->defaultmenu['top']['roots']['link'] = "index.php?action=createroot";
		$this->defaultmenu['top']['roots']['tooltip'] = "create root";
		$this->defaultmenu['top']['roots']['login'] = "1";
		$this->defaultmenu['top']['roots']['priority'] = "10";
		$this->defaultmenu['top']['roots']['admin'] = "1";

		// user
		$this->defaultmenu['top']['user']['name'] = $this->CLASS['language']->get['menu']['user'];
		$this->defaultmenu['top']['user']['link'] = "index.php?action=users";
		$this->defaultmenu['top']['user']['tooltip'] = "create users";
		$this->defaultmenu['top']['user']['login'] = "1";
		$this->defaultmenu['top']['user']['priority'] = "20";
		$this->defaultmenu['top']['user']['admin'] = "1";

		// options
		$this->defaultmenu['top']['options']['name'] = $this->CLASS['language']->get['menu']['options'];
		$this->defaultmenu['top']['options']['link'] = "index.php?action=options";
		$this->defaultmenu['top']['options']['tooltip'] = "edit options";
		$this->defaultmenu['top']['options']['login'] = "1";
		$this->defaultmenu['top']['options']['priority'] = "30";
		// END TOP MENU

		// BEGIN TREE NAVI
		// hide button
		$this->defaultmenu['tree']['hide']['name'] = $this->CLASS['language']->get['tree']['hidetree'];
		$this->defaultmenu['tree']['hide']['image'] = "images/left.gif";
		$this->defaultmenu['tree']['hide']['imagewidth'] = "22";
		$this->defaultmenu['tree']['hide']['link'] = "javascript:;";
		$this->defaultmenu['tree']['hide']['atagparams'] = "border=\"0\" onclick=\"HideTree();\"";
		$this->defaultmenu['tree']['hide']['wrap'] = "<td>|</td>";
		$this->defaultmenu['tree']['hide']['priority'] = "10";

		// expand all
		$this->defaultmenu['tree']['expand']['name'] = $this->CLASS['language']->get['tree']['expand'];
		$this->defaultmenu['tree']['expand']['image'] = "images/plus.gif";
		$this->defaultmenu['tree']['expand']['imagewidth'] = "22";
		$this->defaultmenu['tree']['expand']['link'] = "javascript:;";
		$this->defaultmenu['tree']['expand']['atagparams'] = "onclick=\"TreeExpand(".'{$ID}'.");\"";
		$this->defaultmenu['tree']['expand']['wrap'] = "<td>|</td>";
		$this->defaultmenu['tree']['expand']['priority'] = "20";

		// reload all
		$this->defaultmenu['tree']['reload']['name'] = $this->CLASS['language']->get['tree']['reload'];
		$this->defaultmenu['tree']['reload']['image'] = "images/reload.gif";
		$this->defaultmenu['tree']['reload']['imagewidth'] = "22";
		$this->defaultmenu['tree']['reload']['link'] = "javascript:;";
		$this->defaultmenu['tree']['reload']['atagparams'] = "onclick=\"TreeReload(".'{$ID}'.");\"";
		$this->defaultmenu['tree']['reload']['wrap'] = "<td>|</td>";
		$this->defaultmenu['tree']['reload']['priority'] = "30";

		// collapse all
		$this->defaultmenu['tree']['collapse']['name'] = $this->CLASS['language']->get['tree']['collapse'];
		$this->defaultmenu['tree']['collapse']['image'] = "images/minus.gif";
		$this->defaultmenu['tree']['collapse']['imagewidth'] = "22";
		$this->defaultmenu['tree']['collapse']['link'] = "javascript:;";
		$this->defaultmenu['tree']['collapse']['atagparams'] = "onclick=\"TreeCollapse(".'{$ID}'.");\"";
		$this->defaultmenu['tree']['collapse']['wrap'] = "<td>|</td>";
		$this->defaultmenu['tree']['collapse']['priority'] = "40";

		// checking treestyle and slide
		if($this->CLASS['vars']['menu']['type'] == "static") {
			$fixedstyle = "style=\"display:none;\"";
			$slidestyle = "style=\"display:block;\"";
		} else {
			$fixedstyle = "style=\"display:block;\"";
			$slidestyle = "style=\"display:none;\"";
		}

		// tree fixed
		$this->defaultmenu['tree']['fixed']['name'] = $this->CLASS['language']->get['tree']['showmenu'];
		$this->defaultmenu['tree']['fixed']['image'] = "images/fixed.gif";
		$this->defaultmenu['tree']['fixed']['imagewidth'] = "22";
		$this->defaultmenu['tree']['fixed']['link'] = "javascript:;";
		$this->defaultmenu['tree']['fixed']['atagparams'] = "onclick=\"TreeFixed();\"";
		$this->defaultmenu['tree']['fixed']['wrap'] = "<td><div id=\"treefixed\" ".$fixedstyle.">|</div>";
		$this->defaultmenu['tree']['fixed']['priority'] = "40";

		// tree slide
		$this->defaultmenu['tree']['slide']['name'] = $this->CLASS['language']->get['tree']['closemenu'];
		$this->defaultmenu['tree']['slide']['image'] = "images/close.gif";
		$this->defaultmenu['tree']['slide']['imagewidth'] = "22";
		$this->defaultmenu['tree']['slide']['link'] = "javascript:;";
		$this->defaultmenu['tree']['slide']['atagparams'] = "onclick=\"TreeSlide();\"";
		$this->defaultmenu['tree']['slide']['wrap'] = "<div id=\"treeslide\" ".$slidestyle.">|</div></td>";
		$this->defaultmenu['tree']['slide']['priority'] = "41";

		// END TREE NAVI

		// BEGIN PAGE NAVI
		// new page
		$this->defaultmenu['page']['newpage']['name'] = $this->CLASS['language']->get['newpage'];
		$this->defaultmenu['page']['newpage']['link'] = "index.php?action=newpage";
		$this->defaultmenu['page']['newpage']['pagerights'] = "2";
		$this->defaultmenu['page']['newpage']['priority'] = "10";

		// edit page
		$this->defaultmenu['page']['editpage']['name'] = $this->CLASS['language']->get['renamepage'];
		$this->defaultmenu['page']['editpage']['link'] = "index.php?action=editpage";
		$this->defaultmenu['page']['editpage']['pagerights'] = "2";
		$this->defaultmenu['page']['editpage']['priority'] = "20";

		// move page
		$this->defaultmenu['page']['movepage']['name'] = $this->CLASS['language']->get['movepage'];
		$this->defaultmenu['page']['movepage']['link'] = "#";
		$this->defaultmenu['page']['movepage']['atagparams'] = "onclick=\"window.document.forms.move.move.value='move'; window.open('move.php?type=page','Knowledgeroot','width=310,height=400,menubar=yes,resizable=yes,scrollbars=yes');\"";
		$this->defaultmenu['page']['movepage']['pagerights'] = "2";
		$this->defaultmenu['page']['movepage']['priority'] = "30";

		// delete page
		$this->defaultmenu['page']['deletepage']['name'] = $this->CLASS['language']->get['delpage'];
		$this->defaultmenu['page']['deletepage']['link'] = "index.php?delpage=";
		$this->defaultmenu['page']['deletepage']['addid'] = "1";
		$this->defaultmenu['page']['deletepage']['atagparams'] = "onclick=\"return confirm('" . $this->CLASS['language']->get['delpageask'] . "');\"";
		$this->defaultmenu['page']['deletepage']['pagerights'] = "2";
		$this->defaultmenu['page']['deletepage']['priority'] = "40";

		// create new content
		$this->defaultmenu['page']['createcontent']['name'] = $this->CLASS['language']->get['newcontent'];
		$this->defaultmenu['page']['createcontent']['link'] = "index.php?action=newcontent";
		$this->defaultmenu['page']['createcontent']['pagerights'] = "2";
		$this->defaultmenu['page']['createcontent']['priority'] = "50";

		// END PAGE NAVI

		// BEGIN CONTENT NAVI
		// edit content
		$this->defaultmenu['content']['editcontent']['name'] = $this->CLASS['language']->get['editcontent'];
		$this->defaultmenu['content']['editcontent']['link'] = "index.php?eid=";
		$this->defaultmenu['content']['editcontent']['addid'] = "1";
		$this->defaultmenu['content']['editcontent']['contentrights'] = "2";
		$this->defaultmenu['content']['editcontent']['priority'] = "10";
		$this->defaultmenu['content']['editcontent']['contenttype'] = "text";

		// delete content
		$this->defaultmenu['content']['deletecontent']['name'] = $this->CLASS['language']->get['delcontent'];
		$this->defaultmenu['content']['deletecontent']['link'] = "index.php?delid=";
		$this->defaultmenu['content']['deletecontent']['addid'] = "1";
		$this->defaultmenu['content']['deletecontent']['atagparams'] = "onclick=\"return confirm('" . $this->CLASS['language']->get['delete'] . "');\"";
		$this->defaultmenu['content']['deletecontent']['contentrights'] = "2";
		$this->defaultmenu['content']['deletecontent']['priority'] = "20";
		$this->defaultmenu['content']['deletecontent']['contenttype'] = "text";

		// move content
		$this->defaultmenu['content']['movecontent']['name'] = $this->CLASS['language']->get['movecontent'];
		$this->defaultmenu['content']['movecontent']['link'] = "#";
		$this->defaultmenu['content']['movecontent']['atagparams'] = "onclick=\"window.document.forms.move.contentid.value='".'{$ID}'."'; window.document.forms.move.move.value='cmove'; window.open('move.php','Knowledgeroot','width=310,height=400,menubar=yes,resizable=no');\"";
		$this->defaultmenu['content']['movecontent']['contentrights'] = "2";
		$this->defaultmenu['content']['movecontent']['pagerights'] = "2";
		$this->defaultmenu['content']['movecontent']['priority'] = "30";
		$this->defaultmenu['content']['movecontent']['contenttype'] = "text";

		// content history
		/*
		$this->defaultmenu['content']['contenthistory']['name'] = $this->CLASS['language']->get['contenthistory'];
		$this->defaultmenu['content']['contenthistory']['link'] = "index.php?action=contenthistory&historyof=";
		$this->defaultmenu['content']['contenthistory']['addid'] = "1";
		$this->defaultmenu['content']['contenthistory']['priority'] = "35";
		$this->defaultmenu['content']['contenthistory']['contenttype'] = "text";
		*/
		
		// add file
		$this->defaultmenu['content']['addfile']['name'] = $this->CLASS['language']->get['addfile'];
		$this->defaultmenu['content']['addfile']['link'] = "#";
		$this->defaultmenu['content']['addfile']['addid'] = "1";
		$this->defaultmenu['content']['addfile']['atagparams'] = "onclick=\"return ShowById('fileform_".'{$ID}'."');\"";
		$this->defaultmenu['content']['addfile']['contentrights'] = "2";
		$this->defaultmenu['content']['addfile']['priority'] = "40";
		$this->defaultmenu['content']['addfile']['contenttype'] = "text";

		// END CONTENT NAVI

		// BEGIN CONTENT_LINE NAVI
		$this->defaultmenu['contentline']['top']['name'] = $this->CLASS['language']->get['top'];
		$this->defaultmenu['contentline']['top']['link'] = "#top";
		$this->defaultmenu['contentline']['top']['tooltip'] = $this->CLASS['language']->get['topdescription'];
		$this->defaultmenu['contentline']['top']['priority'] = "10";
		// END CONTENT_LINE NAVI
	}
}

?>