<?php
/**
 *
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-tree.php 356 2007-04-22 13:02:35Z lordlamer $
 */
class pathTree {
  var $CLASS;
  var $cache = array(); // cache of tree records indexed by tree id


  /**
   * init/start class
   */
  function start(&$CLASS) {
    $this->CLASS =& $CLASS;
  }

  /**
   * return path of a treeid with htmlcontent
   */
  function getPath($id = "0", $urlPrefix = '') {
    if($id == "") { $id = "0"; }
    $treeRecord = $this->getTreeRecord($id);

    if($treeRecord != null)  {
      if($treeRecord->belongs_to == "0") {
        return "/ <a href=\"" . $urlPrefix . "index.php?id=".$treeRecord->id."\">".$treeRecord->title."</a>";
      } else {
        $path = $this->getPath($treeRecord->belongs_to, $urlPrefix);
        return $path . " / <a href=\"" . $urlPrefix . "index.php?id=".$treeRecord->id."\">" . $treeRecord->title."</a>";
      }
    } else {
      return "/ ";
    }
  }

  /**
   * return path of a treeid without htmlcontent
   */
  function getTextPath($id = "0", $urlPrefix = '') {
    if($id == "") { $id = "0"; }
    $treeRecord = $this->getTreeRecord($id);

    if($treeRecord != null)  {
      if($treeRecord->belongs_to == "0") {
        return "/ ".$treeRecord->title;
      } else {
        $path = $this->getTextPath($treeRecord->belongs_to, $urlPrefix);
        return $path . " / " . $treeRecord->title;
      }
    } else {
      return "/ ";
    }
  }

  /**
   *
   */
  function getUnlinkedPath($id = "0") {
    if($id == "") { $id = "0"; }
    $treeRecord = $this->getTreeRecord($id);

    if($treeRecord != null)  {
      if($treeRecord->belongs_to == "0") {

        return "/ ".$treeRecord->title;
      } else {
        $path = $this->getUnlinkedPath($treeRecord->belongs_to);
        return $path . " / " . $treeRecord->title;
      }
    } else {
      return "/ ";
    }
  }

  /**
   *
   */
  function getTreePageTitle($id) {

    $treeRecord = $this->getTreeRecord($id);

    if($treeRecord != null)  {
        return $treeRecord->title;
    } else {
      return "";
    }
  }

  /**
   *
   */
  function getTreeRecord($id = "0") {
    $treeRecord = null;
    $no_rows = false;

    if(isset ($this->cache[$id]) and $this->cache[$id] != null) {
      $treeRecord = $this->cache[$id];
    } else {
      $res = $this->CLASS['db']->query(sprintf("SELECT * FROM tree WHERE id=%d",$id));
      $anz = $this->CLASS['db']->num_rows($res);
      if($anz == 1)  {
        $row = $this->CLASS['db']->fetch_object($res);
        $treeRecord = $row;
        $this->cache[$id] = $treeRecord;
      } else {
        return null;
      }
    }
    return $treeRecord;
  }

  /**
   *
   */
  function isTree($id) {
    if(isset($this->cache[$id]) and $this->cache[$id] != null) {
      return TRUE;
    }

    return FALSE;
  }

  /**
   * return parent of element in tree
   */
  function getParent($treeid) {
    $res = $this->CLASS['db']->query(sprintf("SELECT belongs_to FROM tree WHERE id=%d",$treeid));
    $anz = $this->CLASS['db']->num_rows($res);

    if($anz == 1) {
      $row = $this->CLASS['db']->fetch_assoc($res);
      return $row['belongs_to'];
    } else {
      return 0;
    }
  }
}


/**
 *
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-tree.php 356 2007-04-22 13:02:35Z lordlamer $
 */
class categoryTree {
  var $out = array(); // elemts for the user
  var $allelements = array(); // all elements in the table
  var $myelements = array();

  var $open = array();

  var $firstrun = 0;
  var $expand = 0;
  var $doexpand = 0;
  var $targetfile = "index.php";
  var $move = FALSE;
  var $editor = FALSE;

  var $CLASS;
  var $category = array();

  var $userid = 0;
  var $groupid = 0;

  var $admin = 0;

  var $firstrootelement = 1; // used to check if the first rootelement is shown

  /**
   * init/start class
   */
  function start(&$CLASS,$specialCase='',$targetfile="index.php") {
    $this->CLASS =& $CLASS;

    if(!isset($_SESSION['firstrun']) || (isset($_SESSION['firstrun']) && $_SESSION['firstrun'] == 1)) {
      $this->doexpand =& $this->CLASS['vars']['menu']['expandall'];
    } else {
      $this->doexpand = 0;
    }

    $this->move = ($specialCase == 'move');
    $this->editor = ($specialCase == 'editor');
    $this->targetfile = $targetfile;

    if (isset ($_SESSION['admin']) and $_SESSION['admin'] != '') {
      $this->admin = $_SESSION['admin'];
    }

    $this->readAllCategories();
  }

  /**
   *
   */
  function readCategories() {
    if (isset ($this->category[0]) and $this->category[0] != "") {
      return $this->category;
    }

    //fr mysql umschreiben
    if($this->admin == 1) {
      $query = "SELECT * FROM tree WHERE deleted=0 ORDER BY title ASC";
    } else {
      if($this->CLASS['db']->dbtype == "mysql" || $this->CLASS['db']->dbtype == "mysqli") {
        if($_SESSION['groupid'] == 0) {
          $query = sprintf("SELECT * FROM tree WHERE deleted=0 AND ((otherrights > 0) OR (`group`=%d AND grouprights > 0) OR (owner=%d AND userrights>0)) ORDER BY title ASC",$_SESSION['groupid'],$_SESSION['userid']);
        } else {
          $query_part = sprintf(" OR (`group`=%d AND grouprights > 0)",$_SESSION['groupid']);

          $res = $this->CLASS['db']->query(sprintf("SELECT groupid FROM user_group WHERE userid=%d",$_SESSION['userid']));
          while($row = $this->CLASS['db']->fetch_assoc($res)) {
            $query_part .= sprintf(" OR (`group`=%d AND grouprights > 0)",$row['groupid']);
          }

          $query = sprintf("SELECT * FROM tree WHERE deleted=0 AND ((otherrights > 0) %s OR (owner=%d AND userrights>0)) ORDER BY title ASC",$query_part,$_SESSION['userid']);
        }
      } else {
        if($_SESSION['groupid'] == 0) {
          $query = sprintf("SELECT * FROM tree WHERE deleted=0 AND ((otherrights > 0) OR (\"group\"=%d AND grouprights > 0) OR (owner=%d AND userrights>0)) ORDER BY title ASC",$_SESSION['groupid'],$_SESSION['userid']);
        } else {
          $query_part = sprintf(" OR (\"group\"=%d AND grouprights > 0)",$_SESSION['groupid']);

          $res = $this->CLASS['db']->query(sprintf("SELECT groupid FROM user_group WHERE userid=%d",$_SESSION['userid']));
          while($row = $this->CLASS['db']->fetch_assoc($res)) {
            $query_part .= sprintf(" OR (\"group\"=%d AND grouprights > 0)",$row['groupid']);
          }

          $query = sprintf("SELECT * FROM tree WHERE deleted=0 AND ((otherrights > 0) %s OR (owner=%d AND userrights>0)) ORDER BY title ASC",$query_part,$_SESSION['userid']);
        }
      }
    }

    $res = $this->CLASS['db']->query($query);

    while ( $var = $this->CLASS['db']->fetch_assoc($res) ) {
      $out[ $var['belongs_to'] ][ $var['id'] ]['title'] = $var['title'];
      $out[ $var['belongs_to'] ][ $var['id'] ]['alias'] = $var['alias'];
      $out[ $var['belongs_to'] ][ $var['id'] ]['id'] = $var['id'];
      $out[ $var['belongs_to'] ][ $var['id'] ]['belongs_to'] = $var['belongs_to'];
      $myout[ $var['id'] ] = $var['belongs_to'];

      if($this->firstrun == 1) {
        $this->open[$var['id'] ] = 0;
        $_SESSION['open'][$var['id']] = 0;
      }
    }

    $this->out = &$out;
    $this->myelements = &$myout;

    return $out;
  }

  /**
   *
   */
  function readAllCategories() {
    $query = "SELECT * FROM tree WHERE deleted=0 ORDER BY title ASC";
    $res = $this->CLASS['db']->query($query);

    while ( $var = $this->CLASS['db']->fetch_assoc($res) ) {
      $out[  $var['id'] ] = $var['belongs_to'];
    }

    $this->allelements = &$out;
  }

  /**
   *
   */
  function isParentelement($element, $parent) {
    $query = sprintf("SELECT belongs_to FROM tree WHERE id='%s'",$element);
    $res = $this->CLASS['db']->query($query);
    $anz = $this->CLASS['db']->num_rows($res);
    if($anz != 1) {
      return FALSE;
    }

    $row = $this->CLASS['db']->fetch_assoc($res);

    if($row['belongs_to'] == $parent) {
      return TRUE;
    } else {
      return $this->isParentelement($row['belongs_to'],$parent);
    }
  }

  /**
   *
   */
  function buildTree( $rec_id ) {
    echo "<table class=\"tree\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n";
    $cats = $this->readCategories();

    $moveparam = '';
    if($this->CLASS['vars']['menu']['ajax'] == "yes") {
      if($this->CLASS['vars']['menu']['type'] == "static") {
        $fixedstyle = "style=\"display:none;\"";
        $slidestyle = "style=\"display:block;\"";
      } else {
        $fixedstyle = "style=\"display:block;\"";
        $slidestyle = "style=\"display:none;\"";
      }

      if($this->move == TRUE) {
        $moveparam = "1";
      }

      echo '
        <tr><td class="treenavi">
          <div>
            <table width="100%" cellpadding="1" cellspacing="1">
              <tr>
        ';

      // show tree menu
      $this->CLASS['kr_extension']->show_menu("tree",$moveparam);

      echo '
              </tr>
            </table>

          </div>
        </td></tr>
      ';
      echo "<tr><td>\n";
      echo "<div id=\"treeelements\">\n";
      //echo "<div id=\"treeanchor\"></div>\n";
      echo "<table id=\"treeelementtable\" class=\"treeelements\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n";
      echo $this->showAjaxTreePart( $this->getTreePart(0) );
      echo "</table>\n";
      echo "</div>\n";
      echo "</td></tr>\n";
    } else {
      echo $this->showTreePart( $this->getTreePart(0) );
    }

    echo "</table>\n";
  }

	/**
	 *
	 */
	function buildAjaxTreePart($id) {
		if(isset($_SESSION['open'])) {
			$this->open = $_SESSION['open'];
		} else {
			$this->open = array();
		}
		
		$cats = $this->readCategories();

		if($id == "0") {
			$depth = 0;
		} else {
			$depth = 1;
		}

		$spaces = $this->getDeepPart($id) + $depth;
		
		$out = "";
		
		if($this->editor == TRUE) {
			$out .= $this->getContentTitleOfPage($id,$depth+1);
		}
		
		$out .= $this->showAjaxTreePart( $this->getTreePart($id), $spaces );
		
		return $out;

	}

  /**
   *
   */
  function showTreePart( $arr, $indent = 0 ) {
    $space = "";
    $open = array();

    for ( $i=0; $i<$indent; $i++ ) {
      $space .= "&nbsp;<img src=\"images/clear.gif\" width=\"9\" height=\"9\" alt=\"\" />&nbsp;";
    }

    $out = "";

    if( count( $arr ) > 0 ) {
            foreach( $arr as $id => $title ) {
        if($title == "") {
          $title = "[EMPTY]";
        }
        //if($this->visible[$id] == 1) {
          if($this->move == TRUE) {
            $indexfile = "move.php";
          } else {
            $indexfile = "index.php";
          }

          if($this->lastPart($id) == 0) {
            if ((isset ($_SESSION['open'][$id]) and $_SESSION['open'][$id] == 1) || $this->expand == 1 || $this->doexpand == 1) {
              $spaces = $space . "&nbsp;<a class=\"image\" href=\"".$indexfile."?openid=$id\"><img border=\"0\" width=\"9\" height=\"9\" alt=\"\" src=\"images/minus.jpg\" /></a>&nbsp;";
            } else {
              $spaces = $space . "&nbsp;<a class=\"image\" href=\"".$indexfile."?openid=$id\"><img border=\"0\" width=\"9\" height=\"9\" alt=\"\" src=\"images/plus.jpg\" /></a>&nbsp;";
            }
          } else {
            $spaces = $space . "&nbsp;<img class=\"bullet\" width=\"7\" height=\"7\" alt=\"\" src=\"images/black.gif\" />&nbsp;";
          }

          // check if link a actual element
          if($id == $_SESSION['cid']) {
            $class_act = "class=\"active_tree_item\" ";
          } else {
            $class_act = "";
          }

          if($this->move == TRUE) {
            $out .= "<tr><td class=\"tree\" nowrap=\"nowrap\">".$spaces . "<a ".$class_act."href=\"#\" onclick=\"window.opener.document.forms.move.to.value = '".$id."'; window.opener.document.forms.move.submit(); window.close();\">" . $title['title'] . "</a></td></tr>\n";
          } else {
            $out .= "<tr><td class=\"tree\" nowrap=\"nowrap\">".$spaces . "<a ".$class_act."href=\"" . $this->makeLink($title) . "\">" . $title['title'] . "</a></td></tr>\n";
          }

          if ((isset ($this->open[$id]) and $this->open[$id] == 1) || $this->expand == 1 || $this->doexpand == 1) {
            $_SESSION['open'][$id] = 1;
            $this->open[$id] = 1;
            $out .= $this->showTreePart( $this->getTreePart( $id ), $indent+1 );
          }
        //}
      }
    }

    return $out;
  }

	/**
	 * return html that shows the part of a tree
	 */
	function showAjaxTreePart( $arr, $indent = 0 ) {
		$space = "";
		$open = array();
		$imagePrefix = "";
		$minusImage = "minus.jpg";
		$plusImage = "plus.jpg";

		// check if page is editor plugin page
		if($this->editor == TRUE) {
			if ($this->CLASS['vars']['htmleditor']['editor'] == "fckeditor") {
				$imagePrefix = "../../../../";
			} else {
				$imagePrefix = "../../../../../../";
			}
		}
		
		for ( $i=0; $i<$indent; $i++ ) {
			$space .= "&nbsp;<img src=\"".$imagePrefix."images/clear.gif\" width=\"9\" height=\"9\" alt=\"\" />&nbsp;";
		}

		$out = "";

		if( count( $arr ) > 0 ) {
			foreach( $arr as $id => $title ) {
				if($title == "") {
					$title = "[EMPTY]";
				}
				
				if($this->lastPart($id) == 0) {
					$moveparam = "";

					// check if page is movingpage
					if($this->move == TRUE) {
						$moveparam = "1";
					} else {
						$moveparam = "0";
					}
					
					$useeditor = "";
					if($this->editor == TRUE) $useeditor = 1;
					else $useeditor = 0;

					if ((isset ($_SESSION['open'][$id]) and $_SESSION['open'][$id] == 1) || $this->expand == 1 || $this->doexpand == 1) {
						$spaces = $space . "&nbsp;<a id=\"linkid_".$id."\" class=\"image\" href=\"javascript:;\" onclick=\"AjaxMenuClose(".$id.",".$moveparam.",'".$imagePrefix."',".$useeditor.");\"><img id=\"menuimg_".$id."\" border=\"0\" width=\"9\" height=\"9\" alt=\"\" src=\"".$imagePrefix."images/".$minusImage."\" /></a>&nbsp;";
					} else {
						$spaces = $space . "&nbsp;<a id=\"linkid_".$id."\" class=\"image\" href=\"javascript:;\" onclick=\"AjaxMenuOpen(".$id.",".$moveparam.",'".$imagePrefix."',".$useeditor.");\"><img id=\"menuimg_".$id."\" border=\"0\" width=\"9\" height=\"9\" alt=\"\" src=\"".$imagePrefix."images/".$plusImage."\" /></a>&nbsp;";
					}
				} else {
					$spaces = $space . "&nbsp;<img class=\"bullet\" width=\"7\" height=\"7\" alt=\"\" src=\"".$imagePrefix."images/black.gif\" />&nbsp;";
				}

				// check if link a actual element
				if($id == $_SESSION['cid']) {
					$class_act = "class=\"active_tree_item\" ";
				} else {
					$class_act = "";
				}

				// check for rootelement
				if(isset($this->CLASS['vars']['menu']['hrrootline']) && $this->CLASS['vars']['menu']['hrrootline'] == 1 && isset($title['belongs_to']) && $title['belongs_to'] == 0) {
					if($this->firstrootelement == 1) {
						$this->firstrootelement = 0;
						$class_root_item = "class=\"tree\"";
					} else {
						$class_root_item = "class=\"treeRootItem\"";
					}
				} else {
					$class_root_item = "class=\"tree\"";
				}

				if($this->move == TRUE) {
					$out .= "<tr id=\"menu_".$id."\"><td ".$class_root_item." nowrap=\"nowrap\">".$spaces . "<a ".$class_act."id=\"alink_".$id."\" href=\"#\" onclick=\"window.opener.document.forms.move.to.value = '".$id."'; window.opener.document.forms.move.submit(); window.close();\">" . $title['title'] . "</a></td></tr>\n";
				} else if ($this->editor == TRUE) {
					$out .= "<tr id=\"menu_".$id."\"><td ".$class_root_item." nowrap=\"nowrap\">".$spaces . "<a ".$class_act."id=\"alink_".$id."\" onclick=\"editorSelect('index.php?id=".$id."','".$title['title']."')\" href=\"#\">" .$title['title'] . "</a></td></tr>\n";
				} else {
					$out .= "<tr id=\"menu_".$id."\"><td ".$class_root_item." nowrap=\"nowrap\">".$spaces . "<a ".$class_act."id=\"alink_".$id."\" href=\"" . $this->makeLink($title) . "\">" .$title['title'] . "</a></td></tr>\n";
				}

				if ((isset ($this->open[$id]) && $this->open[$id] == 1) || $this->expand == 1 || $this->doexpand == 1) {
					if($this->editor == TRUE) {
						$out .= $this->getContentTitleOfPage($id,$indent+1,$imagePrefix);
					}
					
					$_SESSION['open'][$id] = 1;
					$this->open[$id] = 1;
					$out .= $this->showAjaxTreePart( $this->getTreePart( $id ), $indent+1 );
				}
			}
		}

		return $out;
	}

	/**
	 *
	 */
	function makeLink($link = array()) {
		if(is_array($link)) {
			if($link['alias'] != "" && $this->CLASS['vars']['pagealias']['use'] == 1 && $this->CLASS['vars']['pagealias']['static'] == 1) {
				return $link['alias'] . ".html";
			} else {
				return "index.php?id=" . $link['id'];
			}
		}

		return "";
	}

	/**
	 * return number of parents to root
	 * needed for tree to show subelements
	 */
	function getDeepPart($id) {
		if (isset ($this->allelements[$id]) and $this->allelements[$id] != "" && isset ($this->allelements[$id]) and $this->allelements[$id] != 0) {
			return 1 + $this->getDeepPart($this->allelements[$id]);
		} else {
			return "0";
		}
	}

	/**
	 *
	 */
	function getTreePart( $belongs_to ) {
		// WAAH! ueberfluessig haeufiger Aufruf...mir jetzt egal :)
		$cats = $this->out;
		$out = array();
		if (isset ($cats[ $belongs_to ]) and count( $cats[ $belongs_to ] ) > 0 ) {
			foreach ( $cats[ $belongs_to ] as $id => $entry ) {
				$out[$id] = $entry;
			}
		}

		return $out;
	}

	/**
	 * check if the id is the last part in tree
	 */
	function lastPart($id) {
		foreach($this->myelements as $key => $value) {
			if($this->myelements[$key] == $id) {
				return 0;
			}
		}

		return 1;
	}

	/**
	 * get all content titels of a tree element
	 */
	function getContentTitleOfPage($pageid, $indent = 0,$imagePrefix = "") {
		if($imagePrefix == "") {
			if ($this->CLASS['vars']['htmleditor']['editor'] == "fckeditor") {
				$imagePrefix = "../../../../";
			} else {
				$imagePrefix = "../../../../../../";
			}
		}
		
		$out = "";
		
		// select the content in table content with userrights
		if (isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) {
			if($this->CLASS['db']->dbtype == "pgsql") {
				$query = sprintf("SELECT ct.id as id, ct.content as content, ct.title as title, ct.type as type, u.name as lastupdatedby, to_char(ct.lastupdated,'DD. Mon YYYY HH24:MI:SS') as lastupdated FROM content ct left outer join users u ON ct.lastupdatedby = u.id WHERE belongs_to=%d AND ct.deleted=0 ORDER BY ct.sorting ASC",$pageid);
			} else {
				$query = "SELECT ct.id AS id, ct.content AS content, ct.title AS title, ct.type AS type, u.name AS lastupdatedby, DATE_FORMAT(ct.lastupdated,'%d. %M %Y %H:%i:%s') as lastupdated FROM content ct";
				$query .= sprintf(" LEFT OUTER JOIN users u ON ct.lastupdatedby = u.id WHERE belongs_to=%d AND ct.deleted=0 ORDER BY ct.sorting ASC", $pageid);
			}
		} else {
			// get groups from user
			$res = $this->CLASS['db']->query(sprintf("SELECT groupid FROM user_group WHERE userid=%d",$_SESSION['userid']));
			$orclause = "";
			while($rowuser = $this->CLASS['db']->fetch_assoc($res)) {
				if($this->CLASS['db']->dbtype == "pgsql") {
					$orclause .= sprintf("OR (ct.\"group\"=%d  AND ct.grouprights > 0) ",$rowuser['groupid']);
				} else {
					$orclause .= sprintf("OR (ct.`group`=%d  AND ct.grouprights > 0) ",$rowuser['groupid']);
				}
			}
	
			if($this->CLASS['db']->dbtype == "pgsql") {
				$query = sprintf("SELECT ct.id as id, ct.content as content, ct.title as title, ct.type as type, u.name as lastupdatedby, to_char(ct.lastupdated,'DD. Mon YYYY HH24:MI:SS') as lastupdated FROM content ct left outer join users u ON ct.lastupdatedby = u.id WHERE belongs_to=%d AND ct.deleted=0 AND ((ct.otherrights > 0) OR (ct.\"group\"=%d AND ct.grouprights > 0) %sOR (ct.owner=%d AND ct.userrights>0)) ORDER BY ct.sorting ASC",$pageid,$_SESSION['groupid'],$orclause,$_SESSION['userid']);
			} else {
				$query = "SELECT ct.id AS id, ct.content AS content, ct.title AS title, ct.type AS type, u.name AS lastupdatedby, DATE_FORMAT(ct.lastupdated,'%d. %M %Y %H:%i:%s') AS lastupdated FROM content ct";
				$query .= sprintf(" LEFT OUTER JOIN users u ON ct.lastupdatedby = u.id WHERE belongs_to=%d AND ct.deleted=0 AND ((ct.otherrights > 0) OR (ct.`group`=%d AND ct.grouprights > 0) %s OR (ct.owner=%d AND ct.userrights>0)) ORDER BY ct.sorting ASC",
				$pageid, $_SESSION['groupid'], $orclause,$_SESSION['userid']);
			}
		}

		$res = $this->CLASS['db']->query($query);
	
		$space = "";
		for ( $i=0; $i<$indent; $i++ ) {
			$space .= "&nbsp;<img src=\"".$imagePrefix."images/clear.gif\" width=\"9\" height=\"9\" alt=\"\" />&nbsp;";
		}
		
		$spaces = $space . "&nbsp;<img class=\"bullet\" widht=\"16\" height=\"16\" alt=\"\" src=\"".$imagePrefix."images/pages.gif\" />&nbsp;";
		
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($row['title'] == "") $row['title'] = $row['type'] . " (ID:".$row['id'].")";
			$out .= "<tr id=\"contenttreeid_".$row['id']."\"><td>" . $spaces . "<a href=\"javascript:;\" onclick=\"editorSelect('index.php?contentid=".$row['id']."#".$row['id']."', '".$row['title']."');\">" . $row['title']."</a></td></tr>\n";
		}
		
		return $out;
	}
}

?>
