<?php
/**
 * Knowledgeroot is published under the GNU GPL! Read LICENSE
 *
 * @package Knowledgeroot
 * @author Frank Habermann <lordlamer@lordlamer.de>
 * @author Robert Scholz <scholzrobert@web.de>
 * @version $Id: index.php 357 2007-04-22 18:13:45Z lordlamer $
 */

if(!is_file("config/config.inc.php")) {
	echo "<html><body>No configuration file found! Please make a <a href=\"install.php\">install</a>!</body></html>";
	exit();
}

// load requiered files
require_once("config/config.inc.php");
require_once("include/init.php");

/********************
 * This is the end of initialisation
 * Now do header work
 ********************/

if($CLASS['vars']['knowledgeroot']['charset'] != "") {
  header("Content-Type: text/html; charset=".$CLASS['vars']['knowledgeroot']['charset']."");
  echo '<?xml version="1.0" encoding="'.$CLASS['vars']['knowledgeroot']['charset'].'"?>';
} else {
  echo '<?xml version="1.0" encoding="UTF-8"?>';
}

echo "\n";
?>
<!DOCTYPE html
     PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
     "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<?php
  $CLASS['kr_header']->show_header();
?>
</head>
<body <?php if($CLASS['vars']['menu']['type'] == "slide") { echo "onload=\"Hide('tree');\""; } ?>>

<div style="display: none;" id="messagebox">
  <div id="msg" class="loading"><?php echo $CLASS['language']->get['messagebox']['loading']; ?></div>
</div>

<a name="top"></a>
<table border="0" cellpadding="0" cellspacing="0" width="100%">
	<tr class="head">
		<td class="head" colspan="2">
			<table border="0" cellpadding="0" cellspacing="0" width="100%">
				<tr>
					<td>
						<div class="pagetitle">
							<?php echo $CLASS['vars']['knowledgeroot']['title']; ?>
						</div>
					</td>
					<td align="right" valign="bottom">
						<div class="version">
							<a href="http://www.linuxdelta.de/Knowledgeroot.html">Knowledgeroot</a> - <?php echo $CLASS['language']->get['version'] . ":&nbsp;" . $version; ?>
						</div>
						<div class="mainnavi">
						<?php
						  // show top menu
						  // $CLASS['kr_content']->show_menu();
						  $CLASS['kr_extension']->show_menu("top");
						?>
						</div>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr class="navigationpath">
		<td class="navigation" colspan="2">
			<div class="navigationleft">
				<b><?php echo $CLASS['language']->get['path']; ?>:
	<?php
	  // show path
	  if($CLASS['knowledgeroot']->checkRecursivPerm($_SESSION['cid'], $_SESSION['userid']) != 0) {
	    echo $CLASS['path']->getPath($_SESSION['cid']);
	  } else {
	    echo "/";
	  }

	if (!isset ($_SESSION['user'])) { $_SESSION['user'] = ''; }
	?>

			</b>
		</div>
		<div class="navigationright"><?php echo $CLASS['language']->get['user'] . ":&nbsp;" . $_SESSION['user']; ?>&nbsp;</div>
		<div class="navigationmiddle">
		<form action="index.php" method="post">
	  	<?php echo $CLASS['language']->get['search']; ?>:
			<input class="searchfield" type="text" name="search" value="<?php if(isset ($_POST['search']) and $_POST['search'] != "") { echo htmlspecialchars(stripslashes($_POST['search'])); } ?>" />
			<input type="hidden" name="submit" value="GO"><?php /* FIXED BUG: #39 */ ?>
			<input class="searchgo" type="submit" name="submit" value="<?php echo $CLASS['language']->get['searchgo']; ?>" />
		</form>
		</div>
	<?php
	if(isset($CLASS['vars']['knowledgeroot']['language_dropdown']) && $CLASS['vars']['knowledgeroot']['language_dropdown'] == "1") {
	?>
		<div class="navigationmiddle">
		<form action="index.php" method="post">
			<input type="hidden" name="action" value="change_language" />
	<?php

	if (!isset ($_SESSION['language'])) { $_SESSION['language'] = ''; }

	echo $CLASS['language']->lang_dropdown("language", $_SESSION['language']);

	if ($CLASS['vars']['menu']['ajax'] != "yes") {
		echo '<input class="button" type="submit" name="submit1" value="change" />'."\n";
	}
	?>
		</form>
		</div>
	<?php
	// end for langdropdown
	}
	?>
		</td>
	</tr>

	<tr>
	 <td id="treecontainer">
	   <!-- <a href="#" onClick="ShowHide('tree');">#</a> -->
	  <div id="treeopener" <?php if($CLASS['vars']['menu']['type'] == "static") { echo "style=\"display:none;\""; } else { echo "style=\"display:block;\""; } ?>>
	    <div id="treeshow">
	      <a href="#" onclick="ShowTree();"><img id="treeshowimg" src="images/right.gif" width="22" alt="<?php echo $CLASS['language']->get['tree']['showtree']; ?>" title="<?php echo $CLASS['language']->get['tree']['showtree']; ?>" /></a>
	    </div>
	  </div>

	   <div id="tree" <?php if($CLASS['vars']['menu']['type'] == "static") { echo "style=\"display:block;\""; } else { echo "style=\"display:none; position:absolute;\""; } ?>>
	<?php
	  // show tree
	  if (isset ($_SESSION['open'])) {
	    $CLASS['tree']->open = $_SESSION['open'];
	  }
	  $CLASS['tree']->buildTree(0);
	?>
	  </div>
	 </td>
	 <td id="contentcontainer">
	<?php
	  // show page content
	  $CLASS['kr_header']->show_messages();
	  $CLASS['kr_content']->show_content();
	?>
	 </td>
	</tr>
</table>

<?php
  // show developer toolbar
  if(isset($CLASS['vars']['dev']['toolbar']) && $CLASS['vars']['dev']['toolbar'] == 1) {
    echo "<div id=\"footer\">\n";
    echo "<p>"."\n";
    echo "developer toolbar: <a href=\"http://forum.linuxdelta.de\" target=\"_blank\">forum</a>"."\n";
    echo "<a href=\"http://lists.linuxdelta.de/cgi-bin/mailman/listinfo\" target=\"_blank\">mailinglist</a>"."\n";
    echo "<a href=\"http://www.knowledgeroot.de\" target=\"_blank\">project page</a>"."\n";
    echo "<a href=\"http://www.linuxdelta.de/knowledgeroot.html\">homepage</a>"."\n";
    $CLASS['kr_extension']->show_menu("toolbar");
    echo "</p>"."\n";
    echo "</div>\n";
  }

  // do last cleanups
  $_SESSION['firstrun'] = 0;

  // show querys - only for debug
  if(isset($CLASS['vars']['dev']['sqldebug']) && $CLASS['vars']['dev']['sqldebug'] == 1) {
    echo "querys: " . $CLASS['db']->querys;
    echo $CLASS['error']->view_array($CLASS['db']->query_cache);
  }
  // close db connection
  $CLASS['db']->close();
?>
</body>
</html>
