<?php
/******************************
 * Knowledgeroot
 * Frank Habermann
 * 15.04.2007
 *
 * Version 0.1
 * This Class will help to secure knowledgeroot and to disable XSS
 ******************************/

class libsecure extends extension_base {
	/**
	 * main Function to start Extension
	 */
	function main() {
		$this->CLASS['hooks']->execAtHook("kr_header","check_vars","start","libsecure","doCheck");
	}

	/**
	 * This function starts black and white listing in the right order
	 */
	function doCheck() {
		$order = explode(",", $this->CONF['order']);
		foreach($order as $key => $value) {
			$value = trim($value);
			if($value == "whitelist" && $this->CONF['whitelist'] == 1) $this->doWhitelisting();
			if($value == "blacklist" && $this->CONF['blacklist'] == 1) $this->doBlacklisting();
		}

		// check if fileuploads should be checked
		if($this->CONF['fileuploads'] == 1) $this->doFileUploadFilter();
	}

	/**
	 * This function start the whitelisting
	 */
	function doWhitelisting() {
                // do blacklisting on global vars if enabled in the config
                if($this->CONF['whitelistitems']['POST'] == 1) $this->whitelistVar($_POST,true);
                if($this->CONF['whitelistitems']['GET'] == 1) $this->whitelistVar($_GET,true);
                if($this->CONF['whitelistitems']['COOKIE'] == 1) $this->whitelistVar($_COOKIE,true);
                if($this->CONF['whitelistitems']['SESSION'] == 1) $this->whitelistVar($_SESSION);
                if($this->CONF['whitelistitems']['SERVER'] == 1) $this->whitelistVar($_SERVER,true);
		if($this->CONF['whitelistitems']['REQUEST'] == 1) $this->whitelistVar($_REQUEST,true);
	}

	/**
	 * This function is doing whitelisting on variables
	 */
	function whitelistVar(&$var, $convertslashes = false) {
		require_once('htmlpurifier/HTMLPurifier.auto.php');
		$config = HTMLPurifier_Config::createDefault();
		$config->set('Core', 'Encoding', $this->CLASS['vars']['knowledgeroot']['charset']); //replace with your encoding
		$config->set('Core', 'XHTML', $this->CONF['whitelistconfig']['useXhtml']); //replace with false if HTML 4.01
		$purifier = new HTMLPurifier($config);

		if(is_array($var)) {
			reset($var);
			while(list($key,$val)=each($var)) {
				if(is_array($val)) {
					$this->whitelistVar($var[$key],$convertslashes);
				} else {
					if($convertslashes) $var[$key] = addslashes($purifier->purify(stripslashes($val)));
					else $var[$key] = $purifier->purify($val);
				}
			}
			reset($var);
		} else {
			if($convertslashes) $var = addslashes($purifier->purify(stripslashes($var)));
			else $var = $purifier->purify($var);
		}
	}

	/**
	 * This function start the blacklisting
	 */
	function doBlacklisting() {
		// do blacklisting on global vars if enabled in the config
		if($this->CONF['blacklistitems']['POST'] == 1) $this->blacklistVar($_POST,true);
		if($this->CONF['blacklistitems']['GET'] == 1) $this->blacklistVar($_GET,true);
		if($this->CONF['blacklistitems']['COOKIE'] == 1) $this->blacklistVar($_COOKIE,true);
		if($this->CONF['blacklistitems']['SESSION'] == 1) $this->blacklistVar($_SESSION);
		if($this->CONF['blacklistitems']['SERVER'] == 1) $this->blacklistVar($_SERVER,true);
		if($this->CONF['blacklistitems']['REQUEST'] == 1) $this->blacklistVar($_REQUEST,true);
	}

	/**
	 * This function is doing blacklisting on variables
	 */
	function blacklistVar(&$var,$convertslashes = false) {
		// load safehtml
		if(!defined('XML_HTMLSAX3')) define('XML_HTMLSAX3', dirname(__FILE__)."/safehtml/classes/");
		require_once('safehtml/classes/safehtml.php');

		// init safehtml
		$safehtml =& new safehtml();

		if(is_array($var)) {
			reset($var);
			while(list($key,$val)=each($var)) {
				if(is_array($val)) {
					$this->blacklistVar($var[$key],$convertslashes);
				} else {
					if($convertslashes) $var[$key] = addslashes($safehtml->parse(stripslashes($val)));
					else $var[$key] = $safehtml->parse($val);
					$safehtml->clear();
				}
			}
			reset($var);
		} else {
			if($convertslashes) $var = addslashes($safehtml->parse(stripslashes($var)));
			else $var = $safehtml->parse($var);
			$safehtml->clear();
		}
	}

	/**
	 * Do check on Fileuploads
	 */
	function doFileUploadFilter() {
		if(isset($_FILES) && is_array($_FILES)) {
			foreach($_FILES as $key => $value) {
				if(is_array($_FILES[$key]['name'])) {
					foreach($_FILES[$key]['name'] as $keymulti => $valuemulti) {
						$_FILES[$key]['name'][$keymulti] = $this->doFileUploadWhiteList($_FILES[$key]['name'][$keymulti]);
						if(isset($_FILES[$key]['type'][$keymulti])) $_FILES[$key]['type'][$keymulti] = $this->doFileUploadWhiteList($_FILES[$key]['type'][$keymulti]);
					}
				} else {
					$_FILES[$key]['name'] = $this->doFileUploadWhiteList($_FILES[$key]['name']);
					if(isset($_FILES[$key]['type'])) $_FILES[$key]['type'] = $this->doFileUploadWhiteList($_FILES[$key]['type']);
				}
			}
		}
	}

	/**
	 * Do a whitelist check on a filename or type
	 */
	function doFileUploadWhiteList($name) {
		$name = preg_replace('/[^a-zA-Z0-9 .\-_\/]/m', '', $name);
		return $name;
	}
}

?>
