/*
 *  Copyright (C) 2006 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
  @mainpage Krita Image manipulation and paint application

  Krita is an advanced and modular paint and image manipulation
  application.

  Krita is built around two core libraries: pigment and kritaimage.

  The pigment library abstracts colorspaces and color
  transformations. ColorSpaces provide functions to manipulate pixels. The
  kritcolor library loads colorspace plugins to extend the range of
  available colorspaces. Pigment is part of the KOffice libraries.

  The kritaimage library abstracts the storage, creation, inspection
  and manipulation of pixels stored in a rectangular area. It provides
  layers, filters, iterators and painters. Filters and paint operations
  are provided as service plugins loaded through the appropriate trader
  queries.

  Both libraries are used by the user interface, which is a KOffice
  part. the user interface loads tools and other plugins.

  There are the following types of plugins

<ul>
  <li> filters
  <li> tools
  <li> paintops
  <li> colorspaces
  <li> file filters
  <li> view plugins
</u>
 
  Of these, file filters exist outside the Krita tree and colorspaces
  depend only on pigment, which is also outside krita itself. Please
  consult the plugin writers' manual for more information.

 */
#ifndef DESIGN
#define DESIGN
// Let's keep icefox.net/kde/tests.headerincluded_koffice.html happy
#endif
