/***************************************************************************
                          myktreelistitem.h  -  description                              
                             -------------------                                         
    begin                : Wed Jun 30 1999                                           
    copyright            : (C) 1999 by Frank Schwanz                         
    email                : schwanz@fh-brandenburg.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef MYKTREELISTITEM_H
#define MYKTREELISTITEM_H

#include <qlistview.h>
#include <qstringlist.h>
#include <qstring.h>
#include <qobject.h>
#include <qpixmap.h>

#include "mount.h"
/**NettreeItems cass with my data structure

  *@author Frank Schwanz
  */
class MyMaster;
class Komba2Doc;
class MyHostItem;
class MyShareItem;
class MyWorkgroupItem;
class MyNetworkItem;
/***************************************************************************
 *                                                                         *
 *   Class for Shareitem in Nettree-class														   		 *
 *                                                                         *
 ***************************************************************************/
class MyShareItem:public QListViewItem
{
public:
  enum ShareTypes
  { unknown, Disk, IPC, Printer };

private:
    QString comment;
  QString username;
  QString password;
  ShareTypes share_type;
/*      typ : 1 = Disk
             2 = IPC
             3 = Printer
             0 = unknown*/
  QString mount_path;
  bool isautomount;
  bool ask_for_password;
public:
    MyShareItem (QListViewItem * parent, const QString & name);
    virtual ~ MyShareItem ();

  const QString Name ()
  {
    return text (0);
  };

  bool askForPassword ()
  {
    return ask_for_password;
  };
  void setAskForPassword (const bool b)
  {
    ask_for_password = b;
  };

  const QString getHostName ();
  const QString getWorkgroupName ();
  QString & getComment ()
  {
    return comment;
  };
  void setComment (const QString & sharecomment);

  QString & getUsername ();
  void setUsername (const QString & user)
  {
    username = user;
  };

  QString & getPassword ();
  void setPassword (const QString & pw)
  {
    password = pw;
  };

  ShareTypes getSharetype ()
  {
    return share_type;
  };
  void setSharetype (ShareTypes sharetype);

  QString & getMountPath ()
  {
    return mount_path;
  };
  void setMountPath (const QString & mountpath);

  void setAccount (QString name, QString pw);
/***************************************************************************
 *   mount this share on the specified path													   		 *
 ***************************************************************************/
  void mount (QString dir = QString::null);
/***************************************************************************
 *   unmount this share if it is mounted														   		 *
 ***************************************************************************/
  void unmount ();
  Komba2Doc *getDocument ();

  bool isAutomount ()
  {
    return isautomount;
  };
  void setAutomount (bool s)
  {
    isautomount = s;
  };

};

/***************************************************************************
 *                                                                         *
 *   Class for Globalitem in Nettree-class													   		 *
 *                                                                         *
 ***************************************************************************/
class MyNetworkItem:public QListViewItem
{
public:
  MyNetworkItem (Komba2Doc * thedoc, QListView * parent,
		 const QString & name);
   ~MyNetworkItem ()
  {
  };
//    virtual QListViewItem* parent() { return QListViewItem::parent(); };
  const QString Name ()
  {
    return text (0);
  };

	/***************************************************************************
	 *  return the WorkgroupItem, if not exists return 0									  	 *
	 ***************************************************************************/
  MyWorkgroupItem *getWorkgroup (const QString & workgroupname);

	/***************************************************************************
	 *  return the HostItem, if not exists return 0												  	 *
	 ***************************************************************************/
  MyHostItem *getHost (const QString & workgroupname,
		       const QString & hostname);
	/***************************************************************************
	 *  return the ShareItem, if not exists return 0											  	 *
	 ***************************************************************************/
  MyShareItem *getShare (const QString & workgroupname,
			 const QString & hostname, const QString & sharename);
  MyShareItem *getShare (const QString & hostname, const QString & sharename);
  Komba2Doc *getDocument ()
  {
    return doc;
  };
  void removeChilds ();
  public slots:
	/***************************************************************************
	 *  add a new Share (if not allready exists) to Host								   		 *
	 *  or update comment (if given)                                    			 *
	 ***************************************************************************/
   
    MyShareItem * insertShare (const QString & workgroup,
			       const QString & hostname,
			       const QString & sharename,
			       MyShareItem::ShareTypes stype,
			       QString theComment = QString::null);
	/***************************************************************************
	 *  add a new Host and Workgroup (if not allready exists) to Network   		 *
	 *  or update (host) ip and comment (if given)                             *
	 ***************************************************************************/
  MyHostItem *insertHost (const QString & workgroupname,
			  const QString & hostname, ulong theIP =
			  0, const QString theComment =
			  QString::null, const QString & os =
			  QString::null, const QString & server =
			  QString::null);
//              void insertHost(const QString& workgroupname, const QString& hostname,  ulong theIP);   
	/***************************************************************************
	 *  add a new Workgroup (if not allready exists) to Network					   		 *
	 ***************************************************************************/
  MyWorkgroupItem *insertWorkgroup (const QString & workgroupname);
	/***************************************************************************
	 *  removes the WorkgroupItem from Network and delete the workgorupitem  	 *
	 ***************************************************************************/
  void deleteWorkgroup (MyWorkgroupItem * oldworkgroup);
private:
  QPixmap networkpix;
  Komba2Doc *doc;
};






/***************************************************************************
 *                                                                         *
 *   Class for Workgroupitem in Nettree-class														   		 *
 *                                                                         *
 ***************************************************************************/
class MyWorkgroupItem:public QListViewItem
{
private:
  MyHostItem * master;
  QString username;
  QString password;
  bool ask_for_password;
public:
    MyWorkgroupItem (QListViewItem * parent, const QString & name);
    virtual ~ MyWorkgroupItem ();

  const QString Name ()
  {
    return text (0);
  };

  MyHostItem *getMaster ()
  {
    return master;
  };
  void setMaster (MyHostItem * m);

  QString & getUsername ()
  {
    return username;
  };
  void setUsername (const QString & user)
  {
    username = user;
  };

  QString & getPassword ()
  {
    return password;
  };
  void setPassword (const QString & pw)
  {
    password = pw;
  };

  bool askForPassword ()
  {
    return ask_for_password;
  };
  void setAskForPassword (const bool b)
  {
    ask_for_password = b;
  };


	/***************************************************************************
	 *  add a new Share (if not allready exists) to Host								   		 *
	 *  or update comment (if given)                                    			 *
	 ***************************************************************************/
  MyShareItem *insertShare (const QString & hostname,
			    const QString & sharename,
			    MyShareItem::ShareTypes stype,
			    const QString & theComment = QString::null);
	/***************************************************************************
	 *  add a new Host (if not allready exists) to Workgroup						   		 *
	 ***************************************************************************/
  MyHostItem *insertHost (const QString & hostname, ulong theIP =
			  0, const QString & theComment =
			  QString::null, const QString & os =
			  QString::null, const QString & server =
			  QString::null);
	/***************************************************************************
	 *  removes the HostItem from Workgroup and delete the hostitemobject	   		 *
	 ***************************************************************************/
  void deleteHost (MyHostItem * oldhost);

	/***************************************************************************
	 *  return the HostItem, if not exists return 0												  	 *
	 ***************************************************************************/
  MyHostItem *getHost (const QString & hostname);

	/***************************************************************************
	 *  return the ShareItem, if not exists return 0											  	 *
	 ***************************************************************************/
  MyShareItem *getShare (const QString & hostname, const QString & sharename);

	/***************************************************************************
	 *  is override to look first at the master														  	 *
	 ***************************************************************************/
  void setOpen (bool o);
  /**  */
  void setAccount (QString name, QString pw);
  Komba2Doc *getDocument ()
  {
    return ((MyNetworkItem *) parent ())->getDocument ();
  };
  void removeChilds ();
};

/*===============================================================================*/

/***************************************************************************
 *                                                                         *
 *   Class for Hostitem in Nettree-class														   		 *
 *                                                                         *
 ***************************************************************************/
class MyHostItem:public QListViewItem
{
private:
  struct netbiosnames
  {
    QString name;
    QString service;
    QString type;
    QString group;
  };
    QList < netbiosnames > *netnames;
  QString hostname;
  ulong ip;
  QString comment;
  QString username;
  QString password;
  QString os;
  QString server;
  bool hostsearched;
  bool isdown;
  bool ask_for_password;
public:
    MyHostItem (QListViewItem * parent, const QString & name,
		const ulong theip = 0L, const QString & theComment =
		QString::null, const QString & theOs =
		QString::null, const QString & theServer = QString::null);
    virtual ~ MyHostItem ();

  const QString Name ()
  {
    return hostname;
  };
  void setName (const QString & name)
  {
    hostname = name;
    setText (0, name);
  };
  const QString getWorkgroupName ();

  QString & getComment ()
  {
    return comment;
  };
  void setComment (const QString & the_comment);

  bool askForPassword ()
  {
    return ask_for_password;
  };
  void setAskForPassword (const bool b)
  {
    ask_for_password = b;
  };

  QString & getUsername ();
  void setUsername (const QString & user)
  {
    username = user;
  };
  bool searchNetNames (QRegExp & tofind);
  QString & getPassword ();
  void setPassword (const QString & pw)
  {
    password = pw;
  };
  void setAccount (QString name, QString pw);
  const QString & getServer ()
  {
    return server;
  };
  void setServer (const QString & theServer)
  {
    server = theServer;
  };
  const QString & getOS ()
  {
    return os;
  };
  void setOS (const QString & theOs)
  {
    os = theOs;
  };
  ulong getNetIP ()
  {
    return ip;
  };
  void setNetIP (ulong hostip);
  void removeChilds ();
  void setDown (bool s);
  bool isDown ()
  {
    return isdown;
  };
/***************************************************************************
 *  call smbclient -L ... and insert all new hosts, workgroups and shares	 *
 ***************************************************************************/
  void searchHost ()
  {
  };

  bool issearched ()
  {
    return hostsearched;
  };
  void issearched (bool issearched)
  {
    hostsearched = issearched;
  };
/***************************************************************************
 *  use nmblookup to search for the hostip  												   		 *
 ***************************************************************************/
//      void lookforIP();

  void clearNetNames ()
  {
    netnames->clear ();
  };
  void appendNetName (const QString & name, const QString & service,
		      const QString & type, const QString & group);
  int getNetNameCount ()
  {
    return netnames->count ();
  };
  QListViewItem *getNetName (QListView * list, netbiosnames * n);
  QListViewItem *firstNetName (QListView * list)
  {
    return getNetName (list, netnames->first ());
  };
  QListViewItem *nextNetName (QListView * list);
  QStringList *getNetNames (QStringList * list, bool onlyMessageNames =
			    false);

/***************************************************************************
 *  add a new Share to the Host																			   		 *
 ***************************************************************************/
  void insertShare (MyShareItem * newshare)
  {
    insertItem ((QListViewItem *) newshare);
  };

/***************************************************************************
 *  add a new Share (if not allready exists) to Host								   		 *
 ***************************************************************************/
  MyShareItem *insertShare (const QString & sharename,
			    MyShareItem::ShareTypes stype,
			    const QString & theComment = "");
/***************************************************************************
 *  removes the Shareitem from Host and delete the shareitemobject	   		 *
 ***************************************************************************/
  void deleteShare (MyShareItem * oldshare);

/***************************************************************************
 *  return the ShareItem, if not exists return 0											  	 *
 ***************************************************************************/
  MyShareItem *getShare (const QString & sharename);


/***************************************************************************
 *  Return the IP as ASCII String (192.168.0.0)											   		 *
 ***************************************************************************/
  void getIP (QString * ip);

/***************************************************************************
 *  is override to look first for shares  														  	 *
 ***************************************************************************/
  void setOpen (bool o);

  Komba2Doc *getDocument ()
  {
    return ((MyWorkgroupItem *) parent ())->getDocument ();
  };
};




/***************************************************************************
 *                                                                         *
 *   Class for copy Workgroup-, Host- and Shareitem 								   		 *
 *                                                                         *
 ***************************************************************************/
class MyCopyItem:public QListViewItem
{
public:
  MyCopyItem (QListView * parent, MyShareItem * item);
  MyCopyItem (QListView * parent, MyHostItem * item);
  MyCopyItem (QListView * parent, MyWorkgroupItem * item);
  ~MyCopyItem ()
  {
  };
  /** returns the orignal Item of the copyitem */
  QListViewItem *getCopyItem ();

  QListViewItem *origitem;
};
#endif
