/***************************************************************************
 *   Copyright (C) 2005-2007 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kmainwindow.h>
#include <klocale.h>

#include "komparator.h"
#include "komparatorwidget.h"

Komparator::Komparator( const KURL &url1, const KURL &url2 )
		: KMainWindow( 0, "Komparator", WType_TopLevel | WDestructiveClose | WStyle_ContextHelp )
{
	really_close = false;
	m_komparator_widget = new KomparatorWidget( url1, url2, this );
	setCentralWidget( m_komparator_widget );
}

Komparator::~Komparator()
{
}

void Komparator::slotQuit()
{
	really_close = true;
	close( true );
}

bool Komparator::queryClose()
{
	if ( really_close ) return true;

	if ( m_komparator_widget->isSystrayVisible() )
	{
		hide();
		return false;
	}

	return true;
}

#include "komparator.moc"
