/***************************************************************************
                          item.h  -  description
                             -------------------
    begin                : Fri May 23 2003
    copyright            : (C) 2003 by KoolDock team
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef ITEM_H
#define ITEM_H

#include <kiconloader.h>
#include <kwin.h>

#include <qstring.h>
#include <qpixmap.h>
#include <qptrlist.h>

const int MAX_LEN = 256;
const int SIZE_INC = 1;

class Item
{
   public:
      Item(QString iconName, QString cmd, QString name, int minSize, int maxSize);
      Item(QString fileName, int minSize, int maxSize);
      Item(QPixmap iconBig, WId id, QString name, int minSize, int maxSize);
      ~Item();

      void setIcon(QPixmap iconBig);

      QPixmap* getIcon(int size);
      QString getCommand();
      QString getName();
      WId getId();
      QString getFilename();

      void setName(QString newName);
      bool animed;
      bool isAnimed();
      void anim(bool param);
    
   private:
      KIconLoader *iLoader;

      int minSize;
      int maxSize;
      QPtrList<QPixmap> icons;
      QString command;
      QString name;
      QString iconName;
      QString filename;
      WId id;
};

#endif
