/***************************************************************************
                          kooldock.cpp  -  description
                             -------------------
    begin                : Tue Jun 10 22:18:34 BST 2003
    copyright            : (C) 2003 by KoolDock team
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <math.h>

#include <qpixmap.h>
#include <qimage.h>
#include <qpainter.h>
#include <qcursor.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <qtooltip.h>
#include <qrect.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qbrush.h>
#include <qpoint.h>
#include <qfont.h>
#include <qdatetime.h>

#include <kwin.h>
#include <kprocess.h>
#include <netwm_def.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <krun.h>
#include <kurifilter.h>
#include <kpixmapio.h>
#include <kstandarddirs.h>
#include <kaboutapplication.h>
#include <qlistbox.h>
#include <keditlistbox.h>

// for "renicing" the bar
#include <sys/time.h>
#include <sys/resource.h>

#include "kooldock.h"

#include <kconfig.h> 
#include <kdebug.h>
#include "setupdialogprg.h"

// macros

#define min(a, b) (a < b) ? (a) : (b)
#define max(a, b) (a > b) ? (a) : (b)

// compiler issues
#if __GNUC__ == 2 && __GNUC_MINOR__ <= 95
#  define _GCC295
#endif

KoolDock::KoolDock(QWidget *parent, const char *name) : QWidget(parent, name, WStyle_Customize |  WStyle_NoBorder | WDestructiveClose | WResizeNoErase | WMouseNoMask | WStyle_StaysOnTop | WX11BypassWM)
{
   // Default configuration paths
   progPath = locateLocal("data", "kooldock");
   menuPath = progPath + QString("/menu/");
   confFile = locateLocal("config", "kooldockrc");

   // Load the configuration
   loadConf();

   // Lets initialize the systray counter
   numSystray=0;

   
   // first, we set our "nice" priority
   if (fPriority > 19) fPriority = DEF_PRIORITY;
   if (fPriority < 0) fPriority = DEF_PRIORITY;
   setpriority(0, 0, fPriority);
   debug(QString("Priority: %1").arg(fPriority));

   iwBig2 = iwBig;

   iDist = iwSmall + iSpace;
   funcW = (int)(2.5*iDist);
   funcH = iwBig - iwSmall;
   iy = (iDist - iwSmall) / 2;

   info = new NETWinInfo( qt_xdisplay(), winId(), qt_xrootwin(), NET::WMState);
   info->setDesktop( NETWinInfo::OnAllDesktops );
   info->setState(NETWinInfo::SkipTaskbar | NETWinInfo::SkipPager, NETWinInfo::SkipTaskbar | NETWinInfo::SkipPager);
   setBackgroundMode(NoBackground);

   items.setAutoDelete(TRUE);

   if(fShowKMenu==1)
   {
      items.append(new Item("kmenu", "dcop kicker kicker popupKMenu 0", "KMenu", iwSmall, iwBig));
   }
   
   //Lets load the menu entries
   loadMenu();

   wm = new KWinModule();
   
   setupdlg = new SetupDialogPrg();	// create the setup dialog object.

   // Load the ignore List
   loadIgnore();
   
   // Create the "xosd" widget
   xosdw = new xosd();
   xosd_st = 0;
   xosdw->setFont(xosdFont);
   if (xosdItalic == true) xosdw->setItalic();
   if (xosdBold == true) xosdw->setBold();
   xosdw->setSize(xosdSize);
   xosdw->setShadowOffset(xosdShadowOffset);
   xosdw->setColor(xosdColor);
  xosdw->setShadowColor(xosdShadowColor);
   // Show task bar
   if (fShowTaskbar)
   {
      firstTime=true;
      //Lets add the necesary windows
      addWindows();
      connect(wm, SIGNAL(windowAdded(WId)), SLOT(windowAdded(WId)));
      connect(wm, SIGNAL(windowRemoved(WId)), SLOT(windowRemoved(WId)));
      connect(wm, SIGNAL(windowChanged(WId, unsigned int)), SLOT(windowChanged(WId, unsigned int)));
      connect(wm, SIGNAL(activeWindowChanged(WId)), SLOT(activeWindowChanged(WId)));

      /* System Tray implementation (hope this works - Francisco) */
      connect(wm, SIGNAL(systemTrayWindowAdded(WId)), SLOT(systemTrayWindowAdded(WId)));
      connect(wm, SIGNAL(systemTrayWindowRemoved(WId)), SLOT(systemTrayWindowRemoved(WId)));
   }
   connect(wm, SIGNAL(currentDesktopChanged(int)), SLOT(currentDesktopChanged(int)));

   // Pseudo-Transparency code
   rootpix = new KRootPixmap(this);
   rootpix->setCustomPainting(TRUE);
   connect(rootpix, SIGNAL(backgroundUpdated (const QPixmap &)), SLOT(updateBackground(const QPixmap &)));
   rootpix->start();

   debug(QString("Items loaded: %1").arg(items.count()));


   //Simple work around to support xinerama (user defined)
   if(xinerama==0)
   {
      dw=QApplication::desktop()->width();
   }
   else
   {
      dw=leftRes;
      //dw=(QApplication::desktop()->width()/2);
   }
	
   // All icons to small size
   unsigned int i;
   for (i=0; i < items.count() + 1; i++)
   {
      iSize[i] = iwSmall;
   }
   for (i=0; i < items.count() + 1; i++)
   {
      cx[i] = ix + i*iDist + iwSmall/2;
      cur_cx[i] = cx[i];
   }
	
   // Dock width
   w0 = 2*ix + (items.count() - 1)*iDist + iwSmall;
   if (fShowTaskbar) w0 += SPACE_W;
   w = w0;
	
   // Dock X
   x0 = (dw - w0) / 2;
   x = x0;
	
   // Dock height
   h0 = 2*iy + iwSmall;
   h = h0;
	
   h1 = 2*iy + iwBig;
   sx = 0;
   sw = w;
   dh = QApplication::desktop()->height();

   setMouseTracking(TRUE);

   if(fHidden==1)
   {
      getbottomBg();
      // Timer to track the mouse position
      // When the mouse pointer reaches the bottom of the screen, the bar should popup in a userdefined time (int hideTimer)
      trackTimer = new QTimer(this);
      connect(trackTimer, SIGNAL(timeout()), this, SLOT(trackTimerEnd()));
      trackTimer->start(hideTimer, FALSE);
   }
   else
   {
      resize(w, h);
      move( x, dh - h );
   }

   offscr = QPixmap(dw, h1);

   ii_first = 0;
   ii_last = items.count() - 1;
   last_ii_first = 0;
   last_ii_last = items.count() - 1;
   ii_updating_first = 0;
   ii_updating_last = ii_last;

   w1 = w0 + (iwBig - iwSmall)*3 + ix + iSpace;
   x1 = (dw - w1) / 2;

   fJustEntered=FALSE;
   fDrawAsJustEntered = FALSE;
   iOnClick = -1;
   onChangeTimer = NULL;
   Ybase = 0;

   /* For the the onscreen text (icon names) */
   nom = "";
   aux = "";

   showTimer = new QTimer(this);
   connect(showTimer, SIGNAL(timeout()), this, SLOT(showTimerTicked()));

   // this timer is to check if the dock should be restarted or not
   // calling chkRestart() to check.
   resTimer = new QTimer(this);
   connect(resTimer, SIGNAL(timeout()), this, SLOT(chkRestart()));
   resTimer->start(15, FALSE);
  
   _filterData = new KURIFilterData();

   enterTimer = new QTimer(this);
   connect( enterTimer, SIGNAL(timeout()), this, SLOT(enterTimerTicked()) );

   mkbigTimer = new QTimer(this);
   connect(mkbigTimer, SIGNAL(timeout()), this, SLOT(mkbigTimerDo()));

   mksmallTimer = new QTimer(this);
   connect(mksmallTimer, SIGNAL(timeout()), this, SLOT(mksmallTimerDo()));
  
   if (!fLeftImg.isEmpty()) LeftImg.load(fLeftImg);
   if (!fRightImg.isEmpty()) RightImg.load(fRightImg);
   if (!fCenterImg.isEmpty()) CenterImg.load(fCenterImg);
  
   // repaint timer
   doRepaint = TRUE;
   repaintTimer = new QTimer(this);
   connect(repaintTimer, SIGNAL(timeout()), this, SLOT(repaintSlot()));
   repaintTimer->start(fRepaintInterval, FALSE);
  
   QString welcomeMsg;
   if (fFirstRun == TRUE)
   {
   // Show welcome dialog.
      welcomeMsg =  QString("<center><B>Welcome</B></center>It appears to be the first time you run KoolDock.<br>"
      "By default the dock is hidden at the botton of the screen, move your mouse"
      " to the bottom edge of the screen and the dock will appear.<br>"
      "Right click on the dock for a menu that allows you to configure it.<br>"
      "We hope this software is usefull for you<br>-- The KoolDock Team");
      KMessageBox::information(0L, i18n(welcomeMsg));
      saveConf();	// create initial configuration.
   }
  
   if (fHidden == 1)
   {
      /* Fucking bug! This will force the widget to hide 0.5 seconds after its displayed for the first time. */
      QTimer::singleShot( 10*30, this, SLOT(forceHide()) );
   }
  
   animValue = 0;
   animState = TRUE;
}


KoolDock::~KoolDock()
{
   if (info) delete(info);
   if (wm) delete(wm);
   if (setupdlg) delete(setupdlg);
   if (rootpix) delete(rootpix);
   if (trackTimer) delete(trackTimer);
   if (showTimer) delete(showTimer);
   if (resTimer) delete(resTimer);
   if (waitTimer) delete(waitTimer);
   if (enterTimer) delete(enterTimer);
   if (mkbigTimer) delete(mkbigTimer);
   if (mksmallTimer) delete(mksmallTimer);
   if (onChangeTimer) delete(onChangeTimer);
   if (_filterData) delete(_filterData);
}

void KoolDock::repaintSlot()
{
	//kdDebug() << "repaintslot" << endl;
	if (doRepaint == TRUE)
	{
		update();
		doRepaint = FALSE;
	}
}


void KoolDock::trackTimerEnd()
{
   QPoint pointer;
   QPixmap bottomBg2;
   pointer = QCursor::pos();
   int pointerpos = pointer.y() + 1;
   if (pointerpos == QApplication::desktop()->height() && pointer.x() > x && pointer.x() < (x + w))
   {
      raise();
      trackTimer->stop();
      bottomBg2 = QPixmap::grabWindow(qt_xrootwin(), x1, dh - h1, w1, h1);
      debug(QString("tracktimer: grabWindow(%1, %2, %3, %4)").arg(x1).arg(dh - h1).arg(w1).arg(h1));
      getbottomBg();
      move( x, dh - h );
      resize(w, h);
      Ybase = iwBig2;
      debug(QString("Ybase: %1").arg(Ybase));
      showTimer->start(1, FALSE);
      bottomBg = bottomBg2;
   }
}

void KoolDock::showTimerTicked()
{
   Ybase = Ybase - (iwBig2/fShowFrames);

   if (Ybase <= 0)
   {
      Ybase = 0;
      showTimer->stop();
   }
   doRepaint = TRUE;
}

void KoolDock::paintEvent(QPaintEvent *)
{
   // Draw backgound, icons, and all that stuff over the widget.
   QPainter p(&offscr);
   int i;

   // draw background
   if (w == w0)
   { // minimised mode
      bitBlt(&offscr, 0, 0, &bottomBg);	 // put the background into offscr
   }
   else
   {	// maximized mode
      bitBlt(&offscr, 0, 0, &topBg, 0, 0, w, h1 - h0);			// put the top backgroun
      bitBlt(&offscr, 0, h1 - h0, &bottomBg, 0, h1 - h0, w, h0);	//put the rest of the background
   }
   // end drawing background

   // draw background (new engine)
   int bgY;
   QImage TempBG;
   QPixmap TempScaledLeft;
   //QPixmap TempScaledCenter;
   QPixmap TempScaledRight;
  
   if (w == w0)
   {
      bgY = 0;
   }
   else
   {
      bgY = h1 - h0 + Ybase;
   }
	
   int firstX;
   if (ii_updating_first == 0)
   {
      firstX = cur_cx[0] - iSize[0]/2 - iSpace/2 + adjust;
   }
   else
   {
      firstX = cur_cx[0] - iSize[0]/2 - iSpace/2 + SPACE_W;
   }
  
   int lastX = cur_cx[items.count()-1] - iSize[items.count()-1]/2 - iSpace/2 + adjust;
   lastX = lastX + iSize[items.count()-1] - iSpace/2;

   KPixmapIO pixio;
  
   // Left side image
   if (!fLeftImg.isEmpty())
   {
      TempBG = pixio.convertToImage(LeftImg);
      TempScaledLeft = QPixmap(TempBG.smoothScale(LeftImg.width(), h0));
      bitBlt(&offscr, firstX, bgY, &TempScaledLeft);
   }

   //Center image
   if (!fCenterImg.isEmpty())
   {
      TempBG = pixio.convertToImage(CenterImg);
      if (ii_updating_first > 0 && TempScaledCenter.width() != (lastX - RightImg.width()) )
      // hack!! to optimize drawing speed, now it scales the background image only when it's
      // necessary, I'd prefeer to use a bit more of memory instead of loosing speed.
      // -- Matias
      {
         TempScaledCenter = QPixmap(TempBG.smoothScale( lastX - RightImg.width(), h0));
      }
      else if (ii_updating_first <= 0 && TempScaledCenter.width() != (lastX - RightImg.width() - adjust + 1) )
      {
         TempScaledCenter = QPixmap(TempBG.smoothScale( lastX - RightImg.width() - adjust + 1, h0));
      }
      bitBlt(&offscr, firstX + LeftImg.width(), bgY, &TempScaledCenter);
   }

   // Right side image
   if (!fRightImg.isEmpty())
   {
      TempBG = pixio.convertToImage(RightImg);
      TempScaledRight = QPixmap(TempBG.smoothScale(RightImg.width(), h0));
      bitBlt(&offscr, firstX + TempScaledLeft.width() + TempScaledCenter.width(), bgY, &TempScaledRight);
   }
   // End drawing the backgound

    
   // draw borders
   if (fShowBorders)
   {
      if (h == h0)
      {
         p.fillRect (QRect(0, 0, SPACE_W, h), QBrush(borderColor));
         p.fillRect (QRect(0, 0, w, SPACE_W), QBrush(borderColor));
         p.fillRect (QRect(w - SPACE_W, 0, SPACE_W, h), QBrush(borderColor));
      } else { // h == h1
         p.fillRect (QRect(0, h1 - h0, SPACE_W, h0), QBrush(borderColor));
         p.fillRect (QRect(0, h1 - h0, w, SPACE_W), QBrush(borderColor));
         p.fillRect (QRect(w - SPACE_W, h1 - h0, SPACE_W, h0), QBrush(borderColor));
      }
   }
   // end drawing borders

   Item *item;

   // new icon drawing engine
   int Ypos;	// Y position
   int Xpos;	// X position
   KPixmap *currentIcon;		// current icon pixmap
   for (i = 0; i < (int)items.count(); i++)
   {
      item = items.at(i);
      // start setting the icon position
      if(i < ii_updating_first)
      {
         // left side icons
         Xpos = cur_cx[i] - iwSmall/2 + SPACE_W;
         Ypos = h - iy - iwSmall+Ybase;
      }
      else if(i >= ii_updating_first && i <= ii_updating_last)
      {
         // zoomed icons (center)
         Xpos = cur_cx[i] - iSize[i]/2 + adjust;
         Ypos = h - iy - iSize[i]+Ybase;
      }
      else if(i > ii_updating_last)
      {
         // right side icons
         Xpos = cur_cx[i] - iwSmall/2 + adjust + SPACE_W - 3;
         Ypos = h - iy - iwSmall+Ybase;
      } // end getting icon positions
	
      // now, get the icon image
      currentIcon = new KPixmap(*item->getIcon(iSize[i]));
	
      // misc icon effects and animations
      if (iOnClick == i)
      {
         // highlight the clicked icon
         KPixmapEffect::fade(*currentIcon, ((float)50)*0.01, QColor("#FFFFFF"));
         QTimer::singleShot( 10*60*1, this, SLOT( unhighlight() ) );	// unhighlight the icon in 1 second
      }
	
      // notify animation
      if (fShowNotification && item->isAnimed())
      {
         KPixmapEffect::fade(*currentIcon, ((float) animValue )*0.01, QColor("#FFFFFF"));
      }

      //Lets apply an effect to the active window in TaskBar
      if(item->getId()==wm->activeWindow())
      {
         //KPixmapEffect::fade(*currentIcon, ((float)50)*0.01, QColor("#FFFFFF"));
         //KPixmapEffect::toGray(*currentIcon, true);
         KPixmapEffect::fade(*currentIcon, ((float)60)*0.01, QColor("#FFFFFF"));
      }
	
      // End drawing icon effects
	
      // Draw the icon on the widget in its respective position
      bitBlt(&offscr, Xpos, Ypos, currentIcon);
	
      // Destroy the unused currentIcon pixmap.
      delete currentIcon;
   } // Rnd drawing icons
  
   // Draw the seperator between launcher and taskbar
   if((numLaunchers>0) || (fShowKMenu==1))
   {
      if (fShowTaskbar && w == w0)
      {
      QRect sepRect(cur_cx[numLaunchers] - iSize[numLaunchers]/2 - iSpace/2 + adjust, 0, SPACE_W, h);
      p.fillRect (sepRect, QBrush(sepColor));
      }
      else if (fShowTaskbar && ( (signed)items.count() > numLaunchers))
      {
         QRect sepRect(cur_cx[numLaunchers] - iSize[numLaunchers]/2 - iSpace/2 + adjust, h1 - h0 + Ybase, SPACE_W, h);
         p.fillRect (sepRect, QBrush(sepColor));
      }
   }
   if((fSystray==1) && (numSystray>0))
   {
      if(w==w0)
      {
         QRect sepRect(cur_cx[items.count()-numSystray] - iSize[items.count()-numSystray]/2 - iSpace/2 + adjust, 0, SPACE_W, h);
         p.fillRect (sepRect, QBrush(sepColor));
      }
      else
      {
         QRect sepRect(cur_cx[items.count()-numSystray] - iSize[items.count()-numSystray]/2 - iSpace/2 + adjust, h1 - h0 + Ybase, SPACE_W, h);
         p.fillRect (sepRect, QBrush(sepColor));
      }
   }
   // Finally update the widget
   bitBlt(this, 0, 0, &offscr, 0, 0, w, h, Qt::CopyROP);
}


void KoolDock::unhighlight()
{
   iOnClick = -1;
   doRepaint = TRUE;;
}


void KoolDock::mousePressEvent( QMouseEvent *e)
{
   int i;

   int mx = e->x();
   int my = e->y();
   ButtonState srcButton = e->button();


   if (srcButton == Qt::LeftButton)
   {
      mx = mx + x1 - x0 - ix;
      i = mx/iDist;

      if ((my >= h1 - iy - iSize[i]) && (my <= h1 - iy))
      {
         if ((i >= 0) && (i < (int)items.count()))
         {
            items.at(i)->anim(FALSE);
            WId id = items.at(i)->getId();
            if (id == 0)
            {
               // if user clicked on a quick launcher, launch the app
               // acknowledge on click
               iOnClick = i;
               doRepaint = TRUE;

               // run the app
               debug(QString("clicked: %1").arg(items.at(i)->getName()));
               if (items.at(i)->getName() == "KMenu")
               {
                  // show K Menu
                  run(items.at(i)->getCommand());
               }
               else
               {
                  // run the application with KDE feedback (loading icon)
                  // we need to run the .desktop file, since the command
                  // may be a url or another KIO stuff like 'system:/'
                  run(items.at(i)->getFilename());
               }
            }
            else
            {
               if(i>=((int)items.count()-numSystray))
               {
                  //KWin::forceActiveWindow(id);
                  KWin::WindowInfo info;
                  info = KWin::windowInfo(id);
                  QString name = info.name();

                  KWin::deIconifyWindow(id);
                  kdDebug(0) << "Systray: " << id << " Name: " << name << " Estado: " << info.state() << endl;
                  //QMouseEvent me(e->type(), mapTo( topLevelWidget(), e->pos() ), e->globalPos(), e->button(), e->state() );

                  //QApplication::sendEvent(, &me);
               }
               else
               {
                  // if user clicked on a running task's icon, activate it
                  if (id!=CurrentFocus)
                  {
                     //KWin::activateWindow(id);
		     cId = id;
		     activateApp();
                  }
                  else
                  {
                     cId = id;
		     minApp();
		     //KWin::iconifyWindow(id, true);
                     CurrentFocus = winId();
                  }
               }
               if(fHidden == 1 && fHideOnClick == 1) leaveEvent(NULL);	// it's configurable
            }
         }
      }
   }
   else if(srcButton == Qt::RightButton)
   {
      // Right button.
      mx = mx + x1 - x0 - ix;
      i = mx/iDist;

      //Menu definitions
      KPopupMenu *deskpopup=new KPopupMenu();
      KPopupMenu *appMenu=new KPopupMenu();
      KPopupMenu *godesk=new KPopupMenu;
      KPopupMenu *tasklist=new KPopupMenu;
      KPopupMenu *popup=new KPopupMenu;
      
      // Main KoolDock popup menu
      popup->clear();
      popup->insertTitle(i18n("Main Menu"));
      popup->insertItem(SmallIcon("configure"), i18n("Edit Quick Launch &Menu"), this, SLOT(edit()));
      popup->insertItem(SmallIcon("pencil"), i18n("Edit &Preferences"), this, SLOT(editPref()));
      popup->insertItem(SmallIcon("redo"), i18n("&Reload configuration"), this, SLOT(restart()));
      popup->insertSeparator();
      popup->insertItem(SmallIcon("about_kde"), i18n("&About"), this, SLOT(about()));
      popup->insertSeparator();
      popup->insertItem(SmallIcon("exit"), i18n("E&xit"), this, SLOT(endProg()));
      // End Main KoolDock Menu

      if(fShowNav==1)
      {
         //Menu to be appended to MainMenu
         godesk->clear();
         connect(godesk, SIGNAL(activated(int)), this, SLOT(goToDesktop(int)));
         for(int index=0; index<KWin::numberOfDesktops(); index++)
         {
            QString tmp=i18n("Desktop &%1").arg(index+1);
            int menustate=godesk->insertItem(SmallIcon("forward"), tmp, index+1);
            if(KWin::currentDesktop()==(index+1)) godesk->setItemEnabled(menustate, false);
         }
         //End godesk Menu
         
         //tasklist; menu to access every window throught navigation menu
         QValueList<WId>::ConstIterator it;
         KWin::WindowInfo tmpinfo;
         tasklist->clear();
         connect(tasklist, SIGNAL(activated(int)), this, SLOT(goToWindow(int)));

         const int SUPPORTED_WINDOW_TYPES = NET::NormalMask | NET::DesktopMask | NET::DockMask | NET::ToolbarMask | NET::MenuMask | NET::DialogMask | NET::OverrideMask | NET::TopMenuMask | NET::UtilityMask | NET::SplashMask;

         int counter_tmp=0;
         for(int index=0; index<KWin::numberOfDesktops(); index++)
         {
            tasklist->insertTitle(i18n("Desktop %1").arg(index+1), counter_tmp);
            counter_tmp++;
            int tmp_pos=counter_tmp;
            for (it=wm->windows().begin(); it != wm->windows().end(); ++it)
            {
               tmpinfo=KWin::windowInfo(*it);
               if(tmpinfo.isOnDesktop(index+1)==true)
               {
                  if(tmpinfo.windowType(SUPPORTED_WINDOW_TYPES) == NET::Normal || tmpinfo.windowType(SUPPORTED_WINDOW_TYPES) == NET::Override || tmpinfo.windowType(SUPPORTED_WINDOW_TYPES) == NET::Dialog || tmpinfo.windowType(SUPPORTED_WINDOW_TYPES) == NET::Unknown)
                  {
                     if ((tmpinfo.state() & NET::SkipTaskbar) == 0)
                     {
                        tasklist->insertItem(SmallIcon("forward"), i18n(tmpinfo.name()), *it, counter_tmp);
                        counter_tmp++;
                     }
                  }
               }
            }
            if(tmp_pos==counter_tmp) tasklist->removeItem(tmp_pos-1);
         }

         //Append Navigation Menu (godesk+Time)
         QDateTime timeEntry=QDateTime::currentDateTime();
         QString tmp=i18n("Navigation: Desktop %1").arg(KWin::currentDesktop());
         popup->insertTitle(tmp);
         popup->insertItem(SmallIcon("forward"), i18n("&Go to Desktop"), godesk);
         popup->insertItem(SmallIcon("forward"), i18n("&Task List"), tasklist);
         popup->insertSeparator();
         popup->insertItem(SmallIcon("clock"), timeEntry.toString());
         //End append Navigation Menu
      }

      if ((my >= h1 - iy - iSize[i]) && (my <= h1 - iy))
      {
         if ((i >= 0) && (i < (int)items.count()))
         {
            WId id = items.at(i)->getId();
            if (id == 0)
            {
               // if user right clicked on a quick launch icon.
               if (items.at(i)->getCommand() != "")
               {
                  // Edit the .desktop file
                  if (items.at(i)->getName() == "KMenu")
                  {
                     // if user right clicked on the K menu, show the configuration menu.
                     popup->exec(QCursor::pos());
                  }
                  else
                  {
                     appMenu->clear();
                     appMenu->insertTitle(i18n("Item menu"));
                     iFilename = items.at(i)->getFilename();
                     appMenu->insertItem(SmallIcon("configure"), i18n("&Edit item"), this, SLOT(editItem()));
                     appMenu->insertItem(SmallIcon("fileclose"), i18n("&Delete item"), this, SLOT(removeItem()));
                     appMenu->insertSeparator();
                     appMenu->insertItem(SmallIcon("forward"), "&KoolDock", popup);
                     appMenu->exec(QCursor::pos());
                  }
               }
            }
            else
            {
               // If user clicked on a running task icon, show the app menu.
               // Pop-up menu for right-clicking on a taskbar icon.
               cId = id;
               QString appTitle;
               KWin::WindowInfo winfo;
               winfo = KWin::windowInfo(cId);
               int menustate;

               //Begin Move to Desktop Menu
               deskpopup->clear();
               QString tmp=i18n("Current Desktop &%1").arg(KWin::currentDesktop());
               menustate=deskpopup->insertItem(SmallIcon("forward"), tmp, 0);
               if(winfo.isOnDesktop(KWin::currentDesktop())==true) deskpopup->setItemEnabled(menustate, false);
               deskpopup->insertSeparator();
               for(int i=0; i<KWin::numberOfDesktops(); i++)
               {
                  if(winfo.isOnDesktop(KWin::currentDesktop())==true && (i+1)==KWin::currentDesktop())
                  {
                     continue;
                  }
                  else
                  {
                     QString tmpd=i18n("Desktop &%1").arg(i+1);
                     if((i+1)!=KWin::currentDesktop())
                     {
                        
                        menustate=deskpopup->insertItem(SmallIcon("forward"), tmpd, i+1);
                        if(winfo.isOnDesktop(i+1)==true)
                        {
                           deskpopup->setItemEnabled(menustate, false);
                        }
                     }
                  }
               }
               connect(deskpopup, SIGNAL(activated(int)), this, SLOT(sendToDesktop(int)));
               //End Move to Desktop Menu

               appMenu->clear();
               appTitle = winfo.visibleName();
               appTitle.truncate(30);
               appMenu->insertTitle(appTitle);
               menustate = appMenu->insertItem(i18n("Mi&nimize"), this, SLOT(minApp()));
               // Don't show the "Minimize" menu if it's minimized.
               if (winfo.mappingState() == NET::Iconic) appMenu->setItemEnabled(menustate, false);
               menustate = appMenu->insertItem(i18n("Ma&ximize"), this, SLOT(maxApp()));
               // Don't show the "Maximize" menu if it's maximized
               if (winfo.state() == NET::Max) appMenu->setItemEnabled(menustate, false);
               // But show it if it's maximized AND minimized.
               if (winfo.mappingState() == NET::Iconic) appMenu->setItemEnabled(menustate, true);
               menustate = appMenu->insertItem(i18n("&Restore"), this, SLOT(restApp()));
               // Don't show the "Restore" menu if it is restored.
               if (winfo.mappingState() != NET::Iconic && winfo.state() != NET::Max) appMenu->setItemEnabled(menustate, false);

               appMenu->insertItem(SmallIcon("forward"), i18n("&Move to Desktop"), deskpopup);
               appMenu->insertSeparator();
               appMenu->insertItem(SmallIcon("fileclose"), i18n("&Close"), this, SLOT(closeApp()));
               appMenu->insertSeparator();
               appMenu->insertItem(SmallIcon("forward"), "KoolDock", popup);
               appMenu->exec(QCursor::pos());
            }
         }
      }
      else
      {
         // Show the configuration popup menu if the user clicked on another place.
         popup->exec(QCursor::pos());
      }
      if(deskpopup) delete(deskpopup);
      if(appMenu) delete(appMenu);
      if(godesk) delete(godesk);
      if(tasklist) delete(tasklist);
      if(popup) delete(popup);
   }
}


void KoolDock::mouseMoveEvent( QMouseEvent *e)
{
   unsigned int i;
   int mx, my;
   int dx;
   unsigned int k;
   int cur_cx_desk;
   QPoint pointer;
   pointer = QCursor::pos();
   
   if (fDrawAsJustEntered)
   {
      if (fJustEntered)
      {
         mx = e->x();
         last_mx = mx + x0 - x1;
      }
      else
      {
         mx = e->x() + x1 - x0;
         last_mx = e->x();
      }

      for(i=0; i < items.count() + 1; i++)
      {
         dx = abs(cx[i] - mx);
         if (dx < funcW)
         {
            iSize[i] = func(dx);
         }
         else
         {
            iSize[i] = iwSmall;
         }
      }

      cur_cx[0] = ix + iSize[0]/2;
      for(i=1; i < items.count() + 1; i++)
      {
         cur_cx[i] = cur_cx[i-1] + (iSize[i] + iSize[i-1])/2 + iSpace;
      }

      for(k=0; (k < items.count()) && (mx > cx[k]); k++);

      cur_cx_desk = x0 + cx[k] + (int)((cx[k] - mx)*(func(0) + func(iDist) + 2*iSpace - 2*iDist)/(2*iDist));
      adjust = cur_cx_desk - cur_cx[k] - x1;
      
      ii_updating_first = 0;
      ii_updating_last = items.count() - 1;
      last_ii_first = 0;
      last_ii_last = items.count() - 1;
      ii_first = 0;
      ii_last = items.count() - 1;
      sx = 0;
      sw = w1;
      w = w1;
      h = h1;
      x = x1;

      if(fJustEntered)
      {
         // mouse over the dock
         fJustEntered = FALSE;
         //QApplication::syncX();
         topBg = QPixmap::grabWindow(qt_xrootwin(), x1, dh - h1, w1, h1 - h0);
         debug(QString("grabWindow(%1, %2, %3, %4)").arg(x1).arg(dh - h1).arg(w1).arg(h1 - h0));

         resize(w1, h1);
         move( x1, dh - h1);
      }
   }
   else if((this->width() == w1) && (abs(e->x() - last_mx) >= UPDATE_DIST))
   {
      last_mx = e->x();
      last_ii_first = ii_first;
      last_ii_last = ii_last;
      ii_first = 0;
      ii_last = items.count() - 1;
      mx = e->x() + x1 - x0;
      if (mx < 0)	// mouse leaving from the left
      {
      	enterLocked = TRUE;
      	leaveEvent(NULL);
      }
      if (mx > (w - (iwBig*2))) leaveEvent(NULL);
    
      for (i = 0; i < items.count() + 1; i++)
      {
         dx = abs(cx[i] - mx);
         if (dx < funcW)
         {
            iSize[i] = func(dx);
         }
         else
         {
            iSize[i] = iwSmall;
            if (i < items.count())
            {
               if (cx[i] < mx)
               {
                  ii_first = min(i + 1, items.count() - 1);
               }
               else if (ii_last == (int)items.count() - 1)
               {
                  ii_last = max(i - 1, 0);
               }
            }
         }
      }
      cur_cx[0] = ix + iSize[0]/2;
      
      for(i=1; i < items.count() + 1; i++)
      {
         cur_cx[i] = cur_cx[i-1] + (iSize[i] + iSize[i-1])/2 + iSpace;
      }

      for(k=0; (k < items.count()) && (mx > cx[k]); k++);
      
      cur_cx_desk = x0 + cx[k] + (int)((cx[k] - mx)*(func(0) + func(iDist) + 2*iSpace - 2*iDist)/(2*iDist));
      adjust = cur_cx_desk - cur_cx[k] - x1;

      ii_updating_first = min(ii_first, last_ii_first);
      ii_updating_last = max(ii_last, last_ii_last);
      
      if (ii_updating_last < (int)items.count() - 1)
      {
         cur_cx[items.count() - 1] = w1 - iwSmall/2 - ix - adjust;
         for (i = items.count() - 2; (int)i >= ii_updating_last + 1; i--)
         {
            cur_cx[i] = cur_cx[i+1] - iDist;
         }
         if (ii_updating_last == 0) cur_cx[0] = cur_cx[1] - iDist - (iSize[0] - iSize[1])/2;
      }

      sx = cur_cx[ii_updating_first] - iSize[ii_updating_first]/2;
      sx -= min (iSpace/2, ix);
      sw = cur_cx[ii_updating_last] - sx + iSize[ii_updating_last]/2 + iSpace/2;


      if (ii_updating_first == 0)
      {
         sx = 0;
         sw = cur_cx[ii_updating_last] + iSize[ii_updating_last]/2 + iSpace/2;
      }

      if (ii_updating_last == (int)items.count() - 1) sw = w1 - sx;
   }

   if(showNames == 1 && iwBig == iwBig2)
   {
      // get the name of the item at the mouse position
      // ( nom = item->getName )
      mx = e->x();
      my = e->y();
      mx = mx + x1 - x0 - ix;
      i = mx/iDist;
	  if (i < MAX_ICONS+1)
	  {
		if ((my >= h1 - iy - iSize[i]) && (my <= h1 - iy))
		{
			if (((int)i >= 0) && (i < items.count()))
			{
				nom = items.at(i)->getName();
				//nom=QString("%1 (%2)").arg(items.at(i)->getName(), idventana);
			}
			else
			{
				nom = "";
			}
		}
	  }

      if ((int)i == 0)
      {
         // first icon text location
         xosdw->move(x + (cur_cx[i] - iwSmall/2 - iSpace/2 + adjust + SPACE_W) - (xosdw->w/2), dh - h - xosdw->h);
      }
      else
      {
         // the rest of the icons
         xosdw->move(x + (cur_cx[i] - iwSmall/2 + adjust + SPACE_W) - (xosdw->w/2), dh - h - xosdw->h);
      }
      if(xosd_st==0)
      {
         xosdw->setText(nom);
         xosdw->show();
         xosd_st=1;
      }
      else
      {
         if(nom!=aux)
         {
            xosd_st=0;
         }
      }
      aux = nom;
   }
   doRepaint = TRUE;
}


//Mouse Wheel now switches desktops (away from user desktop+1, towards user desktop-1)
//-Francisco
void KoolDock::wheelEvent(QWheelEvent *e)
{
	//kdDebug(0) << "Bla: " << e->delta() << endl;
	if(e->delta()==120 && (KWin::currentDesktop()<KWin::numberOfDesktops()))
	{
		KWin::setCurrentDesktop(KWin::currentDesktop()+1);
	}
	if((e->delta()==-120) && (KWin::currentDesktop()>0))
	{
		KWin::setCurrentDesktop(KWin::currentDesktop()-1);
	}
}


void KoolDock::mkbigTimerDo()
{
   iwBig = iwBig + (iwBig2/fGrowFrames);	// frames to grow up the dockbar
   if (iwBig > iwBig2)
   {
      iwBig = iwBig2;
      mkbigTimer->stop();
      debug(QString("Stopped mkbigTimer"));
      updateSizes(QWidget::mapFromGlobal ( QCursor::pos() ));
      doRepaint = TRUE;
   }
   else
   {
      iDist = iwSmall + iSpace;
      funcW = (int)(2.5*iDist);
      funcH = iwBig - iwSmall;
      iy = (iDist - iwSmall) / 2;
      updateSizes(QWidget::mapFromGlobal ( QCursor::pos() ));
      doRepaint = TRUE;
   }
}


void KoolDock::mksmallTimerDo()
{
   int i;
   iwBig = iwBig - (iwBig2/fGrowFrames);
   if (iwBig <= iwSmall)
   {
      mksmallTimer->stop();
      debug(QString("Stopped mksmallTimer"));
      w = w0;
      x = x0;
      h = h0;

      // normalize the dock
      for (i = 0; i < (int)items.count() + 1; i++)
      {
         iSize[i] = iwSmall;
         cur_cx[i] = cx[i];
      }
      
      ii_updating_first = 0;
      ii_updating_last = items.count() - 1;
      last_ii_first = 0;
      last_ii_last = items.count() - 1;
      ii_first = 0;
      ii_last = items.count() - 1;
      sx = 0;
      sw = w;
      adjust = 0;
      iwBig = iwBig2;
      if (fHidden == 0)
      {
         move( x, dh - h );
         resize(w, h);
      }
      else
      {
         move( x, dh);
         resize(w, h);
      }
      doRepaint = TRUE;
   }
   else
   {
      if (fHidden == 1) Ybase = Ybase + (iwBig/fShowFrames);
      iDist = iwSmall + iSpace;
      funcW = (int)(2.5*iDist);
      funcH = iwBig - iwSmall;
      iy = (iDist - iwSmall) / 2;
      updateSizes(lastXPos);
      doRepaint = TRUE;
   }
}


void KoolDock::updateSizes(QPoint e)
{
   // This is basically the same as mouseMoveEvent()
   // this will do the parabollic effect to grow from the bottom
   // when the mouse comes in
   // hmm.. I wonder if i can generate a mouseMoveEvent from here
   // to avoid the duplication of the code...
   //QPoint e;
   ///e = QWidget::mapFromGlobal ( QCursor::pos() );
   unsigned int i;
   int mx;
   int dx;
   unsigned int k;
   int cur_cx_desk;

   if (fJustEntered)
   {
      mx = e.x();
      last_mx = mx + x0 - x1;
   }
   else
   {
      mx = e.x() + x1 - x0;
      last_mx = e.x();
   }
		
   for (i=0; i < items.count() + 1; i++)
   {
      dx = abs(cx[i] - mx);
      if (dx < funcW)
      {
         iSize[i] = func(dx);
      }
      else
      {
         iSize[i] = iwSmall;
      }
   }
	
   cur_cx[0] = ix + iSize[0]/2;
   for(i=1; i < items.count() + 1; i++)
   {
      cur_cx[i] = cur_cx[i-1] + (iSize[i] + iSize[i-1])/2 + iSpace;
   }
		
   for (k=0; (k < items.count()) && (mx > cx[k]); k++);
		
   cur_cx_desk = x0 + cx[k] + (int)((cx[k] - mx)*(func(0) + func(iDist) + 2*iSpace - 2*iDist)/(2*iDist));
   adjust = cur_cx_desk - cur_cx[k] - x1;
		
   ii_updating_first = 0;
   ii_updating_last = items.count() - 1;
   last_ii_first = 0;
   last_ii_last = items.count() - 1;
   ii_first = 0;
   ii_last = items.count() - 1;
   sx = 0;
   sw = w1;
	
   w = w1;
   h = h1;
   x = x1;
}


void KoolDock::waitTimerEnd()
{
   enterLocked = false;
   waitTimer->stop();
   delete(waitTimer);
   debug("waitTimerEnd();");
   enterEvent(NULL);
}


void KoolDock::enterEvent(QEvent *)
{
   if (enterLocked == true)
   {
      debug("enterEvent (enterLocked)");
      waitTimer = new QTimer(this);
      connect(waitTimer, SIGNAL(timeout()), this, SLOT(waitTimerEnd()));
      waitTimer->start(5, FALSE);
      return;
   }
   debug("enterEvent");
   enterTimer->start( 1, TRUE );

   fJustEntered = TRUE;
   fDrawAsJustEntered = TRUE;

   iwBig = iwSmall;
   iDist = iwSmall + iSpace;
   funcW = (int)(2.5*iDist);
   funcH = iwBig - iwSmall;
   iy = (iDist - iwSmall) / 2;
   mkbigTimer->start(1, FALSE);
}


void KoolDock::leaveEvent(QEvent *)
{
   debug("leaveEvent");
   lastXPos = QWidget::mapFromGlobal ( QCursor::pos() );
   mkbigTimer->stop();
   mksmallTimer->start(1, FALSE);

   if(showNames==1)
   {
      xosdw->hide();
      xosd_st=0;
   }
   enterLocked = false;
   if(fHidden==1) trackTimer->start(hideTimer, FALSE);
}


void KoolDock::edit()
{
   editPref();
   setupdlg->tabWidget->setCurrentPage(1);
}


void KoolDock::run(QString command)
{
   QString exec;

   kapp->propagateSessionManager();

   _filterData->setData( command.stripWhiteSpace() );
   QStringList filters;
   filters << "kurisearchfilter" << "kshorturifilter";
   KURIFilter::self()->filterURI( *(_filterData), filters );

   QString cmd = (_filterData->uri().isLocalFile() ? _filterData->uri().path():_filterData->uri().url());

   // Nothing interesting. Quit!
   if(cmd.isEmpty())
   {
      KMessageBox::sorry(0L, i18n("You have to enter a command to execute or a URL to be opened first."));
      return;
   }
   else
   { 
      switch( _filterData->uriType() )
      {
         case KURIFilterData::LOCAL_FILE:
         case KURIFilterData::LOCAL_DIR:
         case KURIFilterData::NET_PROTOCOL:
         case KURIFilterData::HELP:
         {
            (void) new KRun( _filterData->uri() );
            return;
         }
         case KURIFilterData::EXECUTABLE:
         case KURIFilterData::SHELL:
         {
            exec = cmd;
            if( _filterData->hasArgsAndOptions() ) cmd += _filterData->argsAndOptions();
            break;
         }
         case KURIFilterData::UNKNOWN:
         case KURIFilterData::ERROR:
         default:
            KMessageBox::sorry( 0, i18n("<qt>The program name or command <b>%1</b>\n"
                                 "cannot be found. Please correct the command\n"
                                 "or URL and try again</qt>").arg( cmd ) );
            return;
      }
   }
   
   if(KRun::runCommand( cmd, exec, "" ))
   {
      return;
   }
   else
   {
      KMessageBox::sorry( 0, i18n("<qt>Could not run <b>%1</b>.\nPlease correct"
					" the command or URL and try again.</qt>").arg( cmd ) );
      return;
   }
}


// Parabolic function
int KoolDock::func(int x)
{
   int res = iwBig - (int)((x*x*funcH)/(funcW*funcW));
   return res;
}


//Here we add windows to the taskbar
void KoolDock::addWindows()
{

   // Show task bar
   if(fShowTaskbar)
   {
      KWin::WindowInfo info;
      QValueList<WId>::ConstIterator it;

      //First we removed every taskbar item
      if(fCurrent==1)
      {
         int count=items.count()-numSystray;
         for(int i=count; i>=numLaunchers; i--)
         {
            items.remove(i);
         }
      }

      //Lets go through all the windows
      for (it=wm->windows().begin(); it != wm->windows().end(); ++it)
      {
         if(fCurrent==1)
         {
            info=KWin::windowInfo(*it);
            //If it belongs to the current desktop, lets add it
            if(info.isOnDesktop(KWin::currentDesktop())==true)
            {
               addTask(*it);
            }
         }
         else
         {
            if(firstTime==true)
            {
               addTask(*it);
            }
         }
      }
      firstTime=false;
   }
}


//What happens when we change desktops
void KoolDock::currentDesktopChanged(int)
{
   /*if(fHidden==1)
   {
      fJustEntered=FALSE;
      leaveEvent(NULL);
   }*/
   addWindows();
   doUpdateGeometry();
}


void KoolDock::windowAdded(WId id)
{
   KWin::WindowInfo info;
   info = KWin::windowInfo(id);
   QString name = info.name();
	
   if (name == "kooldock xosd window")
   {
      debug("Not adding OSD window to taskbar.");
      return;
   }
   if (name == "kooldock")
   {
      debug("Not adding ourselves.");
      doRepaint = TRUE;
      return;
   }
	
   debug(QString("windowAdded(%1)").arg(name));
   addTask(id);
   doUpdateGeometry();
}


void KoolDock::windowRemoved(WId id)
{
   unsigned int i;
   Item *item;

   debug(QString("windowRemoved(%1)").arg(id));

   KWin::WindowInfo info;
   info = KWin::windowInfo(id);
   QString name = info.name();
	
   if (name == "kooldock xosd window")
   {
      debug("Not removing OSD window from taskbar.");
      return;
   }
   for (i=numLaunchers; i < items.count()-numSystray; i++ )
   {
      item = items.at(i);
      if(item->getId() == id)
      {
         items.remove(i);
         break;
      }
   }
   doUpdateGeometry();
}


void KoolDock::windowChanged(WId id, unsigned int properties)
{
   Item *item;
   bool iconChanged, nameChanged;
   int i;
   bool toRepaint = FALSE;

   KWin::WindowInfo winfo;
   winfo = KWin::windowInfo(cId);
	
   iconChanged = (properties & NET::WMIcon);
   nameChanged = (properties & NET::WMName);
   properties = 0;
	
   if (id != winId())
   {
      for (i=numLaunchers, item = items.at(numLaunchers); item; i++, item = items.next())
      {
         if(item->getId() == id)
         {
            
            /*if (winfo.mappingState() == NET::Iconic)
            {
               kdDebug(0) << "Window Minimized" << winfo.name() << endl;
               return; //dirty solution
            }*/
            if (ignored(winfo.name()) == true) break;
            if (nameChanged)
            {
               // Window title changed.
               debug(QString("windowChanged (nameChanged)"));
               // FIXME: on gcc2.95 item->setName() falls on a loop and gets a segfault. (?)
               #ifndef _GCC295
               item->setName(winfo.name());
               #endif
               
               if ((fShowNotification) && (id != wm->activeWindow()))
               {
                  debug(QString("windowChanged (inactive window changed)"));
                  // An inactive window's title changed
                  // notify user
                  item->anim(TRUE);
                  if(onChangeTimer == NULL)
                  {
                     onChangeTimer = new QTimer(this);
                     connect( onChangeTimer, SIGNAL(timeout()), this, SLOT(onChangeTimerTicked()));
                     onChangeTimer->start( ON_CHANGE_ANIM_INTERVAL, FALSE );
                  }
                  toRepaint = TRUE;
               }
            }
            
            if(iconChanged)
            {
               debug(QString("windowChanged (iconChanged)"));
               // Window icon changed.
               item->setIcon(KWin::icon(id, iwBig, iwBig, TRUE));
               toRepaint = TRUE;
            }
            
            if(toRepaint) doRepaint = TRUE;
            break;
         }
      }
   }
}

void KoolDock::systemTrayWindowAdded(WId id)
{
   if(fSystray==1)
   {
      KWin::WindowInfo info;
      info = KWin::windowInfo(id);
      QString name = info.name();
      QPixmap pix = KWin::icon(id, iwBig, iwBig, TRUE);

      numSystray++;
      if (ignored(info.name()) == false)
      {
         items.append(new Item(pix, id, name, iwSmall, iwBig));
         debug(QString("addSystem Tray(%1)").arg(info.name()));
      }
      doUpdateGeometry();
   }
}

void KoolDock::systemTrayWindowRemoved(WId id)
{
   if(fSystray==1)
   {
      numSystray--;
      if(numSystray<0) numSystray=0;
      windowRemoved(id);
   }
}

void KoolDock::activeWindowChanged(WId id)
{
   if (id != winId()) CurrentFocus = id;
	
   // end notify animation
   unsigned int i;
   for (i=0; i<=items.count()-1; i++)
   {
      if (items.at(i)->getId() == id)
      {
         items.at(i)->anim(FALSE);
      }
   }
	
   bool toDelete = TRUE;
   for (i=0; i<=items.count()-1; i++)
   {
      if (items.at(i)->isAnimed()) toDelete = FALSE;
   }	
	
   if (toDelete && onChangeTimer != NULL)
   {
      delete(onChangeTimer);
      onChangeTimer = NULL;
      debug("Deleted onChangeTimer");
   }
}


void KoolDock::doUpdateGeometry()
{
   int i;
	
   // set up all icon sizes to the small size.
   for (i=0; i < (int)items.count() + 1; i++)
   {
      iSize[i] = iwSmall;
   }
	
   for (i=0; i < (int)items.count() + 1; i++)
   {
      cx[i] = ix + i*iDist + iwSmall/2;
      cur_cx[i] = cx[i];
   }
   w0 = 2*ix + (items.count() - 1)*iDist + iwSmall;
   w = w0;
   x0 = (dw - w0) / 2;
   x = x0;
   h0 = 2*iy + iwSmall;
   h = h0;
   h1 = 2*iy + iwBig;
   sx = 0;
   sw = w;
   adjust = 0;

   if(fHidden == 0)
   {
      resize(w, h);
      move( x, dh - h );
   }
	
   offscr = QPixmap(dw, h1);
	
   ii_first = 0;
   ii_last = items.count() - 1;
   last_ii_first = 0;
   last_ii_last = items.count() - 1;
   ii_updating_first = 0;
   ii_updating_last = ii_last;

   w1 = w0 + (iwBig - iwSmall)*3 + ix + iSpace;
   x1 = (dw - w1) / 2;

   debug(QString("w1: %1").arg(w1));
   debug(QString("x1: %1").arg(x1));
   doRepaint = TRUE;
}


void KoolDock::addTask(WId id)
{
   QPixmap pix = KWin::icon(id, iwBig, iwBig, TRUE);

   KWin::WindowInfo info;
   info = KWin::windowInfo(id);
   const int SUPPORTED_WINDOW_TYPES = NET::NormalMask | NET::DesktopMask | NET::DockMask | NET::ToolbarMask | NET::MenuMask | NET::DialogMask | NET::OverrideMask | NET::TopMenuMask | NET::UtilityMask | NET::SplashMask;
   QString name = info.name();
   
   if (info.windowType(SUPPORTED_WINDOW_TYPES) == NET::Normal || info.windowType(SUPPORTED_WINDOW_TYPES) == NET::Override || info.windowType(SUPPORTED_WINDOW_TYPES) == NET::Dialog || info.windowType(SUPPORTED_WINDOW_TYPES) == NET::Unknown)
   {
      if ((info.state() & NET::SkipTaskbar) == 0)
      {
         if (ignored(info.name()) == false)
         {
            items.insert(items.count()-numSystray, new Item(pix, id, name, iwSmall, iwBig));
            debug(QString("addTask(%1)").arg(info.name()));
         }
      }
   }
}


void KoolDock::loadConf()
{
   KConfig *config = KGlobal::config();
   
   config->setGroup("kooldock");
   fShowTaskbar = config->readNumEntry("ShowTaskbar", 0);
   fShowNotification = config->readNumEntry("ShowNotification", 0);
   showNames = config->readNumEntry("showNames", 1);
   xosdFont = config->readEntry("xosdFont", "Tahoma");
   xosdColor = config->readEntry("xosdColor", "#f1f1f1");
   xosdShadowColor = config->readEntry("xosdShadowColor", "#000000");
   xosdSize = config->readNumEntry("xosdSize", 17);
   xosdShadowOffset = config->readNumEntry("xosdShadowOffset", 2);
   fShowBorders = config->readNumEntry("ShowBorders", 0);
   borderColor = QColor(config->readEntry("BorderColor", "#b1c4de"));
   iwSmall = config->readNumEntry("SmallIconSize", 32);
   iwBig = config->readNumEntry("BigIconSize", 90);
   fShowKMenu = config->readNumEntry("ShowKMenu", 0);
   dockOpacity = config->readNumEntry("DockOpacity", 0);
   iSpace = config->readNumEntry("iSpace", 10);
   if (dockOpacity < 0)
   {
      dockOpacity = 0;
   }
   else if (dockOpacity > 100)
   {
      dockOpacity = 100;
   }
   bgColor = QColor(config->readEntry("BackgroundColor", "#ccccff"));
   sepColor = QColor(config->readEntry("SeparatorColor", "#000000"));
   fPriority = config->readNumEntry("Priority", 10);
   fHidden = config->readNumEntry("Hidden", 1);
   fHighLightTime = config->readNumEntry("HighLightTime", 2);
   fHideOnClick = config->readNumEntry("HideOnClick", 0);
   fShowFrames = config->readNumEntry("ShowFrames", 30);
   fGrowFrames = config->readNumEntry("GrowFrames", 40);
   fLeftImg = config->readEntry("LeftImg");
   fRightImg = config->readEntry("RightImg");
   fCenterImg = config->readEntry("CenterImg");
   fFirstRun = config->readBoolEntry("FirstRun", TRUE);
   xinerama = config->readNumEntry("Xinerama", 0);
   leftRes=config->readNumEntry("leftRes", 0);
   hideTimer = config->readNumEntry("hideTimer", 5);
   Solid = config->readNumEntry("Solid", 1);
   fShowShot = config->readBoolEntry("ShowSShot", TRUE);
   fShowNav=config->readNumEntry("Navigator", 1);
   fSystray=config->readNumEntry("Systray", 0);
   fCurrent=config->readNumEntry("currentDesktop", 0);
   curTheme=config->readEntry("Theme");
   fRepaintInterval = config->readNumEntry("RepaintInterval", 5);
	
   if(config->readNumEntry("xosdBold", 1) == 0)
   {
      xosdBold = false;
   }
   else
   {
      xosdBold = true;
   }

   if(config->readNumEntry("xosdItalic", 1) == 0)
   {
      xosdItalic = false;
   }
   else
   {
      xosdItalic = true;
   }
	
   if (iwSmall > iwBig)
   {
      iwSmall = 32;
      iwBig = 90;
   }
   if (!fShowTaskbar)
   {
      fShowNotification = 0;
   }
   if (fHidden > 1) fHidden = 1;
   ix = iSpace;
}


void KoolDock::loadIgnore()
{
   QString line;

   // read the ignorelist into 'ignoreList'
   QFile in(QString(progPath + "/ignorelist.conf"));

   //clear de ignoreList and the KEditListBox (ignoreBox)
   ignoreList.clear();
   setupdlg->ignoreBox->clear();
   if (in.open(IO_ReadOnly))
   {
      while (in.readLine(line, MAX_LEN) != -1)
      {
         //append the item and strip the last char (new line)
         ignoreList.append(line.mid(0, line.length()-1));
      }
      in.close();
      if(!ignoreList.isEmpty()) setupdlg->ignoreBox->insertStringList(ignoreList);
   }
}


void KoolDock::saveConf()
{
   KConfig *config = KGlobal::config();
   
   config->setGroup("kooldock");
   config->writeEntry("ShowTaskbar", fShowTaskbar);
   config->writeEntry("ShowNotification", fShowNotification);
   config->writeEntry("ShowBorders", fShowBorders);
   config->writeEntry("BorderColor", borderColor.name());
   config->writeEntry("SmallIconSize", iwSmall);
   config->writeEntry("BigIconSize", iwBig);
   config->writeEntry("DockOpacity", dockOpacity);
   config->writeEntry("BackgroundColor", bgColor.name());
   config->writeEntry("SeparatorColor", sepColor.name());
   config->writeEntry("ShowKMenu", fShowKMenu);
   config->writeEntry("Priority", fPriority);
   config->writeEntry("Hidden", fHidden);
   config->writeEntry("ShowFrames", fShowFrames);
   config->writeEntry("GrowFrames", fGrowFrames);
   config->writeEntry("showNames", showNames);
   config->writeEntry("xosdFont", xosdFont);
   config->writeEntry("xosdColor", xosdColor);
   config->writeEntry("xosdShadowColor", xosdShadowColor);
   config->writeEntry("xosdSize", xosdSize);
   config->writeEntry("HideOnClick", fHideOnClick);
   config->writeEntry("HighLightTime", fHighLightTime);
   config->writeEntry("iSpace", iSpace);
   config->writeEntry("FirstRun", FALSE);
   config->writeEntry("Xinerama", xinerama);
   config->writeEntry("hideTimer", hideTimer);
   config->writeEntry("Solid", Solid);
   config->writeEntry("ShowSShot", fShowShot);
   config->writeEntry("Navigator", fShowNav);
   config->writeEntry("Systray", fSystray);
   config->writeEntry("currentDesktop", fCurrent);
   config->writeEntry("RepaintInterval", fRepaintInterval);
	
   if (xosdBold == true)
   {
      config->writeEntry("xosdBold", 1);
   }
   else
   {
      config->writeEntry("xosdBold", 0);
   }
   
   if (xosdItalic == true)
   {
      config->writeEntry("xosdItalic", 1);
   }
   else
   {
      config->writeEntry("xosdItalic", 0);
   }
	
   config->sync();
}


void KoolDock::editPref()
{
   bool tmp; //to save some code
	
   // open up the configuration dialog
   setupdlg->show();
   
   // Fill dialog with values from configuration
   if (fHidden==1)
   {
      tmp=true;
   }
   else
   {
      tmp=false;
   }
   setupdlg->chk1->setChecked(tmp);
   setupdlg->hideTimer->setEnabled(tmp);
   setupdlg->hideOnClick->setEnabled(tmp);
   
   if(fShowTaskbar==1)
   {
      setupdlg->chk6->setEnabled(true);
      setupdlg->chkSshot->setEnabled(true);
      setupdlg->currentDesk->setEnabled(true);
   }
   else
   {
      setupdlg->chk6->setEnabled(false);
      setupdlg->chkSshot->setEnabled(false);
      setupdlg->currentDesk->setEnabled(false);
   }
   
   if(fSystray==1)
   {
      setupdlg->systray->setChecked(true);
   }
   else
   {
      setupdlg->systray->setChecked(false);
   }

   if(fCurrent==1)
   {
      setupdlg->currentDesk->setChecked(true);
   }
   else
   {
      setupdlg->currentDesk->setChecked(false);
   }
   //Even if start Hidden is disabled we load the stored value
   setupdlg->hideTimer->setValue(hideTimer);
   if (fHideOnClick == 1) setupdlg->hideOnClick->setChecked(TRUE);
   if (showNames==1)
   {
      tmp=true;
   }
   else
   {
      tmp=false;
   }
   setupdlg->chk2->setChecked(tmp);
   setupdlg->xosdBold->setEnabled(tmp);
   setupdlg->xosdItalic->setEnabled(tmp);
   setupdlg->xosdSize->setEnabled(tmp);
   setupdlg->spinBox2->setEnabled(tmp);
   setupdlg->kColorCombo1->setEnabled(tmp);
   setupdlg->kColorCombo_shadow->setEnabled(tmp);
   setupdlg->xosdFont->setEnabled(tmp);
 
   if(Solid==1)
   {
      setupdlg->chkSolid->setChecked(true);
      setupdlg->chkSolidSlot();
   }
   else
   {
      if(!curTheme.isEmpty()) setupdlg->theme->setCurrentText(curTheme);
      setupdlg->chkImg->setChecked(true);
      setupdlg->chkSolidSlot();
   }
   if (fShowBorders == 1) setupdlg->chk4->setChecked(TRUE);
   setupdlg->kColorCombo1->setColor(xosdColor);
   setupdlg->kColorCombo_shadow->setColor(xosdShadowColor);
   setupdlg->xosdFont->setCurrentFont(xosdFont);
   setupdlg->kColorCombo2->setColor(bgColor.name());
   setupdlg->kColorCombo3->setColor(borderColor.name());
   setupdlg->kColorCombo4->setColor(sepColor.name());
   setupdlg->spinBox1->setValue(dockOpacity);
   setupdlg->xosdSize->setValue(xosdSize);
   setupdlg->spinBox2->setValue(xosdShadowOffset);
   if (fShowTaskbar == 1) setupdlg->chk5->setChecked(TRUE);
   if (fShowNotification == 1) setupdlg->chk6->setChecked(TRUE);
   if (fShowKMenu == 1) setupdlg->chk7->setChecked(TRUE);
   setupdlg->iwSmall->setValue(iwSmall);
   setupdlg->iwBig->setValue(iwBig);
   if (xosdBold == true) setupdlg->xosdBold->setChecked(TRUE);
   if (xosdItalic == true) setupdlg->xosdItalic->setChecked(TRUE);
   if (xinerama==1)
   {
      setupdlg->xrma->setChecked(TRUE);
      setupdlg->SleftRes->setEnabled(true);
      setupdlg->SleftRes->setValue(leftRes);
   }
   else
   {
      setupdlg->SleftRes->setEnabled(false);
   }
   if (fShowNav==1) setupdlg->nav->setChecked(true);
   setupdlg->chkSshot->setChecked(fShowShot);
   
   loadIgnore(); //Load Ignore List

   setupdlg->tabWidget->setCurrentPage(0);
}


void KoolDock::loadMenu()
{
   QDir homeDir = QDir::home();
   if (homeDir.exists(menuPath))
   {
      QDir dir(menuPath);
      //First we make sure every index is correct!
      //Lets update the launchers index
      QString preffix;
      QStringList fileListRemove=dir.entryList("*.desktop");
      QStringList fileListRemove2=fileListRemove;
                     
      //Not really sure why I couldn't do this within the other for, something like  fileListRemove[i].remove(0,2).prepend(preffix), but hell it works
      for(unsigned int i=0; i<fileListRemove2.count(); i++)
      {
         fileListRemove2[i].remove(0,2);
      }
                     
      //Rename the files so they reflect their new position
      for(unsigned int i=0; i<fileListRemove.count(); i++)
      {
         if(i<10) preffix=QString("0%1").arg(i);
         if(i>=10) preffix=QString("%1").arg(i);
            
         dir.rename(fileListRemove[i], QString("%1%2").arg(preffix).arg(fileListRemove2[i]));
      }
      //End updating launchers index
      
      QStringList fileList = dir.entryList( "*.desktop");
      if(!fileList.isEmpty())
      {
         for ( QStringList::Iterator it = fileList.begin(); it != fileList.end(); ++it )
         {
            if ( ((*it) != ".") && ((*it) != "..") )
            {
               items.append(new Item(menuPath + (*it), iwSmall, iwBig));
            }
         }
      }
   }
   else
   {
      debug("Config directory doesn't exits");
      QDir progPathDir(progPath);
      progPathDir.mkdir(progPath);
      QDir menuPathDir(menuPath);
      menuPathDir.mkdir(menuPath);
      debug("Created item directory");
	
      // create initial entries.
      addFile(QString("00_konqueror.desktop"), QString("konqueror"), QString("kfmclient openProfile webbrowsing"), QString("Konqueror Web Browser"), true, false, false, false, QString("na"));
      addFile(QString("01_home.desktop"), QString("kfm_home"), QString("kfmclient openProfile filemanagement"), QString("Home directory"), true, false, false, false, QString("na"));
      addFile(QString("02_kmail.desktop"), QString("kmail"), QString("kmail"), QString("KMail"), true, false, false, false, QString("na"));
      addFile(QString("03_kate.desktop"), QString("kate"), QString("kate"), QString("Kate"), true, false, false, false, QString("na"));
      addFile(QString("04_konsole.desktop"), QString("konsole"), QString("konsole"), QString("Konsole"), true, false, false, false, QString("na"));
      addFile(QString("05_kcontrol.desktop"), QString("kcontrol"), QString("kcontrol"), QString("Control Center"), true, false, false, false, QString("na"));
      
      loadMenu();
   }
   numLaunchers = items.count();
}


void KoolDock::about()
{
   KAboutApplication about(this, 0);
   about.exec();
}


void KoolDock::enterTimerTicked()
{
   fDrawAsJustEntered = FALSE;
   if (enterTimer) enterTimer->stop();
}


void KoolDock::onChangeTimerTicked()
{
   if (animValue > 70) animState = FALSE;
   if (animValue < 5) animState = TRUE;
	
   if (animState == TRUE)
   {
      animValue = animValue + 5;
   }
   else
   {
      animValue = animValue - 5;
   }
   doRepaint = TRUE;
}


void KoolDock::updateBackground(const QPixmap& pix)
{
   if (fHidden == 0) bottomBg = QPixmap(pix);
   if (dockOpacity > 0)	KPixmapEffect::fade(bottomBg, ((float)dockOpacity)*0.01, bgColor);
   doRepaint = TRUE;
}


void KoolDock::minApp()
{
	Item *item;
	int i;
	QPixmap shot;
	QImage tmpImg;
	
	if (fShowShot == TRUE)
	{
		for (i=numLaunchers, item = items.at(numLaunchers); item; i++, item = items.next())
		{
			if(item->getId() == cId)
			{
				// take the screenshot
				shot = QPixmap::grabWindow(cId);
				// scale the screenshot
				tmpImg = shot.convertToImage();
				tmpImg.scale(iwBig, iwBig);
				shot.convertFromImage(tmpImg);
				// set the new item's icon
				item->setIcon(shot);
			}
		}
	doRepaint = TRUE;
	}
	
	KWin::iconifyWindow(cId, true);
}


void KoolDock::maxApp()
{
	Item *item;
	int i;
	if (fShowShot == TRUE)
	{
		for (i=numLaunchers, item = items.at(numLaunchers); item; i++, item = items.next())
		{
			if(item->getId() == cId)
			{
			// set default's item icon
			item->setIcon(KWin::icon(cId, iwBig, iwBig, TRUE));
			}
		}
	}
	
	KWin::setState(cId, NET::Max);
	KWin::activateWindow(cId);
}


void KoolDock::restApp()
{
	Item *item;
	int i;
	if (fShowShot == TRUE)
	{
		for (i=numLaunchers, item = items.at(numLaunchers); item; i++, item = items.next())
		{
			if(item->getId() == cId)
			{
			// set default's item icon
			item->setIcon(KWin::icon(cId, iwBig, iwBig, TRUE));
			}
		}
	}
   
	KWin::clearState(cId, NET::MaxVert + NET::MaxHoriz);
	KWin::deIconifyWindow(cId, true);
	KWin::activateWindow(cId);
}

void KoolDock::activateApp()
{
	Item *item;
	int i;
	if (fShowShot == TRUE)
	{
		for (i=numLaunchers, item = items.at(numLaunchers); item; i++, item = items.next())
		{
			if(item->getId() == cId)
			{
			// set default's item icon
			item->setIcon(KWin::icon(cId, iwBig, iwBig, TRUE));
			}
		}
	}
	KWin::activateWindow(cId);
	doRepaint = TRUE;
}

void KoolDock::closeApp()
{
   NETRootInfo app(qt_xdisplay(), NET::CloseWindow);
   app.closeWindowRequest(cId);
   debug(QString("Closed: %1").arg(cId));
   enterLocked = true;
}


void KoolDock::editItem()
{
   run(QString("kfmclient openProperties ") + iFilename);
}


void KoolDock::sendToDesktop(int desktop)
{
   if(desktop==0)
   {
      KWin::setOnDesktop(cId, KWin::currentDesktop());
   }
   else
   {
      KWin::setOnDesktop(cId, desktop);
   }
}


void KoolDock::goToDesktop(int desktop)
{
   KWin::setCurrentDesktop(desktop);
}


void KoolDock::goToWindow(int win)
{
   cId=(WId)win;
   activateApp();
}


void KoolDock::removeItem()
{
   QFile::remove(iFilename);
   restart();
}


void KoolDock::addFile(QString filename, QString iconname, QString execname, QString name, bool notify, bool terminal, bool tclose, bool cuser, QString puser)
{
   QString progPath = locateLocal("data", "kooldock");
   QString menuPath = progPath + QString("/menu/");
   QString confFile = locateLocal("config", "kooldockrc");

   QFile out(QString(menuPath + filename));
   if (out.open(IO_WriteOnly))
   {
      QTextStream out_s(&out);
      out_s << "[Desktop Entry]" << endl;
      out_s << "Comment=" << endl;
      out_s << "Encoding=UTF-8" << endl;
      out_s << "Exec=" << execname << endl;
      out_s << "GenericName=" << endl;
      out_s << "Icon=" << iconname << endl;
      out_s << "MimeType=" << endl;
      out_s << "Name=" << name << endl;
      out_s << "Path=" << endl;
      out_s << "ServiceTypes=" << endl;
      out_s << "SwallowExec=" << endl;
      out_s << "SwallowTitle=" << endl;
      out_s << "Terminal=false" << endl;
      out_s << "TerminalOptions=" << endl;
      out_s << "Type=Application" << endl;
      if(notify == true)
      {
         out_s << "X-KDE-StartupNotify=true" << endl;
      }
      else
      {
         out_s << "X-KDE-StartupNotify=false" << endl;
      }
      if(cuser==true)
      {
         out_s << "X-KDE-SubstituteUID=true" << endl;
         out_s << "X-KDE-Username=" << puser << endl;
      }
      else
      {
         out_s << "X-KDE-SubstituteUID=false" << endl;
         out_s << "X-KDE-Username=" << endl;
      }
      if(terminal==true)
      {
         out_s << "Terminal=true" << endl;
      }
      else
      {
         out_s << "Terminal=false" << endl;
      }
      if(tclose==true)
      {
         out_s << "TerminalOptions=\\s--noclose" << endl;
      }
      else
      {
         out_s << "TerminalOptions=" << endl;
      }
      out.close();
   }
}


bool KoolDock::ignored(QString appname)
{
   if(ignoreList.count()>0)
   {
      for(unsigned int i=0; i<ignoreList.count(); i++)
      {
         if(ignoreList[i]==appname)
         return(true);

      }
   }
   return(false);
}


#ifdef _ENABLE_DEBUG
void KoolDock::debug(QString message)
{
   // debugging function (show messages to stdout)
   kdDebug(0) << "DEBUG: " << message << endl;
}
#endif
#ifndef _ENABLE_DEBUG
void KoolDock::debug(QString)
{
}
#endif

void KoolDock::endProg()
{
   debug("Clean exit.");
   exit(0);
}

void KoolDock::getbottomBg()
{
   bottomBg = QPixmap::grabWindow(qt_xrootwin(), x, dh - h, w, h);
   debug("fHidden = 1, getting background");
}

void KoolDock::restart()
{
   QString cmd;
   cmd = mainPath + " &";
   kdDebug(0) << "mainPath: " << mainPath << endl;
   debug("Restarting...");
   system(cmd.latin1());
   endProg();
}


void KoolDock::chkRestart()
{
   if (!setupdlg) return;
   // this function is called by a timer to check if the dock should be restarted
   // or not, depending on what was done in the configuration dialog.
   if (setupdlg->toRestart->isChecked())
   {
      setupdlg->toRestart->setChecked(FALSE);
      restart();
   }
}


void KoolDock::setMainPath(QString path)
{
   mainPath = path;
}


void KoolDock::forceHide()
{
   move( x, dh);
   resize(w, h);
}
