/***************************************************************************
                          kooldock.h  -  description
                             -------------------
    begin                : Tue Jun 10 22:18:34 BST 2003
    copyright            : (C) 2003 by KoolDock team
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KOOLDOCK_H
#define KOOLDOCK_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kpopupmenu.h>
#include <kwinmodule.h>
#include <kaboutdialog.h>
#include <krootpixmap.h>
#include <kpixmap.h>
#include <kurifilter.h> 

#include <qwidget.h>
#include <qptrlist.h>
#include <qtimer.h>
#include <qcolor.h>

#include <netwm.h>

#include "item.h"
#include "xosd.h"
#include "setupdialogprg.h"

const int MAX_ICONS = 100; // max number of icons
const int UPDATE_DIST = 1; // update when x - last_x <= UPDATE_DIST
const int DEF_SMALL_SIZE = 32; // default small icon size
const int DEF_BIG_SIZE = 90; // default big icon size
const int DEF_DOCK_OPACITY = 50; // default dock opacity
const int DEF_PRIORITY = 10;
const int DEF_HIDDEN = 1; // default hidden priority

const int ANIM_TOTAL_STEP = 6; // not in use yet

const int SPACE_W = 1; // space between quick launchers and tasks (the seperator)

const int ON_CHANGE_ANIM_INTERVAL = 50; // animation's interval

/** KoolDock is the base class of the project */
class KoolDock : public QWidget
{
   Q_OBJECT
   public:
   /** construtor */
   KoolDock(QWidget* parent=0, const char *name=0);
   /** destructor */
   ~KoolDock();
    
   //static bool writeIgnoreList(QString text);
   void updateSizes(QPoint);
   void setMainPath(QString path);
    
   private:
      // configuration variables
      int fShowTaskbar; // show-taskbar flag
      int fShowNotification; // show-notification flag
      int fShowBorders; // show-borders flag
      int fShowKMenu;	// show the K menu
      int fPriority;	// "nice" priority
      QColor borderColor;
      int fHidden;	// hidden dockbar
      int fHideOnClick;
      int fShowFrames;	// frames to show the dock "growing from bottom"
      int fGrowFrames;	// frames to grow the icon when the mouse is over it.
      int fHighLightTime;
      bool fFirstRun;
      bool fShowShot;
      int fRepaintInterval;
      int xinerama; //whether we want xinerama
      int hideTimer; //user define time to show dock
      int Solid; //whether using backgroung Image or not (for preference controls)
      int fShowNav; //whether we want the navigation menu (clock + desktop chooser) in kooldocks main menu
      int numSystray; //for systray control
      int fSystray; //whether we want the systray or not
      int fCurrent; //whether to only show windows on current desktop
      bool firstTime; //to control certain things
      QString curTheme; //for the background theme (to preserve changes)
      int leftRes; //Left monitor resolution

      QString fLeftImg;
      QString fRightImg;
      QString fCenterImg;
    
      QPixmap LeftImg;
      QPixmap RightImg;
      QPixmap CenterImg;
      QPixmap TempScaledCenter; 
    
      int iwSmall;
      int iwBig;
      int iwBig2;

      int dockOpacity;
      QColor bgColor;

      QColor sepColor; // separator bar's color

      int Ybase;

      // normal variables

      QString progPath;
      QString menuPath;
      QString confFile;
      QString iFilename;  // right clicked item filename
      QString mainPath;

      QStringList ignoreList;


      NETWinInfo *info;
      KWinModule *wm;
      SetupDialog *setupdlg;

      int numLaunchers; // number of quick launcher items
      int x, y, w, h, h0, h1, w0, x0, w1, x1;
      int ix, iy, iDist, iSpace;
      int dw, dh;
      int funcW, funcH;
      int ii_first, ii_last;
      int last_ii_first, last_ii_last;
      int ii_updating_first, ii_updating_last;
      int sx, sw;
      int adjust;
      int last_mx;

      QPtrList<Item> items;
      int iSize[MAX_ICONS + 1];
      int cx[MAX_ICONS + 1];
      int cur_cx[MAX_ICONS + 1];
      QPixmap offscr;

      KRootPixmap *rootpix;
      KPixmap bottomBg;
      QPixmap topBg;

      KAboutDialog *aboutDlg;
      QTimer *enterTimer; // used in enterEvent
      QTimer *mkbigTimer;
      QTimer *mksmallTimer;
      QTimer *onChangeTimer; // used when a window has changed and we need to notify user
      QTimer *trackTimer;
      QTimer *showTimer;
      QTimer *resTimer;
      QTimer *repaintTimer;

      bool enterLocked;	// boolean to lock the enterEvent (to avoid some bugs)
      QTimer *waitTimer;

      int animStep; // animation step, not in use yet
      int iOnClick; // index of the quick launcher being clicked
      WId cId;  // id of the application (used in the right click menu over the taskbar)
      WId CurrentFocus;
      int onChangeAnimStep;

      bool fJustEntered;
      bool fDrawAsJustEntered;
       /*Xosd Section */
      QString nom;
      QString aux;
      //xosd *osd;
      int xosd_st;
      int showNames;
      int xosdShadowOffset;
      QString xosdFont;
      QString xosdColor;
      QString xosdShadowColor;
      bool xosdBold;
      bool xosdItalic;
      int xosdSize;
      KURIFilterData *_filterData;
      xosd *xosdw;
      int animValue;
      int animState;

      void run(QString cmd);
      int func(int x);
      void doUpdateGeometry();
      void addTask(WId id);
      void loadConf();
      void loadIgnore();
      void saveConf();
      void loadMenu();
      void addWindows();
      bool doRepaint;
      QPoint lastXPos;
  
   protected:
      void paintEvent(QPaintEvent *);
      void mousePressEvent( QMouseEvent * );
      void mouseMoveEvent(QMouseEvent* );
		void wheelEvent(QWheelEvent *);
      void enterEvent(QEvent*);
      void leaveEvent(QEvent*);

   public slots:
      void edit();
      void editPref();
      void about();
      void windowAdded(WId id);
      void windowRemoved(WId id);
      void windowChanged(WId id, unsigned int properties);
      void activeWindowChanged(WId id);
      void currentDesktopChanged(int);
      void enterTimerTicked();
      void onChangeTimerTicked();
      void updateBackground(const QPixmap&);
      void minApp();
      void maxApp();
      void restApp();
      void activateApp();
      void closeApp();
      void editItem();
      void removeItem();
      void sendToDesktop(int);
      void goToDesktop(int);
      void goToWindow(int);
      /* Systray support */
      void systemTrayWindowAdded(WId);
      void systemTrayWindowRemoved(WId);
      
      static void addFile(QString filename, QString iconname, QString execname, QString name, bool notify, bool terminal, bool tclose, bool, QString);
      bool ignored(QString appname);

      #ifdef _ENABLE_DEBUG
      static void debug(QString message);
      #endif
      #ifndef _ENABLE_DEBUG
      static void debug(QString);
      #endif
      void mkbigTimerDo();
      void mksmallTimerDo();
      void endProg();
      void waitTimerEnd();
      void getbottomBg();
      void trackTimerEnd();
      void showTimerTicked();
      void restart();
      void chkRestart();
      void unhighlight();
      void forceHide();
      void repaintSlot();
};

#endif
