/***************************************************************************
 *   Copyright (C) 2005 by Conrad Hoffmann                                 *
 *   conrausch@gmx.de                                                      *
 *   http://conrausch.doesntexist.org                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef KOPETEDESKLISTITEM_H
#define KOPETEDESKLISTITEM_H


#include <qwidget.h>
#include <qstring.h>
#include <qdict.h>

#include <kopeteonlinestatus.h>

class QHBoxLayout;
class QGridLayout;
class QLabel;
class QMouseEvent;
class QPaintEvent;

namespace Kopete
{
	class MetaContact;
	class Contact;
}


class KopeteDesklistItem : public QWidget
{
	Q_OBJECT

public:
	KopeteDesklistItem( Kopete::MetaContact* metaContact, bool forceSingleLine, QWidget* parent = 0, const char* name = 0 );
	~KopeteDesklistItem();

	void updateMetaStatus();

private slots:
	void slotNameChanged();
	void slotPhotoChanged();
	void slotContactStatusChanged( Kopete::Contact* contact, const Kopete::OnlineStatus& status );

private:
	static QPixmap generatePixmap( const Kopete::MetaContact *mc );
	void paintContactIcons();
	void applyRootPixmap( QWidget* w );
	void applyRoundedRootPixmap( QWidget* w );
	void generateToolTips();

	Kopete::MetaContact* m_metaContact;
// 	QString m_sortString;
	QDict<QLabel> m_contacts; // to get a label for a contactId
	QGridLayout* m_outerLayout;
	QHBoxLayout* m_contactIconsLayout;
	QLabel* m_nameLabel;
	QLabel* m_photoLabel;

protected:
	virtual void mouseDoubleClickEvent( QMouseEvent* e );
	virtual void contextMenuEvent( QContextMenuEvent* e );

};

#endif
