#####################################################################
#
#	Author : Kushal Das
#	Copyright (c)  2006 Kushal Das
#	kushal@fedoraproject.org
#	
#	Copyright: See COPYING file that comes with this distribution
#
#
#####################################################################
from qt import *
from qttable import QTable
from qttable import QTableItem
from kdecore import *
from kio import *

class kpbmTable(QTable):
	"""My own QTable to enable file drops"""
	def __init__(self,parent,name):
		QTable.__init__(self,parent,name)
		self.setAcceptDrops(True)
		
	def  dragEnterEvent(self,event):
		event.accept(QTextDrag.canDecode(event))
		
	def dropEvent(self,event):
		text = QString()
		if QTextDrag.decode(event,text):
			if KMimeType.findByPath(text).is_('image/png') or KMimeType.findByPath(text).is_('image/jpeg'):
				i = self.numRows()
				self.insertRows(i)
				self.setItem(i,0,QTableItem(self,QTableItem.Never,text[7:]))
			
			
