/***************************************************************************
                          logsearch.cpp  -  description
                             -------------------
    begin                : Sun Jul 16 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "logsearch.h"
#include <klocale.h>
#include <kseparator.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qfontmetrics.h>
#include <qfile.h>
#include <qsortedlist.h>
#include <qtextstream.h>
#include <qlistview.h>
#include <qapplication.h>
#include <kmessagebox.h>
#include <kstddirs.h>

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <time.h>

#include "globals.h"
#include "logbook.h"
#include "logedit.h"


#include "myqlistviewitem.h"

logSearch::logSearch(QWidget *parent, const char *name ) : QDialog(parent,name)
{
	setWFlags (WDestructiveClose);
	setCaption (i18n("Search Results"));
	QFontMetrics fm (font());
	QVBoxLayout* vbox = new QVBoxLayout (this);
	vbox->setSpacing (5);
	view = new QListView (this);	
	view->setAllColumnsShowFocus (true);
	vbox->addWidget (view);

	view->addColumn (i18n ("CallSign"));
	view->addColumn (i18n ("Name"));
	view->addColumn (i18n ("QTH"));
	view->addColumn (i18n ("RST-S"));
	view->setColumnAlignment ( 3, Qt::AlignHCenter);
	view->addColumn (i18n ("RST-R"));
	view->setColumnAlignment ( 4, Qt::AlignHCenter);
	view->addColumn (i18n ("Band"));
	view->setColumnAlignment ( 5, Qt::AlignHCenter);
	view->addColumn (i18n ("Date"), fm.width("MMM.MM.MM"));
	view->setColumnAlignment ( 6, Qt::AlignHCenter);
	view->addColumn (i18n ("Time"), fm.width("MM:MM"));
	view->setColumnAlignment ( 7, Qt::AlignHCenter);
	view->addColumn (i18n ("Notes"));
	view->setSorting(-1);

	KSeparator* sep = new KSeparator (this);
	vbox->addWidget (sep);

	QHBoxLayout* buttonsLayout = new QHBoxLayout();
	vbox->addLayout (buttonsLayout);

	vbox->addSpacing (5);

	QPushButton* edit = new QPushButton (this);
	edit->setText (i18n ("&Edit"));
	edit->setMaximumWidth (edit->sizeHint().width());

	QPushButton* del = new QPushButton (this);
	del->setText (i18n ("&Delete"));
	del->setMaximumWidth (del->sizeHint().width());

	QPushButton* ok = new QPushButton (this);
	ok->setText (i18n ("&Ok"));
	ok->setMaximumWidth (ok->sizeHint().width());
	ok->setDefault (true);
	
	buttonsLayout->addWidget (edit);
	buttonsLayout->addWidget (del);
	buttonsLayout->addWidget (ok);

	QObject::connect (ok, SIGNAL (clicked()), this, SLOT (close()));
	QObject::connect (del, SIGNAL (clicked()), this, SLOT (slotDeleteQSO()));
	QObject::connect (edit, SIGNAL (clicked()), this, SLOT (slotEdit()));
}

logSearch::~logSearch()
{
}

void logSearch::search (QString search)
{
	char date[25], time[25];
	time_t t;
	qso* q = 0;
	QSortedList<qso> found = logdb->searchString (search);
	found.setAutoDelete(true);
	/* travel the results, and display them */

for ( q=found.first(); q != 0; q=found.next() ) {
	t = q->time();
  strftime (time, 24, "%H:%M", gmtime(&t));
  strftime (date, 24, "%d %b %Y", gmtime(&t));

	myQListViewItem* list = new myQListViewItem (view,q->time());
	list->setText (LIST_CALL, q->call());
	list->setText (LIST_NAME, q->name());
	list->setText (LIST_QTH, q->qth());
	list->setText (LIST_RSTS, q->rsts());
	list->setText (LIST_RSTR, q->rstr());
	list->setText (LIST_BAND, q->band());
	list->setText (LIST_DATE, QString(date));
	list->setText (LIST_TIME, QString(time));
	list->setText (LIST_NOTES, q->notes());
	}	
}


void logSearch::slotEdit()
{
	myQListViewItem* item;
  logEdit* logEditDlg;

 	item = (myQListViewItem*) (view->currentItem());
  if (item == NULL) {
		KMessageBox::information (this, i18n ("You have not selected an QSO!"));
		return;
		}
	logEditDlg = new logEdit (this, item);
	logEditDlg->show();
}

void logSearch::slotDeleteQSO()
{
	QString query;
	myQListViewItem* item;
  time_t t;

 	item = (myQListViewItem*) (view->currentItem());
  if (item == NULL) {
		KMessageBox::error (this, i18n ("You have not selected an QSO!"));
		return;
		}

	if (KMessageBox::questionYesNo (this, i18n ("Really delete selected QSO?"))== KMessageBox::No) return;
	t = item->index();
	logdb->removeQSO(t);
	delete item;
}

