/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Son Jul  2 14:14:12 CEST 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <qtimer.h>
#include <kmessagebox.h>
#include <kstddirs.h>
#include "kpsk.h"

Kpsk *kpsk;

static const char *description =
	I18N_NOOP("KPSK - A Linux KDE PSK31 Terminal");
	
	
static KCmdLineOptions options[] =
{
  { 0, 0, 0 }
};

int main(int argc, char *argv[])
{
	KAboutData aboutData ("kpsk", I18N_NOOP("KPSK"), VERSION, description, KAboutData::License_GPL,
		"(c) 2000, 2003 Luc Langehegermann", 0, "http://kpsk.sourceforge.net", "lx2gt@users.sourceforge.net");
  aboutData.addAuthor("Luc Langehegermann", "User interface", "lx2gt@users.sourceforge.net");
  aboutData.addAuthor("Hans Reiser", "DSP Functions", "dl9rdz@amsat.org");
  aboutData.addAuthor("Dave Kjellquist", "KDE 3.0 port", "dave@kjellquist.com");
  aboutData.addAuthor("Ernie Stracener", "Color waterfall & docs", "kg9ni@users.sf.net");


  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;
  // Check for dxcc.db, we can operate without db but noo dxcc data will be displayed
     if ((locate("appdata", "dxcc.db")==NULL)){
        if (KMessageBox::warningYesNo (0, i18n ("Unable to find dxcc database, Continue?\n Review troubleshooting section of the manual"))==KMessageBox::No){
      //Quit application without database
      return 2;
        }
      }

  kpsk = new Kpsk();
  app.setMainWidget(kpsk);
  kpsk->show();
  return app.exec();
}
