

#ifndef _delay_start_h_
#define _delay_start_h_


#include "delayStartBase.h"


class delayStartDialog : public delayStartBase {

    public:
    
    /// get user specified delay
    int getDelay ( void ) const { return delay; }
    
    /// constructor
    delayStartDialog ( QWidget* parent ) : delayStartBase ( parent ) {
        slider_delay->setValue ( defaults::defaultStartDelay );
        delay = defaults::defaultStartDelay;
    }

    private:

    /// user specified delay
    int delay;
    
    /// this slot is called whenever user move with slider
    void slotTimeChanged ( int x ) {
        delay = x;
        textLabel_selectedTime->setText ( QString ( "%1 sec" ).arg ( delay ) );
    }

};




#endif
