/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkngroup.h"

#include <qtoolbutton.h>
#include <kpushbutton.h>
#include <ktextbrowser.h>

KKNGroup::KKNGroup( const QString& strTitle, QWidget* parent, const char* name )
	: QVBox( parent, name )
{
	setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed );
	KPushButton* btn = new KPushButton( this );
	btn->setText( strTitle );
	btn->setToggleButton( true );
	btn->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed );
	connect( btn, SIGNAL( toggled( bool ) ), this, SLOT( toggled( bool ) ) );

	m_detail = new KTextBrowser( this );
	m_detail->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed );
	m_detail->hide();
}

KKNGroup::~KKNGroup()
{
}

void KKNGroup::toggled( bool on )
{
	if( on )
	{
		m_detail->show();
	}
	else
	{
		m_detail->hide();
	}
}

void KKNGroup::setText( const QString& text )
{
	m_detail->setText( text );
}
