/*
 *  This file is part of the KDE project
 *
 *  Copyright (c) 2007 Cyrille Berger <cberger@cberger.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _KIS_BASIC_MATH_TOOLBOX2_H_
#define _KIS_BASIC_MATH_TOOLBOX2_H_

// TODO: remove that
#define LCMS_HEADER <lcms.h>
// TODO: remove it !


// TODO: when move to krita2, some parts must be merged in KisBasicMathToolbox (mostly the content of the implementation file) and someother in KisMathToolbox (mostly the types declarations and virtual interfaces)

#include <kis_paint_device.h>

class KisBasicMathToolbox2 {
  public:
    struct Pyramid { // TODO: move to KisMathToolbox
      struct Level {
        KisPaintDeviceSP device;
        QSize size;
      };
      QValueVector< Level > levels;
    };
  public:
    KisBasicMathToolbox2() {}
    virtual ~KisBasicMathToolbox2() {}
    /**
     * 
     * @param src
     * @param rect
     */
    virtual Pyramid* toSimplePyramid(KisPaintDeviceSP src, int levels, const QRect& rect);
    /**
     * 
     * @param src
     * @param rect
     */
    virtual Pyramid* toGaussianPyramid(KisPaintDeviceSP src, int levels, const QRect& rect, double a = 0.5);
    /**
     * 
     * @param gaussianPyramid
     */
    virtual Pyramid* toLaplacianPyramid(/*const*/ Pyramid* gaussianPyramid);

    void fromFloatDevice(KisPaintDeviceSP src, KisPaintDeviceSP dst, const QRect&);
  protected:
    KisPaintDeviceSP toFloatDevice(KisPaintDeviceSP src, const QRect&);
};

#endif
