/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <pcap.h>

#include <qstring.h>
#include <qstringlist.h>

#include <klocale.h>

#include "../packetstructures.h"
#include "../packet.h"
#include "frameheadermanager.h"
#include "ethernet2.h"
#include "lcc.h"

FrameHeaderManager::FrameHeaderManager(ptrPacketType packet)
{
  m_packet = (Packet *) packet;
}


QString FrameHeaderManager::strType() const
{
  switch(m_packet->getFrameType())
  {
    case DLT_EN10MB:
      return i18n("type of frame", "Ethernet");
      break;
    case DLT_LINUX_SLL:
      return i18n("type of frame", "Linux Cooked Capture");
      break;
    default:
      return i18n("Unknown");
  }
}

QString FrameHeaderManager::sorceAddress() const
{
  Ethernet2Frame eth(m_packet);

  switch(m_packet->getFrameType())
  {
    case DLT_EN10MB:
      return eth.sourceAddress();
      break;
    case DLT_LINUX_SLL:
      return eth.sourceAddress();
      break;
    default:
      return i18n("Unknown");
  }
}


QString FrameHeaderManager::destinationAddress() const
{
  Ethernet2Frame eth(m_packet);

  switch(m_packet->getFrameType())
  {
    case DLT_EN10MB:
      return eth.destinationAddress();
      break;
    case DLT_LINUX_SLL:
      return "";
      break;
    default:
      return i18n("Unknown");
  }
}


QStringList FrameHeaderManager::headerLines() const
{
  QStringList list;
  Ethernet2Frame eth2(m_packet);
  LinuxCookedCaptureFrame lcc(m_packet);

  switch (m_packet->getFrameType())
  {
    case DLT_EN10MB:
      list = eth2.headerLines();
      break;
    case DLT_LINUX_SLL:
      list = lcc.headerLines();
      break;
    default:
      list = QString::null;
  }

  return list;
}


unsigned short FrameHeaderManager::protocol() const
{
  Ethernet2Frame eth2(m_packet);
  LinuxCookedCaptureFrame lcc(m_packet);
  unsigned short proto;

  switch (m_packet->getFrameType())
  {
    case DLT_EN10MB:
      proto = eth2.protocol();
      break;
    case DLT_LINUX_SLL:
      proto = lcc.protocol();
      break;
    default:
      proto = 0;
  }

  return proto;
}
