/***************************************************************************
 *   Copyright (C) 2007-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/
#ifndef GUIOPTIONTAB_H
#define GUIOPTIONTAB_H

#include "base_guioptiontab.h"

/**
This class manage the GUI option of KSniffer

	@author Giovanni Venturi <giovanni@ksniffer.org>
*/

class CaptureOptions;

class GuiOptionTab : public base_guiOptionTab
{
  Q_OBJECT

  public:
    GuiOptionTab(QWidget *parent=0, const char *name=0);
    ~GuiOptionTab();

    void getShowAfterOptions( CaptureOptions *options );
    void getRawFramePosition( CaptureOptions *options );

    void getOptions( CaptureOptions *options );
    void readSettings();
    bool saveSettings();

  signals:
    void trayBarShown( bool );
    void changedRawFormPosition( bool );

  private slots:
    void checkWarning();

  private:
    void assignRightPositionRaw();
    void assignUnderPositionRaw();
};

#endif
