/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef TCPPROTOCOL_H
#define TCPPROTOCOL_H

class Packet;
class PortNumberNameList;
class QString;
class QStringList;

#include <netinet/in.h>

class TcpProtocol
{
public:
  TcpProtocol();
  TcpProtocol(Packet *packet, PortNumberNameList *pnnl);

  void setPacket(Packet *packet);
  void setPortNumberList(PortNumberNameList *pnnl);
  void giveNameToProtocol();
  void DontGiveNameToProtocol();

  uint16_t sourcePort() const;
  uint16_t destinationPort() const;
  uint16_t win() const;
  uint16_t sequenceNumber() const;
  uint16_t dataLength() const;
  QString detectService( uint16_t const& proto ) const;
  QString flags() const;
  QString protocolName() const;
  QString strInfo() const;

  QStringList headerLines() const;

private:
  Packet *m_packet;
  struct TcpHdr *m_tcp;
  PortNumberNameList *m_portNumberNameList;
  bool m_giveNameToProtocol;
};

#endif
