/*
 * Copyright (C) 2003 Tom Deblauwe <tomNOSPAM.deblauwe@pandora.be>
 */

#include "pref.h"

#include <klocale.h>
#include <kstandarddirs.h>
#include <kmessagebox.h>
#include <kcolorbutton.h>
#include <kiconloader.h>
#include "kprocess.h"
#include "klistview.h"

#include <qlayout.h>
//#include <qlabel.h>
#include <qradiobutton.h>
#include <qdatetime.h>
#include <qdatetimeedit.h>
#include <qspinbox.h>
#include <qregexp.h>
#include <qvaluelist.h>
#include <qcstring.h>
#include <qfile.h>
#include <qcheckbox.h>

#include "prefPageEditorDlg.h"
#include "prefPageMPlayerDlg.h"
#include "qpixmap.h"


#include "csubtitles.h"


//default values//////////////
const long ksubtilePreferences::pref_DefaultAddNewLength = 2000;
const QColor ksubtilePreferences::pref_NavigatorSubtitleColor = QColor( 0, 255, 0);
const QColor ksubtilePreferences::pref_NavigatorHighlightSubtitleColor = QColor( 255, 0, 0 );
const QColor ksubtilePreferences::pref_NavigatorBackgroundColor = QColor( 255, 255, 255 );
const bool ksubtilePreferences::pref_NavigatorDisplayText = true;
const long ksubtilePreferences::pref_DefaultPasteOffset = 1000;

const int ksubtilePreferences::pref_MPlayerPosition = posTopLeft;
const bool ksubtilePreferences::pref_MPlayerAutomaticResize = false;


ksubtilePreferences::ksubtilePreferences()
        : KDialogBase(IconList, i18n("KSubtile Preferences"),
                      Help| Default| Ok|Cancel, Ok)
{
    // this is the base class for your preferences dialog.  it is now
    // a Treelist dialog.. but there are a number of other
    // possibilities (including Tab, Swallow, and just Plain)


    ///////////////

    QFrame *frame;
	QVBoxLayout *topLayout;
	
    KIconLoader* loader = KGlobal::iconLoader();

    frame = addPage(i18n("Editor"), i18n("Editor Options"), loader->loadIcon("ksubtile", KIcon::Toolbar) );
	topLayout = new QVBoxLayout( frame );
	//frame->setBackgroundMode( PaletteBase );
	
    m_pageOne = new ksubtilePrefPageOne(topLayout->mainWidget());
	
    frame = addPage(i18n("MPlayer"), i18n("MPlayer Options"), loader->loadIcon("player_play", KIcon::Toolbar));
	topLayout = new QVBoxLayout( frame );
    m_pageTwo = new ksubtilePrefPageTwo(topLayout->mainWidget());

    //fill in the drivers
    m_pageTwo->fillInAudioOutputDrivers();
    m_pageTwo->fillInVideoOutputDrivers();


    //set a size which should show all dialog
	//TODO: why doesn't the QVBoxLayout doesn't follow the size of 'frame' ???????
	QSize mySize(m_pageTwo->size());
	mySize.setWidth(mySize.width() + 100);
	mySize.setHeight(mySize.height() + 150);
    setInitialSize(mySize);

}

QString ksubtilePreferences::pref_AudioOutputDriver()
{    
    QString ans = readAudioPref( "~/.mplayer/config" );
    if(ans == "")
    {
	ans = readAudioPref( "/etc/mplayer.conf" );
    }
    if(ans == "")
    {
	//if not found, then use the standard kde soundserver "arts"	
	return QString("arts");
    }
    else
    {
	return ans;
    }

}

QString ksubtilePreferences::readAudioPref( QString fileName )
{
    QFile file(fileName);
    if(file.open( IO_ReadOnly))
    {
        QTextStream stream( &file );
        QString line;
        while(!stream.eof())
        {
            line = stream.readLine(); // line of text excluding '\n'

            //do not process lines containing #
            if(!(line.contains(QRegExp( "#" , false, false)) >= 1))
            {
                if(line.contains(QRegExp( "ao=" , false, false)) >= 1)
                {
                    //this line is the preferred audio output driver
                    QStringList list = QStringList::split( QRegExp( "=" ), line, false);
                    file.close();
                    return(list[1]);
                }
            }
        }
    }    
    return QString("");
}

QString ksubtilePreferences::pref_VideoOutputDriver()
{
    QString ans = readVideoPref( "~/.mplayer/config" );
    if(ans == "")
    {
	ans = readVideoPref( "/etc/mplayer.conf" );
    }
    if(ans == "")
    {
	//if not found, then use "x11"	
	return QString("x11");
    }
    else
    {
	return ans;
    }
}

QString ksubtilePreferences::readVideoPref( QString fileName )
{
    QFile file(fileName);
    if(file.open( IO_ReadOnly))
    {
        QTextStream stream( &file );
        QString line;
        while(!stream.eof())
        {
            line = stream.readLine(); // line of text excluding '\n'

            //do not process lines containing #
            if(!(line.contains(QRegExp( "#" , false, false)) >= 1))
            {
                if(line.contains(QRegExp( "vo=" , false, false)) >= 1)
                {
                    //this line is the preferred audio output driver
                    QStringList list = QStringList::split( QRegExp( "=" ), line, false);
                    file.close();
                    return(list[1]);
                }
            }
        }
    }
    return QString("");
}

////"Default Add New Length"

//used to initialize the dialog

void ksubtilePreferences::setDefaultAddNewLength(long newLength)
{
    QTime newTime = CSubtitles::getQTimeFromMSecs(newLength);
    m_pageOne->te_editor_defaultLength->setTime(newTime);
    m_pageOne->sb_editor_defaultLength->setValue(newTime.msec());
}

void ksubtilePreferences::setDefaultPasteOffset(long newLength)
{
    QTime newTime = CSubtitles::getQTimeFromMSecs(newLength);
    m_pageOne->te_editor_defaultOffset->setTime(newTime);
    m_pageOne->sb_editor_defaultOffset->setValue(newTime.msec());
}

//get value back

long ksubtilePreferences::getDefaultAddNewLength()
{
    return CSubtitles::getMSecs( m_pageOne->te_editor_defaultLength->time() ) + m_pageOne->sb_editor_defaultLength->value();
}

long ksubtilePreferences::getDefaultPasteOffset()
{
    return CSubtitles::getMSecs( m_pageOne->te_editor_defaultOffset->time() ) + m_pageOne->sb_editor_defaultOffset->value();
}

////Navigator Subtitle Color

void ksubtilePreferences::setNavigatorSubtitleColor(QColor newColor)
{
    m_pageOne->cb_navigatorSubtitleColor->setColor(newColor);

}

QColor ksubtilePreferences::getNavigatorSubtitleColor(void)
{
    return m_pageOne->cb_navigatorSubtitleColor->color();
}


////Navigator Highlight Subtitle Color

void ksubtilePreferences::setNavigatorHighlightSubtitleColor(QColor newColor)
{
    m_pageOne->cb_navigatorHighlightSubtitleColor->setColor(newColor);

}

QColor ksubtilePreferences::getNavigatorHighlightSubtitleColor(void)
{
    return m_pageOne->cb_navigatorHighlightSubtitleColor->color();
}

////Navigator Background Color

void ksubtilePreferences::setNavigatorBackgroundColor(QColor newColor)
{
    m_pageOne->cb_navigatorBackgroundColor->setColor(newColor);
}

QColor ksubtilePreferences::getNavigatorBackgroundColor(void)
{
    return m_pageOne->cb_navigatorBackgroundColor->color();
}

///"Display Text"

void ksubtilePreferences::setNavigatorDisplayText(bool display)
{
    m_pageOne->cb_navigator_displayText->setChecked(display);
}

bool ksubtilePreferences::getNavigatorDisplayText()
{
    return m_pageOne->cb_navigator_displayText->isChecked();
}


////"MPlayer Position"

//returns the position where we want mplayer to appear

int ksubtilePreferences::getMPlayerPosition()
{
    if(m_pageTwo->rb_mplayer_topLeft->isChecked())
    {
        return posTopLeft;
    }
    if(m_pageTwo->rb_mplayer_topRight->isChecked())
    {
        return posTopRight;
    }
    if(m_pageTwo->rb_mplayer_bottomLeft->isChecked())
    {
        return posBottomLeft;
    }
    if(m_pageTwo->rb_mplayer_bottomRight->isChecked())
    {
        return posBottomRight;
    }
    return posTopLeft;
}

//used to initialize the dialog

void ksubtilePreferences::setMPlayerPosition(MPlayerPosition pos)
{
    switch(pos)
    {
    case posTopLeft:
        m_pageTwo->rb_mplayer_topLeft->setChecked(true);
        break;
    case posTopRight:
        m_pageTwo->rb_mplayer_topRight->setChecked(true);
        break;
    case posBottomLeft:
        m_pageTwo->rb_mplayer_bottomLeft->setChecked(true);
        break;
    case posBottomRight:
        m_pageTwo->rb_mplayer_bottomRight->setChecked(true);
        break;
    }
}

///"Automatic Resize"

void ksubtilePreferences::setMPlayerAutomaticResize(bool automatic)
{
    m_pageTwo->cb_mplayer_automaticResize->setChecked(automatic);
}

bool ksubtilePreferences::getMPlayerAutomaticResize()
{
    return m_pageTwo->cb_mplayer_automaticResize->isChecked();
}


QString ksubtilePreferences::getAudioOutputDriver()
{
    QPtrList<QListViewItem> list = m_pageTwo->lv_audioOutputDrivers->selectedItems();
    QListViewItem* item = list.first();
    return item->text(0);
}

void ksubtilePreferences::setAudioOutputDriver(QString driver)
{
    QListViewItem* lvItem = m_pageTwo->lv_audioOutputDrivers->findItem(driver, 0);
    if(lvItem != 0)
    {
        m_pageTwo->lv_audioOutputDrivers->setSelected(lvItem, true);
        m_pageTwo->lv_audioOutputDrivers->ensureItemVisible(lvItem);
    }
    else
    {
        //select first in list
        m_pageTwo->lv_audioOutputDrivers->setSelected(m_pageTwo->lv_audioOutputDrivers->itemAtIndex(0), true);
    }
}

QString ksubtilePreferences::getVideoOutputDriver()
{
    QPtrList<QListViewItem> list = m_pageTwo->lv_videoOutputDrivers->selectedItems();
    QListViewItem* item = list.first();
    return item->text(0);
}

void ksubtilePreferences::setVideoOutputDriver(QString driver)
{
    QListViewItem* lvItem = m_pageTwo->lv_videoOutputDrivers->findItem(driver, 0);
    if(lvItem != 0)
    {
        m_pageTwo->lv_videoOutputDrivers->setSelected(lvItem, true);
        m_pageTwo->lv_videoOutputDrivers->ensureItemVisible(lvItem);
    }
    else
    {
        //select first in list
        m_pageTwo->lv_videoOutputDrivers->setSelected(m_pageTwo->lv_videoOutputDrivers->itemAtIndex(0), true);
    }
}


void ksubtilePreferences::slotDefault()
{

    if(KMessageBox::warningContinueCancel(this, i18n("This will set the default options in ALL pages of the preferences dialog! Continue?"), i18n("Set default options?"),
                                          i18n("Set defaults"))==KMessageBox::Continue)
    {
        //set the default values

        //editor
        setDefaultAddNewLength(pref_DefaultAddNewLength);
        setNavigatorSubtitleColor(pref_NavigatorSubtitleColor);
        setNavigatorHighlightSubtitleColor(pref_NavigatorHighlightSubtitleColor);
        setNavigatorBackgroundColor(pref_NavigatorBackgroundColor);
        setNavigatorDisplayText(pref_NavigatorDisplayText);
        setDefaultPasteOffset(pref_DefaultPasteOffset);
	
        //mplayer
        setMPlayerPosition((MPlayerPosition) pref_MPlayerPosition);
        setMPlayerAutomaticResize(pref_MPlayerAutomaticResize);
        setAudioOutputDriver(pref_AudioOutputDriver());
        setVideoOutputDriver(pref_VideoOutputDriver());
    }


}

//add or own pages

ksubtilePrefPageOne::ksubtilePrefPageOne(QWidget *parent)
        : prefPageEditorDlg(parent)
{
    /*    QHBoxLayout *layout = new QHBoxLayout(this);
        layout->setAutoAdd(true);
     
        new QLabel(i18n("Add something here"), this);*/
}

void ksubtilePrefPageOne::te_editor_defaultOffset_valueChanged(const QTime & newTime)
{
 
    long newOffset = CSubtitles::getMSecs(newTime) + sb_editor_defaultOffset->value();

    if(newOffset < 1)
    {
	sb_editor_defaultOffset->setValue(1);		
	te_editor_defaultOffset->setTime( QTime(0,0,0) );
    }

}

void ksubtilePrefPageOne::sb_editor_defaultOffset_valueChanged(int newValue)
{
    long newOffset = CSubtitles::getMSecs(te_editor_defaultOffset->time()) + newValue;

    if(newOffset < 1)
    {
	sb_editor_defaultOffset->setValue(1);	
	te_editor_defaultOffset->setTime( QTime(0,0,0) );
    }
   
}

//MPLAYER

ksubtilePrefPageTwo::ksubtilePrefPageTwo(QWidget *parent)
        : prefPageMPlayerDlg(parent)
{
    /*    QHBoxLayout *layout = new QHBoxLayout(this);
        layout->setAutoAdd(true);
     
        new QLabel(i18n("Add something here"), this);*/

    lv_audioOutputDrivers->addColumn( i18n("Driver") );
    lv_audioOutputDrivers->addColumn( i18n("Description") );

    lv_videoOutputDrivers->addColumn( i18n("Driver") );
    lv_videoOutputDrivers->addColumn( i18n("Description") );

}

ksubtilePrefPageTwo::~ksubtilePrefPageTwo()
{}

void ksubtilePrefPageTwo::fillInAudioOutputDrivers()
{
    lv_audioOutputDrivers->clear();

    KProcess procAudio;

    procAudio << "mplayer" << "-ao" << "help";

    connect(&procAudio, SIGNAL(receivedStdout(KProcess *, char*,int)),
            this, SLOT(slotFillInAudioOutputDrivers(KProcess *, char*,int)));

    receivedAudio = "";

    procAudio.start(KProcess::Block, KProcess::All);

    procAudio.kill();

    //process the gathered output

    QStringList totalList = QStringList::split(QRegExp("\n"), receivedAudio);

    for ( QStringList::Iterator totalIt = totalList.begin(); totalIt != totalList.end(); ++totalIt )
    {
        if((*totalIt).contains(QRegExp( "^\t *" , false, false)) >= 1)
        {
            // 			printf("%s",(*totalIt).latin1());
            QStringList list = QStringList::split(QRegExp("\t"), (*totalIt));
            int i = 0;
            QString drivername = "null";
            for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
            {
                i++;
                if(i % 2 == 1)
                {
                    drivername = (*it).latin1();
                    // 				printf("output:%s\n", (*it).latin1());

                }
                else if(i % 2 == 0)
                {
                    new KListViewItem(lv_audioOutputDrivers, drivername, (*it).stripWhiteSpace().latin1());
                    // 				printf("descr:%s\n", (*it).latin1());
                }
            }
        }
    }
}

void ksubtilePrefPageTwo::fillInVideoOutputDrivers()
{
    lv_videoOutputDrivers->clear();

    KProcess procVideo;

    procVideo << "mplayer" << "-vo" << "help";

    connect(&procVideo, SIGNAL(receivedStdout(KProcess *, char*,int)),
            this, SLOT(slotFillInVideoOutputDrivers(KProcess *, char*,int)));

    receivedVideo = "";

    procVideo.start(KProcess::Block, KProcess::All);

    procVideo.kill();

    //process the gathered output

    QStringList totalList = QStringList::split(QRegExp("\n"), receivedVideo);

    for ( QStringList::Iterator totalIt = totalList.begin(); totalIt != totalList.end(); ++totalIt )
    {
        if((*totalIt).contains(QRegExp( "^\t *" , false, false)) >= 1)
        {
            // 			printf("%s",(*totalIt).latin1());
            QStringList list = QStringList::split(QRegExp("\t"), (*totalIt));
            int i = 0;
            QString drivername = "null";
            for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
            {
                i++;
                if(i % 2 == 1)
                {
                    drivername = (*it).latin1();
                    // 				printf("output:%s\n", (*it).latin1());

                }
                else if(i % 2 == 0)
                {
                    new KListViewItem(lv_videoOutputDrivers, drivername, (*it).stripWhiteSpace().latin1());
                    // 				printf("descr:%s\n", (*it).latin1());
                }
            }
        }
    }

}

void ksubtilePrefPageTwo::slotFillInAudioOutputDrivers(KProcess* /*proc*/, char* buf, int buflen)
{
    QString myBuf = QString::fromLatin1(buf, buflen);

    //printf("ontvangen:%s\n",myBuf.latin1());

    receivedAudio += myBuf;

}

void ksubtilePrefPageTwo::slotFillInVideoOutputDrivers(KProcess* /*proc*/, char* buf, int buflen)
{
    QString myBuf = QString::fromLatin1(buf, buflen);

    //    printf("\nontvangen:%s",myBuf.latin1());

    receivedVideo += myBuf;
}

#include "pref.moc"
