/***************************************************************************
                          calculator.cpp  -  description
                             -------------------
    begin                : Die Mai 28 2002
    copyright            : (C) 2002 by Luc Langehegermann
    email                : lx2gt@qsl.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <kstandarddirs.h>
#include <qfile.h>
#include <qtimer.h>
#include <qtextstream.h>

#include "calculator.h"


// this class does the same as our previous predict client - just calculates the values using
// the Propagator


calculator::calculator(QObject *parent, const char *name ) : QObject(parent,name) {
  count=0;  // init the counter
}
calculator::~calculator(){
}

/** initializes the calculator */
void calculator::init()
{
  satellite* sat;
  // create an fake qth
  char *satname, *line1, *line2;

  // open the keppler file
  QString filename = locate("appdata", "nasa.tle");

  // go through the file and create the list entries

  QFile f(filename);
  if ( f.open(IO_ReadOnly) ) {    // file opened successfully
    QTextStream t( &f );        // use a text stream
    while ( !t.eof() ) {        // until end of file...
      satname=strdup(t.readLine().stripWhiteSpace().latin1());
      line1=strdup(t.readLine().latin1());
      line2=strdup(t.readLine().latin1());
      sat = new satellite(satname);
      sat->propagator = new Propagator();
      sat->propagator->setTLE(line1, line2);
      satlist.append(sat);
      free(satname);
      free(line1);
      free(line2);
    }
    f.close();
   }

  // calc every second --> the tracking satellite is calculated more often - but not displayed that often

  QTimer *timer = new QTimer(this);
  QObject::connect (timer, SIGNAL(timeout()), this, SLOT(timeout()));
  timer->start(1000, false);
}
/** return the satellite list */
QList<satellite> calculator::satList(){
  return satlist;
}
/** return the observers QTH */
obsQTH* calculator::getObsQTH(){
  return qth;
}
/** called when we want to calculate */
void calculator::timeout(){
  satellite* sat;
  for(sat=satlist.first(); sat!=0; sat=satlist.next()) {
    if (sat->polled()) {
      sat->propagator->calc();
    }
  }
  emit calculated();
}
/** set the observers QTH */
void calculator::setObsQTH(obsQTH* q){
  qth=q;
  satellite* sat;
  // go through the satlist and change all the KepPropagators
  for(sat=satlist.first(); sat!=0; sat=satlist.next())
    sat->propagator->setQTH(qth->longitude(), qth->latitude(), qth->height());
}
