/***************************************************************************
                          hamlibwrapper.cpp  -  description
                             -------------------
    begin                : Thu Sep 5 2002
    copyright            : (C) 2002 by Luc Langehegermann
    email                : lx2gt@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <stdlib.h>
#include <kapplication.h>

#include "hamlibwrapper.h"

hamlibWrapper::hamlibWrapper() {
  uplinkRig=NULL;
  downlinkRig=NULL;
  rotor=NULL;
  morewait=0;
  samefreq=false;
  shouldexit=false;
  setmodes=false;
  resetpreamp=false;
  setuplink=false;
  setdownlink=false;
  rig_set_debug(RIG_DEBUG_NONE);
}
hamlibWrapper::~hamlibWrapper(){
  if (running()) {
    shouldexit=true;
    wait();
  }
  if (downlinkRig) {
    rig_close(downlinkRig);
    rig_cleanup(downlinkRig);
  }
  if (uplinkRig) {
    rig_close(uplinkRig);
    rig_cleanup(uplinkRig);
  }
}

/** No descriptions */
int hamlibWrapper::initRotor(rot_model_t r, const char* rotorport, int rotorspeed, bool flag450){
  azimuth_t maxazimuth;
  if (flag450)
    maxazimuth=450.0;
  else
    maxazimuth=360.0;
    
  if (rotor) {
    rot_close(rotor);
    rot_cleanup(rotor);
  }

  rotor = rot_init(r);
  if (rotor) {
    rotor->state.rotport.parm.serial.rate=rotorspeed;
    rotor->state.max_az=maxazimuth;
    strcpy(rotor->state.rotport.pathname, rotorport);
    rot_open(rotor);
    return 0;
  }
  else
    return -1;
}


/** No descriptions */
int hamlibWrapper::init (rig_model_t drig, const char* dport, int dspeed, rig_model_t urig, const char* uport, int uspeed){
  if (running()) {
    shouldexit=true;
    wait();
  }
  if (downlinkRig) {
    rig_close(downlinkRig);
    rig_cleanup(downlinkRig);
    downlinkRig=NULL;
  }
  if (uplinkRig) {
    rig_close(uplinkRig);
    rig_cleanup(uplinkRig);
    uplinkRig=NULL;
  }
  // first init the first radio - note: we always have the first one!
  // if we have no rig... simply init dummy rig! So, we do not have to care if we have an
  // rig or not!
  if (drig) downlinkRig=rig_init(drig);
  else downlinkRig=rig_init(RIG_MODEL_DUMMY);
  // set the parameters
    downlinkRig->state.rigport.parm.serial.rate=dspeed;
    strcpy(downlinkRig->state.rigport.pathname, dport);
  // open the rig
  if (rig_open(downlinkRig) != RIG_OK) {
    return -1;
  }
  
  // test if we use one or 2 rigs - if we use 1 exit with success

  if(uport == NULL) {
    uplinkRig=NULL;
    // only one rig - try to set the satmode
    rig_set_func (downlinkRig, RIG_VFO_NONE, RIG_FUNC_SATMODE, 1);
  }
  else {
    // open the second rig
    uplinkRig=rig_init(urig);
    uplinkRig->state.rigport.parm.serial.rate=uspeed;
    strcpy(downlinkRig->state.rigport.pathname, uport);
    if (rig_open(downlinkRig) != RIG_OK)
      return -1;
  }
  if (!running() && downlinkRig) start();
  return 0;
}
/** No descriptions */
unsigned long long hamlibWrapper::getDownlinkFrequency(){
    return getdlinkfreq;
}
/** No descriptions */
void hamlibWrapper::setFreqs(unsigned long long dlink, unsigned long long ulink, bool /*n*/){
  // I have commented out the mutex here.
  // There will be rare times where the frequency will actually run a bit
  // if the transponder is changed, but i think we can live with that

//  if (n) mutex.lock();
  if (abs(dlinkfreq-dlink) > 5 && dlink>0) {
    dlinkfreq=dlink;
    setdownlink=true;
  }
  if (abs(ulinkfreq-ulink) > 5) {
    ulinkfreq=ulink;
    setuplink=true;
  }

//  if (n) mutex.unlock();
}
/** No descriptions */
void hamlibWrapper::setModes(rmode_t dmode, rmode_t umode){
  setmodes=true;
  downmode=dmode;
  upmode=umode;
}

void hamlibWrapper::run() {
  // these are static (urgs) but we can only have on instance of this!
  static freq_t oldfreq=0, fr=0;
  for(;;) {
    if (shouldexit || !downlinkRig) {
      shouldexit=false;
      return;
    }

    // if we have the dummy device, be sure that we get exactly one run before we exit to save cpu power

    if (downlinkRig->caps->rig_model==RIG_MODEL_DUMMY)
      shouldexit=true;

    mutex.lock();
    if (setdownlink) {
      rig_set_freq(downlinkRig, RIG_VFO_MAIN, dlinkfreq);
      setdownlink=false;
    }

    morewait=0;
    rig_get_freq(downlinkRig, RIG_VFO_MAIN, &oldfreq);
            
    // if we have a second rig

    if (setuplink) {
      if (uplinkRig)
        rig_set_freq(uplinkRig, RIG_VFO_MAIN, ulinkfreq);
      else {
        // set the sub to the uplink freq - every rig the same here?
        rig_set_freq(downlinkRig, RIG_VFO_SUB, ulinkfreq);
        rig_set_vfo(downlinkRig, RIG_VFO_MAIN);
      }
      setuplink=false;
    }

    /* this is our get frequency code - it will try to find out if the user has changed the frequency */

    for (;;) {
      rig_get_freq(downlinkRig, RIG_VFO_MAIN, &fr);
      if (fr!=oldfreq) {
        morewait=10;
        samefreq=false;
      }
      else {
        morewait--;
        samefreq=true;
      }
      oldfreq=fr;
      getdlinkfreq=fr;
      if (morewait <0) {
        break;
      }
    }
    // check if we should set the modes
    if (setmodes) {
      setmodes=false;
      // downlink
      if (downlinkRig)
        rig_set_mode(downlinkRig, RIG_VFO_MAIN, downmode, 0);
      // uplink
      if (uplinkRig)
        rig_set_mode(uplinkRig, RIG_VFO_MAIN, upmode, 0);
      else
        rig_set_mode(downlinkRig, RIG_VFO_SUB, upmode, 0);
    }
    if (resetpreamp) {
      resetpreamp=false;
      rig_set_level(downlinkRig, RIG_VFO_MAIN, RIG_LEVEL_PREAMP, preampvalue);
    }
    mutex.unlock();
  }
}
/** No descriptions */
bool hamlibWrapper::userChangedFreq(){
  return samefreq;
}
/** No descriptions */
void hamlibWrapper::setPause(bool p){
  if (downlinkRig->caps->rig_model==RIG_MODEL_DUMMY)
    return;
    
  shouldexit=p;
  if (!p && !running())
    start();
}
/** No descriptions */
void hamlibWrapper::setPreamp (bool e){
  int i=0;
  if (e) {
    while (downlinkRig->caps->preamp[i] != RIG_DBLST_END)
      ++i;
    if (i!=0) --i;
    preampvalue.i = downlinkRig->caps->preamp[i];
  }
  else
    preampvalue.i = 0;

  resetpreamp=true;
}

/** No descriptions */
void hamlibWrapper::setDirection(azimuth_t az, elevation_t el){
  if (rotor) {
    rot_set_position(rotor, az, el);
  }
}
