/***************************************************************************
                          transponderdefinition.cpp  -  description
                             -------------------
    begin                : Wed May 15 2002
    copyright            : (C) 2002 by Luc Langehegermann
    email                : lx2gt@qsl.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <unistd.h>
#include <kapp.h>
#include <qtable.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qpushbutton.h>
#include <klocale.h>

#include "globals.h"
#include "transponderdefinition.h"

transponderDefinition::transponderDefinition(QWidget *parent, const char *name, bool modal, WFlags fl) : transponderDefinitionBase(parent,name,modal,fl) {
  // modify the table as we need it
  transponderTable->setNumRows(150);
  transponderTable->setNumCols(8);
  transponderTable->horizontalHeader()->setLabel(0, i18n("Satellite"));
  transponderTable->horizontalHeader()->setLabel(1, i18n("Uplink"));
  transponderTable->horizontalHeader()->setLabel(2, i18n("Downlink"));
  transponderTable->horizontalHeader()->setLabel(3, i18n("Uplink offset"));
  transponderTable->horizontalHeader()->setLabel(4, i18n("Downlink offset"));
  transponderTable->horizontalHeader()->setLabel(5, i18n("Mode"));
  transponderTable->horizontalHeader()->setLabel(6, "");
  transponderTable->horizontalHeader()->setLabel(7, "");

  QObject::connect(buttonOk, SIGNAL(clicked()), this, SLOT(slotOk()));
  QObject::connect(buttonCancel, SIGNAL(clicked()), this, SLOT(slotCancel()));
}

transponderDefinition::~transponderDefinition(){
}
/** No descriptions */
void transponderDefinition::setSatList(QList<satellite> l){
  QComboTableItem* combo;
  QCheckTableItem* check;
  QString str;
  satlist=l;
  satellite* sat;
  QList<transponder> list;
  transponder* trans;
  int i;
  QStringList satnames, modenames;
  modenames << "SSB" << "FM" << "CW";
  satnames << i18n("none");
  // build a list of all possible satellites
  for(sat=satlist.first(); sat!=0; sat=satlist.next())
    satnames << sat->name();
  for (i=0; i<150; ++i) {
    transponderTable->setItem(i, 0, new QComboTableItem(transponderTable, satnames));
    transponderTable->setItem(i, 5, new QComboTableItem(transponderTable, modenames));
    transponderTable->setItem(i, 6, new QCheckTableItem(transponderTable, i18n("Reverse")));
    transponderTable->setItem(i, 7, new QCheckTableItem(transponderTable, i18n("Pre Amp")));
  }
  // fill in the current values
  i=0;
  for(sat=satlist.first(); sat!=0; sat=satlist.next()) {
    list=*sat->translist();
    for(trans=list.first();trans!=0; trans=list.next()) {
      combo = (QComboTableItem*) transponderTable->item(i, 0);
      combo->setCurrentItem(sat->name());
      transponderTable->setText(i, 1, longlongToQString(trans->uplink()));
      transponderTable->setText(i, 2, longlongToQString(trans->downlink()));
      transponderTable->setText(i, 3, longlongToQString(trans->updiff()));
      transponderTable->setText(i, 4, longlongToQString(trans->downdiff()));
      combo = (QComboTableItem*) transponderTable->item(i, 5);
      if(trans->mode() == MODE_SSB) combo->setCurrentItem("SSB");
      if(trans->mode() == MODE_FM)  combo->setCurrentItem("FM");
      if(trans->mode() == MODE_CW)  combo->setCurrentItem("CW");
      check = (QCheckTableItem*) transponderTable->item(i, 6);
      if(trans->reverse()) check->setChecked(true);
      check = (QCheckTableItem*) transponderTable->item(i, 7);
      if(trans->preamp()) check->setChecked(true);

      ++i;
    }
  }

}
/** No descriptions */

void transponderDefinition::slotOk()
{
  satellite* sat;
  transponder* trans;
  QComboTableItem* combo;
  QCheckTableItem* check;
  QString str;
  int i;

  // clear the transponders

  for(sat=satlist.first(); sat!=0; sat=satlist.next())
    sat->translist()->clear();

  for(i=0; i<150; ++i) {
    combo = (QComboTableItem*)transponderTable->item(i, 0);
    if (combo->currentText() != "none") {
      // get the satellite
      for(sat=satlist.first(); sat!=0; sat=satlist.next()) {

        if(sat->name() == combo->currentText()) {
          trans=new transponder();
          str = transponderTable->text(i, 1);
          trans->setUplink(QStringToLongLong(str));
          str = transponderTable->text(i, 2);
          trans->setDownlink(QStringToLongLong(str));
          str = transponderTable->text(i, 3);
          trans->setUpdiff (QStringToLongLong(str));
          str = transponderTable->text(i, 4);
          trans->setDowndiff(QStringToLongLong(str));
          combo = (QComboTableItem*) transponderTable->item(i, 5);
          str = combo->currentText();
          if (str == "SSB") trans->setMode(MODE_SSB);
          if (str == "FM") trans->setMode(MODE_FM);
          if (str == "CW") trans->setMode(MODE_CW);
          check = (QCheckTableItem*) transponderTable->item(i, 6);
          trans->setReverse(check->isChecked());
          check = (QCheckTableItem*) transponderTable->item(i, 7);
          trans->setPreamp(check->isChecked());

          sat->translist()->append(trans);
        }
      }
    }
  accept();
  }
}
/** No descriptions */

void transponderDefinition::slotCancel(){
  reject();
}

