/***************************************************************************
 *   Copyright (C) 2006 by Raul Fernandes                                  *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "dictionarydialog.h"

#include <qlineedit.h>
#include <qcombobox.h>

#include <kurlrequester.h>

DictionaryDialog::DictionaryDialog() : DictionaryDialogBase()
{
  connect( pluginCombo, SIGNAL( activated( int ) ), this, SLOT( itemChanged( int ) ) );
}

DictionaryDialog::~DictionaryDialog()
{
}


QString DictionaryDialog::dicName()
{
  return nameEdit->text();
}


QString DictionaryDialog::dicPlugin()
{
  int pluginId = pluginCombo->currentItem();
  if( pluginId == 0 ) return "ktranslator_plaintext";
  else if( pluginId == 1 ) return "ktranslator_dictd";
  else if( pluginId == 2 ) return "ktranslator_babylon";
  else if( pluginId == 3 ) return "ktranslator_stardict";
  else return "ktranslator_sdict";
}


QString DictionaryDialog::dicFile()
{
  return fileRequester->url();
}


void DictionaryDialog::setDicName( const QString &name )
{
  nameEdit->setText( name );
}


void DictionaryDialog::setDicFile( const QString &file )
{
  fileRequester->setURL( file );
}


void DictionaryDialog::setDicPlugin( const QString &plugin )
{
  int pluginId ;
  if( plugin == "ktranslator_plaintext" ) pluginId = 0;
  else if( plugin == "ktranslator_dictd" ) pluginId = 1;
  else if( plugin == "ktranslator_babylon" ) pluginId = 2;
  else if( plugin == "ktranslator_stardict" ) pluginId = 3;
  else pluginId = 4;// "ktranslator_sdict"
  pluginCombo->setCurrentItem( pluginId );
  itemChanged( pluginId );
}

void DictionaryDialog::itemChanged( int item )
{
  if( item == 0 ) fileRequester->setFilter( "*.dic|Plain Text files" );
  else if( item == 1 ) fileRequester->setFilter( "*.index|Index DICT files" );
  else if( item == 2 ) fileRequester->setFilter( "*.dic|Babylon Dictionary files" );
  else if( item == 3 ) fileRequester->setFilter( "*.ifo|StarDict Dictionary files" );
  else if( item == 4 ) fileRequester->setFilter( "*.dct|Sdictionary Dictionary files" );
}
