// =============================================================================
//
//      --- kvi_mainwindow_qt.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_mainwindow_qt.h"

#define NUM_DOCKSITES 7

static Qt::Dock g_dockSites[NUM_DOCKSITES] = {
	Qt::DockTop,
	Qt::DockBottom,
	Qt::DockLeft,
	Qt::DockRight,
	Qt::DockTornOff,
	Qt::DockMinimized,
	Qt::DockUnmanaged
};

KviMainWindow::KviMainWindow(QWidget *parent, const char *name)
	: QMainWindow(parent, name)
{
	// Nothing here
}

KviMainWindow::~KviMainWindow()
{
	// Nothing here
}

void KviMainWindow::showDockWindow(QDockWindow *dockWindow, Dock edge, bool nl, int index, int extraOffset)
{
	dockWindow->show();
	moveDockWindow(dockWindow, edge, nl, index, extraOffset);
}

void KviMainWindow::showDockWindow(QDockWindow *dockWindow)
{
	dockWindow->show();
}

void KviMainWindow::hideDockWindow(QDockWindow *dockWindow)
{
	dockWindow->hide();
}

QPtrListIterator<KviToolBar> KviMainWindow::toolBarIterator()
{
	QPtrList<KviToolBar> list;

	for( int i = 0; i < NUM_DOCKSITES; i++ ) {
		QPtrList<QToolBar> l = toolBars(g_dockSites[i]);
		for( QToolBar *tb = l.first(); tb; tb = l.next() ) {
			list.append((KviToolBar *) tb);
		}
	}

	return QPtrListIterator<KviToolBar> (list);
}

#include "m_kvi_mainwindow_qt.moc"
