#ifndef _KVI_DIRVIEW_H_INCLUDED_
#define _KVI_DIRVIEW_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dirview.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_iconview.h"
#include "kvi_string.h"

class KviPopupMenu;

class KviDirectoryView : public KviIconView
{
	Q_OBJECT
public:
	KviDirectoryView(QWidget *parent, KviFrame *lpFrm);
	~KviDirectoryView();
public:
	KviStr    m_szDirPath;
	KviFrame *m_pFrm;
protected:
	KviPopupMenu *m_pContextPopup;
protected:
	virtual QDragObject *dragObject();
public:
	void applyOptions();
protected slots:
	void itemDropped(QDropEvent *, const QValueList<QIconDragItem> &lst);
	void emitNeedUpdate();
	void showContextMenu(QIconViewItem *, const QPoint &pos);
	void trashSelectedFiles();
	void openWithEditorSelectedFiles();
	void dirItemRenamed(QIconViewItem *, const QString &text);
signals:
	void needUpdate();
};

#endif // _KVI_DIRVIEW_H_INCLUDED_
