// =============================================================================
//
//      --- kvi_asyncmessagebox.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviAsyncMessageBox"

#include "kvi_app.h"
#include "kvi_asyncmessagebox.h"

KviAsyncMessageBox::KviAsyncMessageBox(
	KviUserParser *parser, KviWindow *pWnd,
	const char *caption, const char *text, const char *icon, const char *btn1)
	: KviMessageBox(caption, text, NoIcon, Ok, 0, 0, 0, 0, false)
	, KviAsyncDialog(parser, pWnd)
{
	setButtonText(Ok, btn1);
	doSetIcon(icon);
}

KviAsyncMessageBox::KviAsyncMessageBox(
	KviUserParser *parser, KviWindow *pWnd,
	const char *caption, const char *text, const char *icon, const char *btn1, const char *btn2)
	: KviMessageBox(caption, text, NoIcon, Ok, No, 0, 0, 0, false)
	, KviAsyncDialog(parser, pWnd)
{
	setButtonText(Ok, btn1);
	setButtonText(No, btn2);
	doSetIcon(icon);
}

KviAsyncMessageBox::KviAsyncMessageBox(
	KviUserParser *parser, KviWindow *pWnd,
	const char *caption, const char *text, const char *icon, const char *btn1, const char *btn2, const char *btn3)
	: KviMessageBox(caption, text, NoIcon, Ok, No, Cancel, 0, 0, false)
	, KviAsyncDialog(parser, pWnd)
{
	setButtonText(Ok, btn1);
	setButtonText(No, btn2);
	setButtonText(Cancel, btn3);
	doSetIcon(icon);
}

KviAsyncMessageBox::~KviAsyncMessageBox()
{
	// Nothing here
}

void KviAsyncMessageBox::done(int r)
{
	KviMessageBox::done(r);
	KviStr szRes = "1";
	if( r == No )
		szRes = "2";
	else if( r == Cancel )
		szRes = "3";
	runJob(szRes.ptr());
	g_pApp->destroyLater(this);
}

void KviAsyncMessageBox::doSetIcon(const char *iconDescription)
{
	if( kvi_strEqualCIN(iconDescription, "info", 4) ) { // Information
		setIcon(Information);
		return;
	}
	if( kvi_strEqualCIN(iconDescription, "warn", 4) ) { // Warning
		setIcon(Warning);
		return;
	}
	if( kvi_strEqualCIN(iconDescription, "crit", 4) ) { // Critical
		setIcon(Critical);
		return;
	}
}

#include "m_kvi_asyncmessagebox.moc"
