#ifndef _KVI_REGUSERSDB_H_INCLUDED_
#define _KVI_REGUSERSDB_H_INCLUDED_

// =============================================================================
//
//      --- kvi_regusersdb.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_irc_user.h"
#include "kvi_string.h"

typedef struct KviRegisteredUser
{
	KviIrcUser user;
	KviStr     allFlags;
	KviStr     passwd;
	KviStr     comment;
	char       bNotify;
	char       bIgnore;
};

class KviRegisteredUsersDb
{
public:
	KviRegisteredUsersDb();
	~KviRegisteredUsersDb();
public:
	QPtrList<KviRegisteredUser> *m_pRegList;
public:
	void   registerUser(KviRegisteredUser *, const char *flags);
	void unregisterUser(KviRegisteredUser *);
	void clear();

	KviRegisteredUser *findUserByMask        (const char *mask);
	KviRegisteredUser *findIgnoredUserByMask (const char *mask);
	KviRegisteredUser *findUserWithFlagByMask(const char *mask, char flag);
	KviRegisteredUser *findExactMatch        (const char *mask);

	bool load(const char *filename, KviStr &error);
	bool save(const char *filename);

	void  getWatchString(KviStr &buf);
	void getNotifyString(KviStr &buf);

	void      getFlags(const char *mask, KviStr &buf);
	void getFlagsExact(const char *mask, KviStr &buf);

	void    addFlags(KviRegisteredUser *, const char *flags);
	void    setFlags(KviRegisteredUser *, const char *flags);
	void deleteFlags(KviRegisteredUser *, const char *flags);
	void   setPasswd(KviRegisteredUser *, const char *passwd);
	void   getPasswd(KviRegisteredUser *, KviStr &buf);
	void  setComment(KviRegisteredUser *, const char *comment);
	void  getComment(KviRegisteredUser *, KviStr &buf);
};

#endif // _KVI_REGUSERSDB_H_INCLUDED_
