// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Andrea Parrella (anandrea@iname.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviUrlConfigDialog"

#define _KVI_URL_CONFIGDIALOG_CPP_

#include <qcheckbox.h>
#include <qlayout.h>

#ifdef QT_NO_ASCII_CAST
	#undef QT_NO_ASCII_CAST
#endif

#include "kvi_config.h"
#include "kvi_locale.h"
#include "kvi_pushbutton.h"
#include "kvi_url.h"
#include "kvi_url_banframe.h"
#include "kvi_url_configdialog.h"

/**
 * KviUrlConfigDialog.
 */
KviUrlConfigDialog::KviUrlConfigDialog()
	: KviDialog()
{
	setCaption(_i18n_("URL Plugin Configuration"));

	QGridLayout *g = new QGridLayout(this, 4, 2, 10, 10);

	KviConfig *cfg = new KviConfig(g_configPath.ptr());
	cfg->setGroup("ConfigDialog");

	cb[0] = new QCheckBox(_i18n_("Save URL list on plugin unload"), this);
	cb[0]->setChecked(cfg->readBoolEntry("SaveUrlListOnUnload", false));
	g->addMultiCellWidget(cb[0], 0, 0, 0, 1);

	cb[1] = new QCheckBox(_i18n_("Save columns width on URL list close"), this);
	cb[1]->setChecked(cfg->readBoolEntry("SaveColumnWidthOnClose", false));
	g->addMultiCellWidget(cb[1], 1, 1, 0, 1);

	cb[2] = new QCheckBox(_i18n_("Load URL toolbar on startup"), this);
	cb[2]->setChecked(cfg->readBoolEntry("LoadUrlToolbarOnStartup", false));
	g->addMultiCellWidget(cb[2], 2, 2, 0, 1);

	bool tmp = cfg->readBoolEntry("BanEnabled", false);
	delete cfg;

	m_pBanFrame = new KviUrlBanFrame(this, "banlist", tmp);
	g->addMultiCellWidget(m_pBanFrame, 3, 3, 0, 1);

	KviPushButton *b;
	// Configure buttons
	b = new KviPushButton(_i18n_("&Cancel"), this, "discard");
	connect(b, SIGNAL(clicked()), this, SLOT(discardbtn()));
	g->addWidget(b, 4, 0);

	b = new KviPushButton(_i18n_("&OK"), this, "accept");
	connect(b, SIGNAL(clicked()), this, SLOT(acceptbtn()));
	g->addWidget(b, 4, 1);

	show();
}

void KviUrlConfigDialog::discardbtn()
{
	delete this;
}

void KviUrlConfigDialog::acceptbtn()
{
	if( m_pBanFrame ) m_pBanFrame->saveBans();

	KviConfig *cfg = new KviConfig(g_configPath.ptr());
	cfg->setGroup("ConfigDialog");
	cfg->writeEntry("SaveUrlListOnUnload",     cb[0]->isChecked());
	cfg->writeEntry("SaveColumnWidthOnClose",  cb[1]->isChecked());
	cfg->writeEntry("LoadUrlToolbarOnStartup", cb[2]->isChecked());
	delete cfg;

	delete this;
}

void KviUrlConfigDialog::closeEvent(QCloseEvent *)
{
	delete this;
}

KviUrlConfigDialog::~KviUrlConfigDialog()
{
	for( int i = 0; i < CBNUM; i++ ) {
		delete cb[i];
		cb[i] = 0;
	}
	g_pConfigDialog = 0;
}

#include "m_kvi_url_configdialog.moc"
