/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkeydialog.h"

KKeyDialog::KKeyDialog( QString preset, QWidget *parent, QString caption ) : KDialogBase( parent, "keyDialog", true, caption, KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	QWidget *page = new QWidget( this );
	setMainWidget( page );

	QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

	QHButtonGroup* buttongroup = new QHButtonGroup( "Key type", page );

	hexButton = new QRadioButton( "hex digits", buttongroup );
	asciiButton = new QRadioButton( "ascii string", buttongroup );
	loginButton = new QRadioButton( "user:password", buttongroup );
	hexButton->setChecked( true );
	buttongroup->adjustSize();
	topLayout->addWidget( buttongroup );
	
	QHBoxLayout *inputLayout = new QHBoxLayout( topLayout, spacingHint() );
	QLabel* label = new QLabel( "Key:", page );
	keyEdit = new KLineEdit( page );
	keyEdit->setText( preset );
	inputLayout->addWidget( label );
	inputLayout->addWidget( keyEdit );

	page->adjustSize();
	
	disableResize();

	keyEdit->setFocus();
}


KKeyDialog::~KKeyDialog()
{
}


/*!
    \fn KKeyDialog::getKeyType()
 */
KeyType KKeyDialog::getKeyType()
{
	if( hexButton->isChecked() )
	{
		return HEX;
	}
	if( asciiButton->isChecked() )
	{
		return ASCII;
	}
	return LOGIN;
}


/*!
    \fn KKeyDialog::getKey()
 */
QString KKeyDialog::getKey()
{
	return keyEdit->text();
}


#include "kkeydialog.moc"
