/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTRAFFICWIDGET_H
#define KTRAFFICWIDGET_H

#include <qwidget.h>
#include <qpainter.h>

/**
@author Matthias Reif
*/

#define SENT 0
#define RECV 1

class KTrafficWidget : public QWidget
{
Q_OBJECT
public:
	KTrafficWidget( int numValues, QWidget *parent = 0, const char *name = 0 );

	~KTrafficWidget();
	
	void push( long sent, long recv );
	
	void paintDiagramm();
	
	void setMaxValue( long value) { maxValue = value; }
	void clear();
	
protected:
	int numValues;
	long *values[2];
	int index;

	int numLines;
	long maxValue;
	virtual void paintEvent( QPaintEvent * );
};

#endif
